/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream;

import java.util.Random;
import org.red5.server.api.stream.IPlaylist;
import org.red5.server.api.stream.IPlaylistController;

public class SimplePlaylistController
implements IPlaylistController {
    public int nextItem(IPlaylist playlist, int itemIndex) {
        if (itemIndex < 0) {
            itemIndex = -1;
        }
        if (playlist.isRepeat()) {
            return itemIndex;
        }
        if (playlist.isRandom()) {
            int lastIndex = itemIndex;
            if (playlist.getItemSize() > 1) {
                Random rand = new Random();
                while (itemIndex == lastIndex) {
                    itemIndex = rand.nextInt(playlist.getItemSize());
                }
            }
            return itemIndex;
        }
        int nextIndex = itemIndex + 1;
        if (nextIndex < playlist.getItemSize()) {
            return nextIndex;
        }
        if (playlist.isRewind()) {
            return playlist.getItemSize() > 0 ? 0 : -1;
        }
        return -1;
    }

    public int previousItem(IPlaylist playlist, int itemIndex) {
        if (itemIndex > playlist.getItemSize()) {
            return playlist.getItemSize() - 1;
        }
        if (playlist.isRepeat()) {
            return itemIndex;
        }
        if (playlist.isRandom()) {
            Random rand = new Random();
            int lastIndex = itemIndex;
            while (itemIndex == lastIndex) {
                itemIndex = rand.nextInt(playlist.getItemSize());
            }
            lastIndex = itemIndex;
            return itemIndex;
        }
        int prevIndex = itemIndex - 1;
        if (prevIndex >= 0) {
            return prevIndex;
        }
        if (playlist.isRewind()) {
            return playlist.getItemSize() - 1;
        }
        return -1;
    }
}

