/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.red5.server.api.IScope;
import org.red5.server.api.ScopeUtils;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.red5.server.api.stream.IPlayItem;
import org.red5.server.api.stream.IPlaylistController;
import org.red5.server.api.stream.IServerStream;
import org.red5.server.api.stream.IStreamAwareScopeHandler;
import org.red5.server.api.stream.IStreamFilenameGenerator;
import org.red5.server.api.stream.ResourceExistException;
import org.red5.server.api.stream.ResourceNotFoundException;
import org.red5.server.messaging.IFilter;
import org.red5.server.messaging.IMessage;
import org.red5.server.messaging.IMessageComponent;
import org.red5.server.messaging.IMessageInput;
import org.red5.server.messaging.IMessageOutput;
import org.red5.server.messaging.IPassive;
import org.red5.server.messaging.IPipe;
import org.red5.server.messaging.IPipeConnectionListener;
import org.red5.server.messaging.IProvider;
import org.red5.server.messaging.IPushableConsumer;
import org.red5.server.messaging.InMemoryPushPushPipe;
import org.red5.server.messaging.OOBControlMessage;
import org.red5.server.messaging.PipeConnectionEvent;
import org.red5.server.net.rtmp.event.AudioData;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.event.VideoData;
import org.red5.server.stream.AbstractStream;
import org.red5.server.stream.DefaultStreamFilenameGenerator;
import org.red5.server.stream.IProviderService;
import org.red5.server.stream.ISeekableProvider;
import org.red5.server.stream.SimplePlaylistController;
import org.red5.server.stream.consumer.FileConsumer;
import org.red5.server.stream.message.RTMPMessage;
import org.red5.server.stream.message.ResetMessage;

public class ServerStream
extends AbstractStream
implements IServerStream,
IFilter,
IPushableConsumer,
IPipeConnectionListener {
    private static final Log log = LogFactory.getLog(ServerStream.class);
    private State state;
    private String publishedName;
    private IPlaylistController controller;
    private IPlaylistController defaultController = new SimplePlaylistController();
    private boolean isRewind;
    private boolean isRandom;
    private boolean isRepeat;
    private List<IPlayItem> items = new ArrayList<IPlayItem>();
    private int currentItemIndex;
    private IPlayItem currentItem;
    private IMessageInput msgIn;
    private IMessageOutput msgOut;
    private IPipe recordPipe;
    private String recordingFilename;
    private ISchedulingService scheduler;
    private String liveJobName;
    private String vodJobName;
    private long vodStartTS;
    private long serverStartTS;
    private long nextVideoTS;
    private long nextAudioTS;
    private long nextDataTS;
    private long nextTS;
    private RTMPMessage nextRTMPMessage;

    public ServerStream() {
        this.state = State.UNINIT;
    }

    public synchronized void addItem(IPlayItem item) {
        this.items.add(item);
    }

    public synchronized void addItem(IPlayItem item, int index) {
        this.items.add(index, item);
    }

    public synchronized void removeItem(int index) {
        if (index < 0 || index >= this.items.size()) {
            return;
        }
        this.items.remove(index);
    }

    public synchronized void removeAllItems() {
        this.items.clear();
    }

    public int getItemSize() {
        return this.items.size();
    }

    public int getCurrentItemIndex() {
        return this.currentItemIndex;
    }

    public IPlayItem getCurrentItem() {
        return this.currentItem;
    }

    public IPlayItem getItem(int index) {
        try {
            return this.items.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public synchronized void previousItem() {
        this.stop();
        this.moveToPrevious();
        if (this.currentItemIndex == -1) {
            return;
        }
        IPlayItem item = this.items.get(this.currentItemIndex);
        this.play(item);
    }

    public synchronized boolean hasMoreItems() {
        int nextItem = this.currentItemIndex + 1;
        return nextItem < this.items.size() || this.isRepeat;
    }

    public synchronized void nextItem() {
        this.stop();
        this.moveToNext();
        if (this.currentItemIndex == -1) {
            return;
        }
        IPlayItem item = this.items.get(this.currentItemIndex);
        this.play(item);
    }

    public synchronized void setItem(int index) {
        if (index < 0 || index >= this.items.size()) {
            return;
        }
        this.stop();
        this.currentItemIndex = index;
        IPlayItem item = this.items.get(this.currentItemIndex);
        this.play(item);
    }

    public boolean isRandom() {
        return this.isRandom;
    }

    public void setRandom(boolean random) {
        this.isRandom = random;
    }

    public boolean isRewind() {
        return this.isRewind;
    }

    public void setRewind(boolean rewind) {
        this.isRewind = rewind;
    }

    public boolean isRepeat() {
        return this.isRepeat;
    }

    public void setRepeat(boolean repeat) {
        this.isRepeat = repeat;
    }

    public void setPlaylistController(IPlaylistController controller) {
        this.controller = controller;
    }

    public void saveAs(String name, boolean isAppend) throws IOException, ResourceNotFoundException, ResourceExistException {
        try {
            IScope scope = this.getScope();
            IStreamFilenameGenerator generator = (IStreamFilenameGenerator)ScopeUtils.getScopeService(scope, IStreamFilenameGenerator.class, DefaultStreamFilenameGenerator.class);
            String filename = generator.generateFilename(scope, name, ".flv", IStreamFilenameGenerator.GenerationType.RECORD);
            File file = generator.resolvesToAbsolutePath() ? new File(filename) : scope.getContext().getResource(filename).getFile();
            if (!isAppend) {
                if (file.exists() && !file.delete()) {
                    throw new IOException("file could not be deleted");
                }
            } else if (!file.exists()) {
                isAppend = false;
            }
            if (!file.exists()) {
                File tmp;
                String path = file.getAbsolutePath();
                int slashPos = path.lastIndexOf(File.separator);
                if (slashPos != -1) {
                    path = path.substring(0, slashPos);
                }
                if (!(tmp = new File(path)).isDirectory()) {
                    tmp.mkdirs();
                }
            }
            if (!file.exists()) {
                if (!file.canWrite()) {
                    log.warn((Object)("File cannot be written to " + file.getCanonicalPath()));
                }
                file.createNewFile();
            }
            FileConsumer fc = new FileConsumer(scope, file);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            if (isAppend) {
                paramMap.put("mode", "append");
            } else {
                paramMap.put("mode", "record");
            }
            if (null == this.recordPipe) {
                this.recordPipe = new InMemoryPushPushPipe();
            }
            this.recordPipe.subscribe(fc, paramMap);
            this.recordingFilename = filename;
        }
        catch (IOException e) {
            log.warn((Object)"Save as exception", (Throwable)e);
        }
    }

    public String getSaveFilename() {
        return this.recordingFilename;
    }

    public IProvider getProvider() {
        return this;
    }

    public String getPublishedName() {
        return this.publishedName;
    }

    public void setPublishedName(String name) {
        this.publishedName = name;
    }

    public void start() {
        if (this.state != State.UNINIT) {
            throw new IllegalStateException("State " + (Object)((Object)this.state) + " not valid to start");
        }
        if (this.items.size() == 0) {
            throw new IllegalStateException("At least one item should be specified to start");
        }
        if (this.publishedName == null) {
            throw new IllegalStateException("A published name is needed to start");
        }
        IProviderService providerService = (IProviderService)this.getScope().getContext().getBean("providerService");
        providerService.registerBroadcastStream(this.getScope(), this.publishedName, this);
        HashMap<String, Object> recordParamMap = new HashMap<String, Object>();
        this.recordPipe = new InMemoryPushPushPipe();
        recordParamMap.put("record", null);
        this.recordPipe.subscribe(this, (Map)recordParamMap);
        this.recordingFilename = null;
        this.scheduler = (ISchedulingService)this.getScope().getContext().getBean("schedulingService");
        this.state = State.STOPPED;
        this.currentItemIndex = -1;
        this.nextItem();
    }

    public synchronized void stop() {
        if (this.state != State.PLAYING && this.state != State.PAUSED) {
            return;
        }
        if (this.liveJobName != null) {
            this.scheduler.removeScheduledJob(this.liveJobName);
            this.liveJobName = null;
        }
        if (this.vodJobName != null) {
            this.scheduler.removeScheduledJob(this.vodJobName);
            this.vodJobName = null;
        }
        if (this.msgIn != null) {
            this.msgIn.unsubscribe(this);
            this.msgIn = null;
        }
        if (this.nextRTMPMessage != null) {
            this.nextRTMPMessage.getBody().release();
        }
        this.state = State.STOPPED;
    }

    public void pause() {
        if (this.state == State.PLAYING) {
            this.state = State.PAUSED;
        } else if (this.state == State.PAUSED) {
            this.state = State.PLAYING;
            this.vodStartTS = 0L;
            this.serverStartTS = System.currentTimeMillis();
            this.scheduleNextMessage();
        }
    }

    public void seek(int position) {
        if (this.state != State.PLAYING && this.state != State.PAUSED) {
            return;
        }
        this.sendVODSeekCM(this.msgIn, position);
    }

    public synchronized void close() {
        if (this.state == State.PLAYING || this.state == State.PAUSED) {
            this.stop();
        }
        if (this.msgOut != null) {
            this.msgOut.unsubscribe(this);
        }
        this.recordPipe.unsubscribe(this);
        this.notifyBroadcastClose();
        this.state = State.CLOSED;
    }

    public void onOOBControlMessage(IMessageComponent source, IPipe pipe, OOBControlMessage oobCtrlMsg) {
    }

    public void pushMessage(IPipe pipe, IMessage message) throws IOException {
        this.pushMessage(message);
    }

    public void onPipeConnectionEvent(PipeConnectionEvent event) {
        switch (event.getType()) {
            case 1: {
                if (event.getProvider() != this || event.getParamMap() != null && event.getParamMap().containsKey("record")) break;
                this.msgOut = (IMessageOutput)event.getSource();
                break;
            }
            case 2: {
                if (this.msgOut != event.getSource()) break;
                this.msgOut = null;
                break;
            }
        }
    }

    private void play(IPlayItem item) {
        if (this.state != State.STOPPED) {
            return;
        }
        boolean isLive = false;
        IProviderService providerService = (IProviderService)this.getScope().getContext().getBean("providerService");
        this.msgIn = providerService.getVODProviderInput(this.getScope(), item.getName());
        if (this.msgIn == null) {
            this.msgIn = providerService.getLiveProviderInput(this.getScope(), item.getName(), true);
            isLive = true;
        }
        if (this.msgIn == null) {
            log.warn((Object)"ABNORMAL Can't get both VOD and Live input from providerService");
            return;
        }
        this.state = State.PLAYING;
        this.currentItem = item;
        this.sendResetMessage();
        this.msgIn.subscribe(this, null);
        if (isLive) {
            if (item.getLength() >= 0L) {
                this.liveJobName = this.scheduler.addScheduledOnceJob(item.getLength(), new IScheduledJob(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void execute(ISchedulingService service) {
                        ServerStream serverStream = ServerStream.this;
                        synchronized (serverStream) {
                            if (ServerStream.this.liveJobName == null) {
                                return;
                            }
                            ServerStream.this.liveJobName = null;
                            ServerStream.this.onItemEnd();
                        }
                    }
                });
            }
        } else {
            long start = item.getStart();
            if (start < 0L) {
                start = 0L;
            }
            this.sendVODInitCM(this.msgIn, (int)start);
            this.startBroadcastVOD();
        }
    }

    private void onItemEnd() {
        this.nextItem();
    }

    private void pushMessage(IMessage message) throws IOException {
        this.msgOut.pushMessage(message);
        this.recordPipe.pushMessage(message);
    }

    private void sendResetMessage() {
        try {
            this.pushMessage(new ResetMessage());
        }
        catch (IOException err) {
            log.error((Object)"Error while sending reset message.", (Throwable)err);
        }
    }

    private void startBroadcastVOD() {
        this.nextDataTS = 0L;
        this.nextAudioTS = 0L;
        this.nextVideoTS = 0L;
        this.nextRTMPMessage = null;
        this.vodStartTS = 0L;
        this.serverStartTS = System.currentTimeMillis();
        IStreamAwareScopeHandler handler = this.getStreamAwareHandler();
        if (handler != null) {
            if (this.recordingFilename != null) {
                handler.streamRecordStart(this);
            } else {
                handler.streamPublishStart(this);
            }
        }
        this.notifyBroadcastStart();
        this.scheduleNextMessage();
    }

    private void notifyBroadcastClose() {
        IStreamAwareScopeHandler handler = this.getStreamAwareHandler();
        if (handler != null) {
            try {
                handler.streamBroadcastClose(this);
            }
            catch (Throwable t) {
                log.error((Object)"error notify streamBroadcastStop", t);
            }
        }
    }

    private void notifyBroadcastStart() {
        IStreamAwareScopeHandler handler = this.getStreamAwareHandler();
        if (handler != null) {
            try {
                handler.streamBroadcastStart(this);
            }
            catch (Throwable t) {
                log.error((Object)"error notify streamBroadcastStart", t);
            }
        }
    }

    private void scheduleNextMessage() {
        boolean first = this.nextRTMPMessage == null;
        this.nextRTMPMessage = this.getNextRTMPMessage();
        if (this.nextRTMPMessage == null) {
            this.onItemEnd();
            return;
        }
        IRTMPEvent rtmpEvent = null;
        if (first && !((rtmpEvent = this.nextRTMPMessage.getBody()) instanceof VideoData) && !(rtmpEvent instanceof AudioData) && rtmpEvent.getTimestamp() == 0) {
            rtmpEvent.release();
            this.nextRTMPMessage = this.getNextRTMPMessage();
            if (this.nextRTMPMessage == null) {
                this.onItemEnd();
                return;
            }
        }
        this.nextTS = (rtmpEvent = this.nextRTMPMessage.getBody()) instanceof VideoData ? (this.nextVideoTS = (long)rtmpEvent.getTimestamp()) : (rtmpEvent instanceof AudioData ? (this.nextAudioTS = (long)rtmpEvent.getTimestamp()) : (this.nextDataTS = (long)rtmpEvent.getTimestamp()));
        if (first) {
            this.vodStartTS = this.nextTS;
        }
        long delta = this.nextTS - this.vodStartTS - (System.currentTimeMillis() - this.serverStartTS);
        this.vodJobName = this.scheduler.addScheduledOnceJob(delta, new IScheduledJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(ISchedulingService service) {
                ServerStream serverStream = ServerStream.this;
                synchronized (serverStream) {
                    if (ServerStream.this.vodJobName == null) {
                        return;
                    }
                    ServerStream.this.vodJobName = null;
                    try {
                        ServerStream.this.pushMessage(ServerStream.this.nextRTMPMessage);
                    }
                    catch (IOException err) {
                        log.error((Object)"Error while sending message.", (Throwable)err);
                    }
                    ServerStream.this.nextRTMPMessage.getBody().release();
                    long start = ServerStream.this.currentItem.getStart();
                    if (start < 0L) {
                        start = 0L;
                    }
                    if (ServerStream.this.currentItem.getLength() >= 0L && ServerStream.this.nextTS - ServerStream.this.currentItem.getStart() > ServerStream.this.currentItem.getLength()) {
                        ServerStream.this.onItemEnd();
                        return;
                    }
                    if (ServerStream.this.state == State.PLAYING) {
                        ServerStream.this.scheduleNextMessage();
                    } else {
                        ServerStream.this.nextRTMPMessage = null;
                    }
                }
            }
        });
    }

    private RTMPMessage getNextRTMPMessage() {
        IMessage message;
        do {
            try {
                message = this.msgIn.pullMessage();
            }
            catch (IOException err) {
                log.error((Object)"Error while pulling message.", (Throwable)err);
                message = null;
            }
            if (message != null) continue;
            return null;
        } while (!(message instanceof RTMPMessage));
        return (RTMPMessage)message;
    }

    private void sendVODInitCM(IMessageInput msgIn, int start) {
        OOBControlMessage oobCtrlMsg = new OOBControlMessage();
        oobCtrlMsg.setTarget(IPassive.KEY);
        oobCtrlMsg.setServiceName("init");
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("startTS", start);
        oobCtrlMsg.setServiceParamMap(paramMap);
        msgIn.sendOOBControlMessage(this, oobCtrlMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendVODSeekCM(IMessageInput msgIn, int position) {
        OOBControlMessage oobCtrlMsg = new OOBControlMessage();
        oobCtrlMsg.setTarget(ISeekableProvider.KEY);
        oobCtrlMsg.setServiceName("seek");
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("position", new Integer(position));
        oobCtrlMsg.setServiceParamMap(paramMap);
        msgIn.sendOOBControlMessage(this, oobCtrlMsg);
        ServerStream serverStream = this;
        synchronized (serverStream) {
            this.vodStartTS = 0L;
            this.serverStartTS = System.currentTimeMillis();
            if (this.nextRTMPMessage != null) {
                try {
                    this.pushMessage(this.nextRTMPMessage);
                }
                catch (IOException err) {
                    log.error((Object)"Error while sending message.", (Throwable)err);
                }
                this.nextRTMPMessage.getBody().release();
                this.nextRTMPMessage = null;
            }
            ResetMessage reset = new ResetMessage();
            try {
                this.pushMessage(reset);
            }
            catch (IOException err) {
                log.error((Object)"Error while sending message.", (Throwable)err);
            }
            this.scheduleNextMessage();
        }
    }

    private void moveToNext() {
        if (this.currentItemIndex >= this.items.size()) {
            this.currentItemIndex = this.items.size() - 1;
        }
        this.currentItemIndex = this.controller != null ? this.controller.nextItem(this, this.currentItemIndex) : this.defaultController.nextItem(this, this.currentItemIndex);
    }

    private void moveToPrevious() {
        if (this.currentItemIndex >= this.items.size()) {
            this.currentItemIndex = this.items.size() - 1;
        }
        this.currentItemIndex = this.controller != null ? this.controller.previousItem(this, this.currentItemIndex) : this.defaultController.previousItem(this, this.currentItemIndex);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        UNINIT,
        CLOSED,
        STOPPED,
        PLAYING,
        PAUSED;

    }
}

