/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.red5.server.api.IConnection;
import org.red5.server.api.IScope;
import org.red5.server.api.IScopeHandler;
import org.red5.server.api.Red5;
import org.red5.server.api.ScopeUtils;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.event.IEventDispatcher;
import org.red5.server.api.event.IEventListener;
import org.red5.server.api.statistics.IClientBroadcastStreamStatistics;
import org.red5.server.api.statistics.support.StatisticsCounter;
import org.red5.server.api.stream.IClientBroadcastStream;
import org.red5.server.api.stream.IStreamAwareScopeHandler;
import org.red5.server.api.stream.IStreamCapableConnection;
import org.red5.server.api.stream.IStreamCodecInfo;
import org.red5.server.api.stream.IStreamFilenameGenerator;
import org.red5.server.api.stream.IVideoStreamCodec;
import org.red5.server.api.stream.ResourceExistException;
import org.red5.server.api.stream.ResourceNotFoundException;
import org.red5.server.jmx.JMXAgent;
import org.red5.server.jmx.JMXFactory;
import org.red5.server.messaging.IConsumer;
import org.red5.server.messaging.IFilter;
import org.red5.server.messaging.IMessage;
import org.red5.server.messaging.IMessageComponent;
import org.red5.server.messaging.IMessageOutput;
import org.red5.server.messaging.IPipe;
import org.red5.server.messaging.IPipeConnectionListener;
import org.red5.server.messaging.IProvider;
import org.red5.server.messaging.IPushableConsumer;
import org.red5.server.messaging.InMemoryPushPushPipe;
import org.red5.server.messaging.OOBControlMessage;
import org.red5.server.messaging.PipeConnectionEvent;
import org.red5.server.net.rtmp.event.AudioData;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.event.Invoke;
import org.red5.server.net.rtmp.event.Notify;
import org.red5.server.net.rtmp.event.VideoData;
import org.red5.server.net.rtmp.status.Status;
import org.red5.server.stream.AbstractClientStream;
import org.red5.server.stream.ClientBroadcastStreamMBean;
import org.red5.server.stream.DefaultStreamFilenameGenerator;
import org.red5.server.stream.IConsumerService;
import org.red5.server.stream.IStreamData;
import org.red5.server.stream.VideoCodecFactory;
import org.red5.server.stream.codec.StreamCodecInfo;
import org.red5.server.stream.consumer.FileConsumer;
import org.red5.server.stream.message.RTMPMessage;
import org.red5.server.stream.message.StatusMessage;

public class ClientBroadcastStream
extends AbstractClientStream
implements IClientBroadcastStream,
IFilter,
IPushableConsumer,
IPipeConnectionListener,
IEventDispatcher,
IClientBroadcastStreamStatistics,
ClientBroadcastStreamMBean {
    private static final Log log = LogFactory.getLog(ClientBroadcastStream.class);
    private int audioTime = -1;
    private long bytesReceived;
    private boolean checkVideoCodec = false;
    private int chunkSize = 0;
    private boolean closed = false;
    private IMessageOutput connMsgOut;
    private long creationTime;
    private int dataTime = -1;
    private int firstPacketTime = -1;
    private IPipe livePipe;
    private ObjectName oName;
    private String publishedName;
    private boolean recording = false;
    private FileConsumer recordingFile;
    private String recordingFilename;
    private IPipe recordPipe;
    private boolean sendStartNotification = true;
    private StatisticsCounter subscriberStats = new StatisticsCounter();
    private VideoCodecFactory videoCodecFactory = null;
    private int videoTime = -1;

    private void checkSendNotifications(IEvent event) {
        IEventListener source = event.getSource();
        this.sendStartNotifications(source);
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.livePipe != null) {
            this.livePipe.unsubscribe(this);
        }
        this.recordPipe.unsubscribe(this);
        if (this.recording) {
            this.sendRecordStopNotify();
        }
        this.sendPublishStopNotify();
        this.connMsgOut.unsubscribe(this);
        this.notifyBroadcastClose();
        JMXAgent.unregisterMBean(this.oName);
    }

    public void dispatchEvent(IEvent event) {
        IRTMPEvent rtmpEvent;
        if (!(event instanceof IRTMPEvent) && event.getType() != IEvent.Type.STREAM_CONTROL && event.getType() != IEvent.Type.STREAM_DATA || this.closed) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("dispatchEvent: " + (Object)((Object)event.getType())));
            }
            return;
        }
        IStreamCodecInfo codecInfo = this.getCodecInfo();
        StreamCodecInfo info = null;
        if (codecInfo instanceof StreamCodecInfo) {
            info = (StreamCodecInfo)codecInfo;
        }
        try {
            rtmpEvent = (IRTMPEvent)event;
        }
        catch (ClassCastException e) {
            log.error((Object)"Class cast exception in event dispatch", (Throwable)e);
            return;
        }
        int eventTime = -1;
        if (this.firstPacketTime == -1) {
            this.firstPacketTime = rtmpEvent.getTimestamp();
        }
        if (rtmpEvent instanceof AudioData) {
            if (info != null) {
                info.setHasAudio(true);
            }
            this.audioTime = rtmpEvent.getHeader().isTimerRelative() ? (this.audioTime += rtmpEvent.getTimestamp()) : rtmpEvent.getTimestamp();
            eventTime = this.audioTime;
        } else if (rtmpEvent instanceof VideoData) {
            IVideoStreamCodec videoStreamCodec = null;
            if (this.videoCodecFactory != null && this.checkVideoCodec) {
                videoStreamCodec = this.videoCodecFactory.getVideoCodec(((VideoData)rtmpEvent).getData());
                if (codecInfo instanceof StreamCodecInfo) {
                    ((StreamCodecInfo)codecInfo).setVideoCodec(videoStreamCodec);
                }
                this.checkVideoCodec = false;
            } else if (codecInfo != null) {
                videoStreamCodec = codecInfo.getVideoCodec();
            }
            if (videoStreamCodec != null) {
                videoStreamCodec.addData(((VideoData)rtmpEvent).getData());
            }
            if (info != null) {
                info.setHasVideo(true);
            }
            this.videoTime = rtmpEvent.getHeader().isTimerRelative() ? (this.videoTime += rtmpEvent.getTimestamp()) : rtmpEvent.getTimestamp();
            eventTime = this.videoTime;
        } else {
            if (rtmpEvent instanceof Invoke) {
                this.dataTime = rtmpEvent.getHeader().isTimerRelative() ? (this.dataTime += rtmpEvent.getTimestamp()) : rtmpEvent.getTimestamp();
                return;
            }
            if (rtmpEvent instanceof Notify) {
                this.dataTime = rtmpEvent.getHeader().isTimerRelative() ? (this.dataTime += rtmpEvent.getTimestamp()) : rtmpEvent.getTimestamp();
                eventTime = this.dataTime;
            }
        }
        if (rtmpEvent instanceof IStreamData && ((IStreamData)((Object)rtmpEvent)).getData() != null) {
            this.bytesReceived += (long)((IStreamData)((Object)rtmpEvent)).getData().limit();
        }
        this.checkSendNotifications(event);
        RTMPMessage msg = new RTMPMessage();
        msg.setBody(rtmpEvent);
        msg.getBody().setTimestamp(eventTime);
        try {
            if (this.livePipe != null) {
                this.livePipe.pushMessage(msg);
            }
            this.recordPipe.pushMessage(msg);
        }
        catch (IOException err) {
            this.sendRecordFailedNotify(err.getMessage());
            this.stop();
        }
    }

    public int getActiveSubscribers() {
        return this.subscriberStats.getCurrent();
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public int getCurrentTimestamp() {
        return Math.max(Math.max(this.videoTime, this.audioTime), this.dataTime);
    }

    public int getMaxSubscribers() {
        return this.subscriberStats.getMax();
    }

    public IProvider getProvider() {
        return this;
    }

    public String getPublishedName() {
        return this.publishedName;
    }

    public String getSaveFilename() {
        return this.recordingFilename;
    }

    public IClientBroadcastStreamStatistics getStatistics() {
        return this;
    }

    public int getTotalSubscribers() {
        return this.subscriberStats.getTotal();
    }

    private void notifyBroadcastClose() {
        IStreamAwareScopeHandler handler = this.getStreamAwareHandler();
        if (handler != null) {
            try {
                handler.streamBroadcastClose(this);
            }
            catch (Throwable t) {
                log.error((Object)"error notify streamBroadcastStop", t);
            }
        }
    }

    private void notifyBroadcastStart() {
        IStreamAwareScopeHandler handler = this.getStreamAwareHandler();
        if (handler != null) {
            try {
                handler.streamBroadcastStart(this);
            }
            catch (Throwable t) {
                log.error((Object)"error notify streamBroadcastStart", t);
            }
        }
    }

    private void notifyChunkSize() {
        if (this.chunkSize > 0 && this.livePipe != null) {
            OOBControlMessage setChunkSize = new OOBControlMessage();
            setChunkSize.setTarget("ConnectionConsumer");
            setChunkSize.setServiceName("chunkSize");
            if (setChunkSize.getServiceParamMap() == null) {
                setChunkSize.setServiceParamMap(new HashMap());
            }
            setChunkSize.getServiceParamMap().put("chunkSize", this.chunkSize);
            this.livePipe.sendOOBControlMessage(this.getProvider(), setChunkSize);
        }
    }

    public void onOOBControlMessage(IMessageComponent source, IPipe pipe, OOBControlMessage oobCtrlMsg) {
        if (!"ClientBroadcastStream".equals(oobCtrlMsg.getTarget())) {
            return;
        }
        if ("chunkSize".equals(oobCtrlMsg.getServiceName())) {
            this.chunkSize = (Integer)oobCtrlMsg.getServiceParamMap().get("chunkSize");
            this.notifyChunkSize();
        }
    }

    public void onPipeConnectionEvent(PipeConnectionEvent event) {
        switch (event.getType()) {
            case 1: {
                if (event.getProvider() != this || event.getSource() == this.connMsgOut || event.getParamMap() != null && event.getParamMap().containsKey("record")) break;
                this.livePipe = (IPipe)event.getSource();
                for (IConsumer consumer : this.livePipe.getConsumers()) {
                    this.subscriberStats.increment();
                }
                break;
            }
            case 2: {
                if (this.livePipe != event.getSource()) break;
                this.livePipe = null;
                break;
            }
            case 4: {
                if (this.livePipe == event.getSource()) {
                    this.notifyChunkSize();
                }
                this.subscriberStats.increment();
                break;
            }
            case 5: {
                this.subscriberStats.decrement();
                break;
            }
        }
    }

    public void pushMessage(IPipe pipe, IMessage message) {
    }

    public void saveAs(String name, boolean isAppend) throws IOException, ResourceNotFoundException, ResourceExistException {
        IStreamCapableConnection conn;
        if (log.isDebugEnabled()) {
            log.debug((Object)("SaveAs - name: " + name + " append: " + isAppend));
        }
        if ((conn = this.getConnection()) == null) {
            throw new IOException("stream is no longer connected");
        }
        IScope scope = conn.getScope();
        IStreamFilenameGenerator generator = (IStreamFilenameGenerator)ScopeUtils.getScopeService(scope, IStreamFilenameGenerator.class, DefaultStreamFilenameGenerator.class);
        String filename = generator.generateFilename(scope, name, ".flv", IStreamFilenameGenerator.GenerationType.RECORD);
        File file = generator.resolvesToAbsolutePath() ? new File(filename) : scope.getContext().getResource(filename).getFile();
        if (!isAppend) {
            if (file.exists() && !file.delete()) {
                throw new IOException("file could not be deleted");
            }
        } else if (!file.exists()) {
            isAppend = false;
        }
        if (!file.exists()) {
            File tmp;
            String path = file.getAbsolutePath();
            int slashPos = path.lastIndexOf(File.separator);
            if (slashPos != -1) {
                path = path.substring(0, slashPos);
            }
            if (!(tmp = new File(path)).isDirectory()) {
                tmp.mkdirs();
            }
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Recording file: " + file.getCanonicalPath()));
        }
        this.recordingFile = new FileConsumer(scope, file);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (isAppend) {
            paramMap.put("mode", "append");
        } else {
            paramMap.put("mode", "record");
        }
        this.recordPipe.subscribe(this.recordingFile, paramMap);
        this.recording = true;
        this.recordingFilename = filename;
    }

    private void sendPublishStartNotify() {
        Status publishStatus = new Status("NetStream.Publish.Start");
        publishStatus.setClientid(this.getStreamId());
        publishStatus.setDetails(this.getPublishedName());
        StatusMessage startMsg = new StatusMessage();
        startMsg.setBody(publishStatus);
        try {
            this.connMsgOut.pushMessage(startMsg);
        }
        catch (IOException err) {
            log.error((Object)"Error while pushing message.", (Throwable)err);
        }
    }

    private void sendPublishStopNotify() {
        Status stopStatus = new Status("NetStream.Unpublish.Success");
        stopStatus.setClientid(this.getStreamId());
        stopStatus.setDetails(this.getPublishedName());
        StatusMessage stopMsg = new StatusMessage();
        stopMsg.setBody(stopStatus);
        try {
            this.connMsgOut.pushMessage(stopMsg);
        }
        catch (IOException err) {
            log.error((Object)"Error while pushing message.", (Throwable)err);
        }
    }

    private void sendRecordFailedNotify(String reason) {
        Status failedStatus = new Status("NetStream.Record.Failed");
        failedStatus.setLevel("error");
        failedStatus.setClientid(this.getStreamId());
        failedStatus.setDetails(this.getPublishedName());
        failedStatus.setDesciption(reason);
        StatusMessage failedMsg = new StatusMessage();
        failedMsg.setBody(failedStatus);
        try {
            this.connMsgOut.pushMessage(failedMsg);
        }
        catch (IOException err) {
            log.error((Object)"Error while pushing message.", (Throwable)err);
        }
    }

    private void sendRecordStartNotify() {
        Status recordStatus = new Status("NetStream.Record.Start");
        recordStatus.setClientid(this.getStreamId());
        recordStatus.setDetails(this.getPublishedName());
        StatusMessage startMsg = new StatusMessage();
        startMsg.setBody(recordStatus);
        try {
            this.connMsgOut.pushMessage(startMsg);
        }
        catch (IOException err) {
            log.error((Object)"Error while pushing message.", (Throwable)err);
        }
    }

    private void sendRecordStopNotify() {
        Status stopStatus = new Status("NetStream.Record.Stop");
        stopStatus.setClientid(this.getStreamId());
        stopStatus.setDetails(this.getPublishedName());
        StatusMessage startMsg = new StatusMessage();
        startMsg.setBody(stopStatus);
        try {
            this.connMsgOut.pushMessage(startMsg);
        }
        catch (IOException err) {
            log.error((Object)"Error while pushing message.", (Throwable)err);
        }
    }

    private void sendStartNotifications(IEventListener source) {
        if (this.sendStartNotification) {
            IScopeHandler handler;
            IScope scope;
            this.sendStartNotification = false;
            if (source instanceof IConnection && (scope = ((IConnection)source).getScope()).hasHandler() && (handler = scope.getHandler()) instanceof IStreamAwareScopeHandler) {
                if (this.recording) {
                    ((IStreamAwareScopeHandler)handler).streamRecordStart(this);
                } else {
                    ((IStreamAwareScopeHandler)handler).streamPublishStart(this);
                }
            }
            this.sendPublishStartNotify();
            if (this.recording) {
                this.sendRecordStartNotify();
            }
            this.notifyBroadcastStart();
        }
    }

    public void setPublishedName(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setPublishedName: " + name));
        }
        if (!name.equals(this.publishedName)) {
            JMXAgent.updateMBeanAttribute(this.oName, "publishedName", name);
        } else {
            this.oName = JMXFactory.createObjectName("type", "ClientBroadcastStream", "publishedName", name);
            JMXAgent.registerMBean((Object)this, this.getClass().getName(), ClientBroadcastStreamMBean.class, this.oName);
        }
        this.publishedName = name;
    }

    public void start() {
        IConsumerService consumerManager = (IConsumerService)this.getScope().getContext().getBean("consumerService");
        try {
            this.videoCodecFactory = (VideoCodecFactory)this.getScope().getContext().getBean("videoCodecFactory");
            this.checkVideoCodec = true;
        }
        catch (Exception err) {
            log.warn((Object)"No video codec factory available.", (Throwable)err);
        }
        this.dataTime = -1;
        this.videoTime = -1;
        this.audioTime = -1;
        this.firstPacketTime = -1;
        this.connMsgOut = consumerManager.getConsumerOutput(this);
        this.connMsgOut.subscribe(this, null);
        this.recordPipe = new InMemoryPushPushPipe();
        HashMap<String, Object> recordParamMap = new HashMap<String, Object>();
        recordParamMap.put("record", null);
        this.recordPipe.subscribe(this, (Map)recordParamMap);
        this.recording = false;
        this.recordingFilename = null;
        this.setCodecInfo(new StreamCodecInfo());
        this.closed = false;
        this.bytesReceived = 0L;
        this.creationTime = System.currentTimeMillis();
    }

    public void startPublishing() {
        this.sendStartNotifications(Red5.getConnectionLocal());
    }

    public void stop() {
        this.stopRecording();
        this.close();
    }

    public void stopRecording() {
        if (this.recording) {
            this.recording = false;
            this.recordingFilename = null;
            this.recordPipe.unsubscribe(this.recordingFile);
            this.sendRecordStopNotify();
        }
    }
}

