/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.red5.server.BasicScope;
import org.red5.server.api.IScope;
import org.red5.server.messaging.IConsumer;
import org.red5.server.messaging.IMessage;
import org.red5.server.messaging.IPipeConnectionListener;
import org.red5.server.messaging.IProvider;
import org.red5.server.messaging.InMemoryPushPushPipe;
import org.red5.server.messaging.OOBControlMessage;
import org.red5.server.messaging.PipeConnectionEvent;
import org.red5.server.stream.IBroadcastScope;
import org.red5.server.stream.IProviderService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BroadcastScope
extends BasicScope
implements IBroadcastScope,
IPipeConnectionListener {
    private InMemoryPushPushPipe pipe = new InMemoryPushPushPipe();
    private int compCounter;
    private boolean hasRemoved;

    public BroadcastScope(IScope parent, String name) {
        super(parent, "bs", name, false);
        this.pipe.addPipeConnectionListener(this);
        this.compCounter = 0;
        this.hasRemoved = false;
    }

    @Override
    public void addPipeConnectionListener(IPipeConnectionListener listener) {
        this.pipe.addPipeConnectionListener(listener);
    }

    @Override
    public void removePipeConnectionListener(IPipeConnectionListener listener) {
        this.pipe.removePipeConnectionListener(listener);
    }

    @Override
    public IMessage pullMessage() {
        return this.pipe.pullMessage();
    }

    @Override
    public IMessage pullMessage(long wait) {
        return this.pipe.pullMessage(wait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean subscribe(IConsumer consumer, Map paramMap) {
        InMemoryPushPushPipe inMemoryPushPushPipe = this.pipe;
        synchronized (inMemoryPushPushPipe) {
            return !this.hasRemoved && this.pipe.subscribe(consumer, paramMap);
        }
    }

    @Override
    public boolean unsubscribe(IConsumer consumer) {
        return this.pipe.unsubscribe(consumer);
    }

    @Override
    public List<IConsumer> getConsumers() {
        return this.pipe.getConsumers();
    }

    @Override
    public void sendOOBControlMessage(IConsumer consumer, OOBControlMessage oobCtrlMsg) {
        this.pipe.sendOOBControlMessage(consumer, oobCtrlMsg);
    }

    @Override
    public void pushMessage(IMessage message) throws IOException {
        this.pipe.pushMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean subscribe(IProvider provider, Map paramMap) {
        InMemoryPushPushPipe inMemoryPushPushPipe = this.pipe;
        synchronized (inMemoryPushPushPipe) {
            return !this.hasRemoved && this.pipe.subscribe(provider, paramMap);
        }
    }

    @Override
    public synchronized boolean unsubscribe(IProvider provider) {
        return this.pipe.unsubscribe(provider);
    }

    @Override
    public List<IProvider> getProviders() {
        return this.pipe.getProviders();
    }

    @Override
    public void sendOOBControlMessage(IProvider provider, OOBControlMessage oobCtrlMsg) {
        this.pipe.sendOOBControlMessage(provider, oobCtrlMsg);
    }

    @Override
    public void onPipeConnectionEvent(PipeConnectionEvent event) {
        switch (event.getType()) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                ++this.compCounter;
                break;
            }
            case 2: 
            case 5: {
                --this.compCounter;
                if (this.compCounter > 0) break;
                if (this.hasParent()) {
                    IProviderService providerService = (IProviderService)this.getParent().getContext().getBean("providerService");
                    providerService.unregisterBroadcastStream(this.getParent(), this.getName());
                }
                this.hasRemoved = true;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Event type not supported: " + event.getType());
            }
        }
    }
}

