/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.so;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.red5.server.BaseConnection;
import org.red5.server.BasicScope;
import org.red5.server.api.IAttributeStore;
import org.red5.server.api.IContext;
import org.red5.server.api.IScope;
import org.red5.server.api.ScopeUtils;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.event.IEventListener;
import org.red5.server.api.persistence.IPersistenceStore;
import org.red5.server.api.so.ISharedObject;
import org.red5.server.api.so.ISharedObjectBase;
import org.red5.server.api.so.ISharedObjectListener;
import org.red5.server.api.so.ISharedObjectSecurity;
import org.red5.server.api.so.ISharedObjectSecurityService;
import org.red5.server.api.statistics.ISharedObjectStatistics;
import org.red5.server.net.rtmp.status.StatusCodes;
import org.red5.server.service.ServiceUtils;
import org.red5.server.so.ISharedObjectEvent;
import org.red5.server.so.ISharedObjectMessage;
import org.red5.server.so.SharedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedObjectScope
extends BasicScope
implements ISharedObject,
StatusCodes {
    private Log log = LogFactory.getLog((String)SharedObjectScope.class.getName());
    private final ReentrantLock lock = new ReentrantLock();
    private Set<ISharedObjectListener> serverListeners = new CopyOnWriteArraySet<ISharedObjectListener>();
    private Map<String, Object> handlers = new ConcurrentHashMap<String, Object>();
    private Set<ISharedObjectSecurity> securityHandlers = new CopyOnWriteArraySet<ISharedObjectSecurity>();
    protected SharedObject so;

    public SharedObjectScope(IScope parent, String name, boolean persistent, IPersistenceStore store) {
        super(parent, "SharedObject", name, persistent);
        String path = parent.getContextPath();
        if ("".equals(path) || path.charAt(0) != '/') {
            path = '/' + path;
        }
        this.so = (SharedObject)store.load("SharedObject" + path + '/' + name);
        if (this.so == null) {
            this.so = new SharedObject(this.attributes, name, path, persistent, store);
            store.save(this.so);
        } else {
            this.so.setName(name);
            this.so.setPath(path);
        }
    }

    @Override
    public void registerSharedObjectSecurity(ISharedObjectSecurity handler) {
        this.securityHandlers.add(handler);
    }

    @Override
    public void unregisterSharedObjectSecurity(ISharedObjectSecurity handler) {
        this.securityHandlers.remove(handler);
    }

    @Override
    public Set<ISharedObjectSecurity> getSharedObjectSecurity() {
        return Collections.unmodifiableSet(this.securityHandlers);
    }

    @Override
    public IPersistenceStore getStore() {
        return this.so.getStore();
    }

    @Override
    public String getName() {
        return this.so.getName();
    }

    @Override
    public void setName(String name) {
        this.so.setName(name);
    }

    @Override
    public String getPath() {
        return this.so.getPath();
    }

    @Override
    public void setPath(String path) {
        this.so.setPath(path);
    }

    @Override
    public String getType() {
        return this.so.getType();
    }

    @Override
    public boolean isPersistentObject() {
        return this.so.isPersistentObject();
    }

    @Override
    public void beginUpdate() {
        this.lock.lock();
        this.so.beginUpdate();
    }

    @Override
    public void beginUpdate(IEventListener listener) {
        this.lock.lock();
        this.so.beginUpdate(listener);
    }

    @Override
    public void endUpdate() {
        this.so.endUpdate();
        this.lock.unlock();
    }

    @Override
    public int getVersion() {
        return this.so.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(String handler, List arguments) {
        String serviceMethod;
        String serviceName;
        this.beginUpdate();
        try {
            this.so.sendMessage(handler, arguments);
        }
        finally {
            this.endUpdate();
        }
        int dotPos = handler.lastIndexOf(46);
        if (dotPos != -1) {
            serviceName = handler.substring(0, dotPos);
            serviceMethod = handler.substring(dotPos + 1);
        } else {
            serviceName = "";
            serviceMethod = handler;
        }
        Object soHandler = this.getServiceHandler(serviceName);
        if (soHandler == null && this.hasParent()) {
            IContext context = this.getParent().getContext();
            try {
                soHandler = context.getBean(this.so.getName() + '.' + serviceName + ".soservice");
            }
            catch (Exception err) {
                this.log.debug((Object)"No such bean");
            }
        }
        if (soHandler != null) {
            Object[] methodResult = ServiceUtils.findMethodWithExactParameters(soHandler, serviceMethod, arguments);
            if (methodResult.length == 0 || methodResult[0] == null) {
                methodResult = ServiceUtils.findMethodWithListParameters(soHandler, serviceMethod, arguments);
            }
            if (methodResult.length > 0 && methodResult[0] != null) {
                Method method = (Method)methodResult[0];
                Object[] params = (Object[])methodResult[1];
                try {
                    method.invoke(soHandler, params);
                }
                catch (Exception err) {
                    this.log.error((Object)("Error while invoking method " + serviceMethod + " on shared object handler " + handler), (Throwable)err);
                }
            }
        }
        for (ISharedObjectListener listener : this.serverListeners) {
            listener.onSharedObjectSend(this, handler, arguments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAttribute(String name) {
        boolean success;
        this.beginUpdate();
        try {
            success = this.so.removeAttribute(name);
        }
        finally {
            this.endUpdate();
        }
        if (success) {
            for (ISharedObjectListener listener : this.serverListeners) {
                listener.onSharedObjectDelete(this, name);
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttributes() {
        this.beginUpdate();
        try {
            this.so.removeAttributes();
        }
        finally {
            this.endUpdate();
        }
        for (ISharedObjectListener listener : this.serverListeners) {
            listener.onSharedObjectClear(this);
        }
    }

    @Override
    public void addEventListener(IEventListener listener) {
        super.addEventListener(listener);
        this.so.register(listener);
        for (ISharedObjectListener soListener : this.serverListeners) {
            soListener.onSharedObjectConnect(this);
        }
    }

    @Override
    public void removeEventListener(IEventListener listener) {
        this.so.unregister(listener);
        super.removeEventListener(listener);
        if (!this.so.isPersistentObject() && (this.so.getListeners() == null || this.so.getListeners().isEmpty())) {
            this.getParent().removeChildScope(this);
        }
        for (ISharedObjectListener soListener : this.serverListeners) {
            soListener.onSharedObjectDisconnect(this);
        }
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.so.hasAttribute(name);
    }

    @Override
    public Object getAttribute(String name) {
        return this.so.getAttribute(name);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.so.getAttributes();
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.so.getAttributeNames();
    }

    @Override
    public Map<String, Object> getData() {
        return this.so.getData();
    }

    private Set<ISharedObjectSecurity> getSecurityHandlers() {
        ISharedObjectSecurityService security = (ISharedObjectSecurityService)ScopeUtils.getScopeService(this.getParent(), ISharedObjectSecurityService.class);
        if (security == null) {
            return null;
        }
        return security.getSharedObjectSecurity();
    }

    protected boolean isConnectionAllowed() {
        for (ISharedObjectSecurity handler : this.securityHandlers) {
            if (handler.isConnectionAllowed(this)) continue;
            return false;
        }
        Set<ISharedObjectSecurity> handlers = this.getSecurityHandlers();
        if (handlers == null) {
            return true;
        }
        for (ISharedObjectSecurity handler : handlers) {
            if (handler.isConnectionAllowed(this)) continue;
            return false;
        }
        return true;
    }

    protected boolean isWriteAllowed(String key, Object value) {
        for (ISharedObjectSecurity handler : this.securityHandlers) {
            if (handler.isWriteAllowed(this, key, value)) continue;
            return false;
        }
        Set<ISharedObjectSecurity> handlers = this.getSecurityHandlers();
        if (handlers == null) {
            return true;
        }
        for (ISharedObjectSecurity handler : handlers) {
            if (handler.isWriteAllowed(this, key, value)) continue;
            return false;
        }
        return true;
    }

    protected boolean isDeleteAllowed(String key) {
        for (ISharedObjectSecurity handler : this.securityHandlers) {
            if (handler.isDeleteAllowed(this, key)) continue;
            return false;
        }
        Set<ISharedObjectSecurity> handlers = this.getSecurityHandlers();
        if (handlers == null) {
            return true;
        }
        for (ISharedObjectSecurity handler : handlers) {
            if (handler.isDeleteAllowed(this, key)) continue;
            return false;
        }
        return true;
    }

    protected boolean isSendAllowed(String message, List arguments) {
        for (ISharedObjectSecurity handler : this.securityHandlers) {
            if (handler.isSendAllowed(this, message, arguments)) continue;
            return false;
        }
        Set<ISharedObjectSecurity> handlers = this.getSecurityHandlers();
        if (handlers == null) {
            return true;
        }
        for (ISharedObjectSecurity handler : handlers) {
            if (handler.isSendAllowed(this, message, arguments)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchEvent(IEvent e) {
        if (e.getType() != IEvent.Type.SHARED_OBJECT || !(e instanceof ISharedObjectMessage)) {
            super.dispatchEvent(e);
            return;
        }
        ISharedObjectMessage msg = (ISharedObjectMessage)e;
        if (msg.hasSource()) {
            this.beginUpdate(msg.getSource());
        } else {
            this.beginUpdate();
        }
        try {
            block10: for (ISharedObjectEvent event : msg.getEvents()) {
                switch (event.getType()) {
                    case SERVER_CONNECT: {
                        if (!this.isConnectionAllowed()) {
                            this.so.returnError("SharedObject.NoReadAccess");
                            break;
                        }
                        if (!msg.hasSource()) continue block10;
                        IEventListener source = msg.getSource();
                        if (source instanceof BaseConnection) {
                            ((BaseConnection)source).registerBasicScope(this);
                            break;
                        }
                        this.addEventListener(source);
                        break;
                    }
                    case SERVER_DISCONNECT: {
                        if (!msg.hasSource()) continue block10;
                        IEventListener source = msg.getSource();
                        if (source instanceof BaseConnection) {
                            ((BaseConnection)source).unregisterBasicScope(this);
                            break;
                        }
                        this.removeEventListener(source);
                        break;
                    }
                    case SERVER_SET_ATTRIBUTE: {
                        String key = event.getKey();
                        Object value = event.getValue();
                        if (!this.isWriteAllowed(key, value)) {
                            this.so.returnAttributeValue(key);
                            this.so.returnError("SharedObject.NoWriteAccess");
                            break;
                        }
                        this.setAttribute(key, value);
                        break;
                    }
                    case SERVER_DELETE_ATTRIBUTE: {
                        String property = event.getKey();
                        if (!this.isDeleteAllowed(property)) {
                            this.so.returnAttributeValue(property);
                            this.so.returnError("SharedObject.NoWriteAccess");
                            break;
                        }
                        this.removeAttribute(property);
                        break;
                    }
                    case SERVER_SEND_MESSAGE: {
                        List arguments;
                        String message = event.getKey();
                        if (!this.isSendAllowed(message, arguments = (List)event.getValue())) continue block10;
                        this.sendMessage(message, arguments);
                        break;
                    }
                    default: {
                        this.log.warn((Object)("Unknown SO event: " + (Object)((Object)event.getType())));
                    }
                }
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setAttribute(String name, Object value) {
        boolean success;
        this.beginUpdate();
        try {
            success = this.so.setAttribute(name, value);
        }
        finally {
            this.endUpdate();
        }
        if (success) {
            for (ISharedObjectListener listener : this.serverListeners) {
                listener.onSharedObjectUpdate(this, name, value);
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttributes(IAttributeStore values) {
        this.beginUpdate();
        try {
            this.so.setAttributes(values);
        }
        finally {
            this.endUpdate();
        }
        for (ISharedObjectListener listener : this.serverListeners) {
            listener.onSharedObjectUpdate((ISharedObjectBase)this, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttributes(Map<String, Object> values) {
        this.beginUpdate();
        try {
            this.so.setAttributes(values);
        }
        finally {
            this.endUpdate();
        }
        for (ISharedObjectListener listener : this.serverListeners) {
            listener.onSharedObjectUpdate((ISharedObjectBase)this, values);
        }
    }

    public String toString() {
        return "Shared Object: " + this.getName();
    }

    @Override
    public void addSharedObjectListener(ISharedObjectListener listener) {
        this.serverListeners.add(listener);
    }

    @Override
    public void removeSharedObjectListener(ISharedObjectListener listener) {
        this.serverListeners.remove(listener);
    }

    @Override
    public void registerServiceHandler(Object handler) {
        this.registerServiceHandler("", handler);
    }

    @Override
    public void registerServiceHandler(String name, Object handler) {
        if (name == null) {
            name = "";
        }
        this.handlers.put(name, handler);
    }

    public void unregisterServiceHandler() {
        this.unregisterServiceHandler("");
    }

    @Override
    public void unregisterServiceHandler(String name) {
        if (name == null) {
            name = "";
        }
        this.handlers.remove(name);
    }

    @Override
    public Object getServiceHandler(String name) {
        if (name == null) {
            name = "";
        }
        return this.handlers.get(name);
    }

    @Override
    public Set<String> getServiceHandlerNames() {
        return Collections.unmodifiableSet(this.handlers.keySet());
    }

    @Override
    public void lock() {
        this.lock.lock();
    }

    @Override
    public void unlock() {
        this.lock.unlock();
    }

    @Override
    public boolean isLocked() {
        return this.lock.isLocked();
    }

    @Override
    public boolean clear() {
        return this.so.clear();
    }

    @Override
    public void close() {
        this.so.close();
        this.so = null;
    }

    @Override
    public void acquire() {
        this.so.acquire();
    }

    @Override
    public boolean isAcquired() {
        return this.so.isAcquired();
    }

    @Override
    public void release() {
        this.so.release();
    }

    @Override
    public ISharedObjectStatistics getStatistics() {
        return this.so;
    }
}

