/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.so;

import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.red5.io.object.Deserializer;
import org.red5.io.object.Input;
import org.red5.io.object.Output;
import org.red5.io.object.Serializer;
import org.red5.server.api.IAttributeStore;
import org.red5.server.api.event.IEventListener;
import org.red5.server.api.persistence.IPersistable;
import org.red5.server.api.persistence.IPersistenceStore;
import org.red5.server.api.statistics.ISharedObjectStatistics;
import org.red5.server.api.statistics.support.StatisticsCounter;
import org.red5.server.net.rtmp.Channel;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.message.Constants;
import org.red5.server.so.ISharedObjectEvent;
import org.red5.server.so.SharedObjectEvent;
import org.red5.server.so.SharedObjectMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedObject
implements ISharedObjectStatistics,
IPersistable,
Constants {
    protected static Log log = LogFactory.getLog((String)SharedObject.class.getName());
    protected String name = "";
    protected String path = "";
    protected boolean persistent;
    protected boolean persistentSO;
    protected IPersistenceStore storage;
    protected int version = 1;
    protected Map<String, Object> data = null;
    protected Map<String, Integer> hashes = new HashMap<String, Integer>();
    protected int updateCounter;
    protected boolean modified;
    protected long lastModified = -1L;
    protected SharedObjectMessage ownerMessage;
    protected LinkedList<ISharedObjectEvent> syncEvents = new LinkedList();
    protected Set<IEventListener> listeners = new CopyOnWriteArraySet<IEventListener>();
    protected IEventListener source;
    protected int acquireCount;
    private long creationTime;
    protected StatisticsCounter listenerStats = new StatisticsCounter();
    protected AtomicInteger changeStats = new AtomicInteger();
    protected AtomicInteger deleteStats = new AtomicInteger();
    protected AtomicInteger sendStats = new AtomicInteger();

    public SharedObject() {
        this.data = new ConcurrentHashMap<String, Object>();
        this.ownerMessage = new SharedObjectMessage(null, null, -1, false);
        this.persistentSO = false;
        this.creationTime = System.currentTimeMillis();
    }

    public SharedObject(Input input) throws IOException {
        this();
        this.deserialize(input);
    }

    public SharedObject(Map<String, Object> data, String name, String path, boolean persistent) {
        this.data = new ConcurrentHashMap<String, Object>();
        this.data.putAll(data);
        this.name = name;
        this.path = path;
        this.persistentSO = false;
        this.persistentSO = persistent;
        this.ownerMessage = new SharedObjectMessage(null, name, 0, persistent);
        this.creationTime = System.currentTimeMillis();
    }

    public SharedObject(Map<String, Object> data, String name, String path, boolean persistent, IPersistenceStore storage) {
        this.data = new ConcurrentHashMap<String, Object>();
        this.data.putAll(data);
        this.name = name;
        this.path = path;
        this.persistentSO = false;
        this.persistentSO = persistent;
        this.setStore(storage);
        this.ownerMessage = new SharedObjectMessage(null, name, 0, persistent);
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getType() {
        return "SharedObject";
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public boolean isPersistentObject() {
        return this.persistentSO;
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    @Override
    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    protected void sendUpdates() {
        if (!((AbstractCollection)((Object)this.ownerMessage.getEvents())).isEmpty()) {
            SharedObjectMessage syncOwner = new SharedObjectMessage(null, this.name, this.version, this.isPersistentObject());
            syncOwner.addEvents(this.ownerMessage.getEvents());
            if (this.source != null) {
                Channel channel = ((RTMPConnection)this.source).getChannel(3);
                if (channel != null) {
                    channel.write(syncOwner);
                    log.debug((Object)("Owner: " + channel));
                } else {
                    log.warn((Object)"No channel found for owner changes!?");
                }
            }
            ((LinkedList)this.ownerMessage.getEvents()).clear();
        }
        if (!this.syncEvents.isEmpty()) {
            for (IEventListener listener : this.listeners) {
                if (listener == this.source) {
                    log.debug((Object)("Skipped " + this.source));
                    continue;
                }
                if (!(listener instanceof RTMPConnection)) {
                    log.warn((Object)("Can't send sync message to unknown connection " + listener));
                    continue;
                }
                SharedObjectMessage syncMessage = new SharedObjectMessage(null, this.name, this.version, this.isPersistentObject());
                syncMessage.addEvents(this.syncEvents);
                Channel c = ((RTMPConnection)listener).getChannel(3);
                log.debug((Object)("Send to " + c));
                c.write(syncMessage);
            }
            this.syncEvents.clear();
        }
    }

    private void updateHashes() {
        this.hashes.clear();
        Iterator<String> i$ = this.data.keySet().iterator();
        while (i$.hasNext()) {
            String name;
            Object value = this.data.get(name = i$.next());
            this.hashes.put(name, value != null ? value.hashCode() : 0);
        }
    }

    protected void notifyModified() {
        if (this.updateCounter > 0) {
            return;
        }
        if (this.modified) {
            this.updateVersion();
            this.lastModified = System.currentTimeMillis();
        }
        if (this.modified && this.storage != null && !this.storage.save(this)) {
            log.error((Object)"Could not store shared object.");
        }
        this.sendUpdates();
        this.updateHashes();
    }

    protected void returnError(String message) {
        this.ownerMessage.addEvent(ISharedObjectEvent.Type.CLIENT_STATUS, "error", message);
    }

    protected void returnAttributeValue(String name) {
        this.ownerMessage.addEvent(ISharedObjectEvent.Type.CLIENT_UPDATE_DATA, name, this.getAttribute(name));
    }

    public boolean hasAttribute(String name) {
        return this.data.containsKey(name);
    }

    public Set<String> getAttributeNames() {
        return Collections.unmodifiableSet(this.data.keySet());
    }

    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.data);
    }

    public Object getAttribute(String name) {
        return this.data.get(name);
    }

    protected boolean setAttribute(String name, Object value) {
        this.ownerMessage.addEvent(ISharedObjectEvent.Type.CLIENT_UPDATE_ATTRIBUTE, name, null);
        Object old = this.data.get(name);
        Integer oldHash = value != null ? value.hashCode() : 0;
        if (old == null || !old.equals(value) || !oldHash.equals(this.hashes.get(name))) {
            this.modified = true;
            this.data.put(name, value);
            this.syncEvents.add(new SharedObjectEvent(ISharedObjectEvent.Type.CLIENT_UPDATE_DATA, name, value));
            this.notifyModified();
            this.changeStats.incrementAndGet();
            return true;
        }
        this.notifyModified();
        return false;
    }

    protected void setAttributes(Map<String, Object> values) {
        if (values == null) {
            return;
        }
        this.beginUpdate();
        for (String name : values.keySet()) {
            this.setAttribute(name, values.get(name));
        }
        this.endUpdate();
    }

    protected void setAttributes(IAttributeStore values) {
        if (values == null) {
            return;
        }
        this.beginUpdate();
        for (String name : values.getAttributeNames()) {
            this.setAttribute(name, values.getAttribute(name));
        }
        this.endUpdate();
    }

    protected boolean removeAttribute(String name) {
        boolean result = this.data.containsKey(name);
        if (result) {
            this.data.remove(name);
        }
        this.ownerMessage.addEvent(ISharedObjectEvent.Type.CLIENT_DELETE_DATA, name, null);
        if (result) {
            this.modified = true;
            this.syncEvents.add(new SharedObjectEvent(ISharedObjectEvent.Type.CLIENT_DELETE_DATA, name, null));
            this.deleteStats.incrementAndGet();
        }
        this.notifyModified();
        return result;
    }

    protected void sendMessage(String handler, List arguments) {
        this.ownerMessage.addEvent(ISharedObjectEvent.Type.CLIENT_SEND_MESSAGE, handler, arguments);
        this.syncEvents.add(new SharedObjectEvent(ISharedObjectEvent.Type.CLIENT_SEND_MESSAGE, handler, arguments));
        this.sendStats.incrementAndGet();
    }

    public Map<String, Object> getData() {
        return Collections.unmodifiableMap(this.data);
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    private void updateVersion() {
        ++this.version;
    }

    protected void removeAttributes() {
        for (String key : this.data.keySet()) {
            this.ownerMessage.addEvent(ISharedObjectEvent.Type.CLIENT_DELETE_DATA, key, null);
            this.syncEvents.add(new SharedObjectEvent(ISharedObjectEvent.Type.CLIENT_DELETE_DATA, key, null));
        }
        this.deleteStats.addAndGet(this.data.size());
        this.data.clear();
        this.modified = true;
        this.notifyModified();
    }

    protected void register(IEventListener listener) {
        this.listeners.add(listener);
        this.listenerStats.increment();
        this.ownerMessage.addEvent(ISharedObjectEvent.Type.CLIENT_INITIAL_DATA, null, null);
        if (!this.isPersistentObject()) {
            this.ownerMessage.addEvent(ISharedObjectEvent.Type.CLIENT_CLEAR_DATA, null, null);
        }
        if (!this.data.isEmpty()) {
            this.ownerMessage.addEvent(new SharedObjectEvent(ISharedObjectEvent.Type.CLIENT_UPDATE_DATA, null, this.getData()));
        }
        this.notifyModified();
    }

    protected void checkRelease() {
        if (!this.isPersistentObject() && this.listeners.isEmpty() && !this.isAcquired()) {
            log.info((Object)("Deleting shared object " + this.name + " because all clients disconnected and it is no longer acquired."));
            if (this.storage != null && !this.storage.remove(this)) {
                log.error((Object)"Could not remove shared object.");
            }
            this.close();
        }
    }

    protected void unregister(IEventListener listener) {
        this.listeners.remove(listener);
        this.listenerStats.decrement();
        this.checkRelease();
    }

    public Set<IEventListener> getListeners() {
        return this.listeners;
    }

    protected void beginUpdate() {
        this.beginUpdate(this.source);
    }

    protected void beginUpdate(IEventListener listener) {
        this.source = listener;
        ++this.updateCounter;
    }

    protected void endUpdate() {
        --this.updateCounter;
        if (this.updateCounter == 0) {
            this.notifyModified();
            this.source = null;
        }
    }

    @Override
    public void serialize(Output output) throws IOException {
        Serializer ser = new Serializer();
        ser.serialize(output, this.getName());
        ser.serialize(output, this.data);
    }

    @Override
    public void deserialize(Input input) throws IOException {
        Deserializer deserializer = new Deserializer();
        this.name = (String)deserializer.deserialize(input);
        this.persistent = true;
        this.persistentSO = true;
        this.data.clear();
        this.data.putAll((Map)deserializer.deserialize(input));
        this.updateHashes();
        this.ownerMessage.setName(this.name);
        this.ownerMessage.setIsPersistent(true);
    }

    @Override
    public void setStore(IPersistenceStore store) {
        this.storage = store;
    }

    @Override
    public IPersistenceStore getStore() {
        return this.storage;
    }

    protected boolean clear() {
        this.data.clear();
        this.ownerMessage.addEvent(ISharedObjectEvent.Type.CLIENT_CLEAR_DATA, this.name, null);
        return this.data.isEmpty();
    }

    protected void close() {
        this.data.clear();
        this.listeners.clear();
        this.hashes.clear();
        this.syncEvents.clear();
        ((LinkedList)this.ownerMessage.getEvents()).clear();
    }

    public synchronized void acquire() {
        ++this.acquireCount;
    }

    public boolean isAcquired() {
        return this.acquireCount > 0;
    }

    public synchronized void release() {
        if (this.acquireCount == 0) {
            throw new RuntimeException("The shared object was not acquired before.");
        }
        --this.acquireCount;
        if (this.acquireCount == 0) {
            this.checkRelease();
        }
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public int getTotalListeners() {
        return this.listenerStats.getTotal();
    }

    @Override
    public int getMaxListeners() {
        return this.listenerStats.getMax();
    }

    @Override
    public int getActiveListeners() {
        return this.listenerStats.getCurrent();
    }

    @Override
    public int getTotalChanges() {
        return this.changeStats.intValue();
    }

    @Override
    public int getTotalDeletes() {
        return this.deleteStats.intValue();
    }

    @Override
    public int getTotalSends() {
        return this.sendStats.intValue();
    }
}

