/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.service;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.red5.server.api.IConnection;
import org.red5.server.service.ConversionUtils;

public class ServiceUtils {
    private static final Log log = LogFactory.getLog(ServiceUtils.class);

    public static Object[] findMethodWithExactParameters(Object service, String methodName, List args) {
        Object[] arguments = new Object[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            arguments[i] = args.get(i);
        }
        return ServiceUtils.findMethodWithExactParameters(service, methodName, arguments);
    }

    public static Object[] findMethodWithExactParameters(Object service, String methodName, Object[] args) {
        int i;
        int numParams = args == null ? 0 : args.length;
        List<Method> methods = ConversionUtils.findMethodsByNameAndNumParams(service, methodName, numParams);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + methods.size() + " methods"));
        }
        if (methods.isEmpty()) {
            return new Object[]{null, null};
        }
        if (methods.size() > 1) {
            log.debug((Object)"Multiple methods found with same name and parameter count.");
            log.debug((Object)"Parameter conversion will be attempted in order.");
        }
        Method method = null;
        Object[] params = null;
        for (i = 0; i < methods.size(); ++i) {
            method = methods.get(i);
            boolean valid = true;
            Class<?>[] paramTypes = method.getParameterTypes();
            for (int j = 0; j < args.length; ++j) {
                if ((args[j] != null || !paramTypes[j].isPrimitive()) && (args[j] == null || args[j].getClass().equals(paramTypes[j]))) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            return new Object[]{method, args};
        }
        for (i = 0; i < methods.size(); ++i) {
            try {
                method = methods.get(i);
                params = ConversionUtils.convertParams(args, method.getParameterTypes());
                if (args.length > 0 && args[0] instanceof IConnection && !(params[0] instanceof IConnection)) continue;
                return new Object[]{method, params};
            }
            catch (Exception ex) {
                log.debug((Object)("Parameter conversion failed for " + method));
            }
        }
        return new Object[]{null, null};
    }

    public static Object[] findMethodWithListParameters(Object service, String methodName, List args) {
        Object[] arguments = new Object[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            arguments[i] = args.get(i);
        }
        return ServiceUtils.findMethodWithListParameters(service, methodName, arguments);
    }

    public static Object[] findMethodWithListParameters(Object service, String methodName, Object[] args) {
        List<Method> methods = ConversionUtils.findMethodsByNameAndNumParams(service, methodName, 1);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + methods.size() + " methods"));
        }
        if (methods.isEmpty()) {
            return new Object[]{null, null};
        }
        if (methods.size() > 1) {
            log.debug((Object)"Multiple methods found with same name and parameter count.");
            log.debug((Object)"Parameter conversion will be attempted in order.");
        }
        ArrayList<Object> argsList = new ArrayList<Object>();
        if (args != null) {
            for (Object element : args) {
                argsList.add(element);
            }
        }
        args = new Object[]{argsList};
        Method method = null;
        Object[] params = null;
        for (int i = 0; i < methods.size(); ++i) {
            try {
                method = methods.get(i);
                params = ConversionUtils.convertParams(args, method.getParameterTypes());
                if (argsList.size() > 0 && argsList.get(0) instanceof IConnection && !(params[0] instanceof IConnection)) continue;
                return new Object[]{method, params};
            }
            catch (Exception ex) {
                log.debug((Object)"Parameter conversion failed", (Throwable)ex);
            }
        }
        return new Object[]{null, null};
    }
}

