/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.service;

import org.red5.server.api.service.IServiceCall;

public class Call
implements IServiceCall {
    public static final byte STATUS_PENDING = 1;
    public static final byte STATUS_SUCCESS_RESULT = 2;
    public static final byte STATUS_SUCCESS_NULL = 3;
    public static final byte STATUS_SUCCESS_VOID = 4;
    public static final byte STATUS_SERVICE_NOT_FOUND = 16;
    public static final byte STATUS_METHOD_NOT_FOUND = 17;
    public static final byte STATUS_ACCESS_DENIED = 18;
    public static final byte STATUS_INVOCATION_EXCEPTION = 19;
    public static final byte STATUS_GENERAL_EXCEPTION = 20;
    public static final byte STATUS_APP_SHUTTING_DOWN = 21;
    protected String serviceName;
    protected String serviceMethodName;
    protected Object[] arguments = null;
    protected byte status = 1;
    protected Exception exception;

    public Call(String method) {
        this.serviceMethodName = method;
    }

    public Call(String method, Object[] args) {
        this.serviceMethodName = method;
        this.arguments = args;
    }

    public Call(String name, String method, Object[] args) {
        this.serviceName = name;
        this.serviceMethodName = method;
        this.arguments = args;
    }

    public boolean isSuccess() {
        return this.status == 2 || this.status == 3 || this.status == 4;
    }

    public String getServiceMethodName() {
        return this.serviceMethodName;
    }

    public void setServiceMethodName(String serviceMethodName) {
        this.serviceMethodName = serviceMethodName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void setArguments(Object[] args) {
        this.arguments = args;
    }

    public byte getStatus() {
        return this.status;
    }

    public void setStatus(byte status) {
        this.status = status;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Service: ");
        sb.append(this.serviceName);
        sb.append(" Method: ");
        sb.append(this.serviceMethodName);
        if (this.arguments != null) {
            sb.append(" Num Params: ");
            sb.append(this.arguments.length);
            for (int i = 0; i < this.arguments.length; ++i) {
                sb.append(i);
                sb.append(": ");
                sb.append(this.arguments[i]);
            }
        } else {
            sb.append(" No params");
        }
        return sb.toString();
    }
}

