/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.script.groovy;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.Script;
import java.io.IOException;
import org.codehaus.groovy.control.CompilationFailedException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.scripting.ScriptCompilationException;
import org.springframework.scripting.ScriptFactory;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.groovy.GroovyObjectCustomizer;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class GroovyScriptFactory
implements ScriptFactory,
BeanClassLoaderAware {
    private final String scriptSourceLocator;
    private final GroovyObjectCustomizer groovyObjectCustomizer;
    private GroovyClassLoader groovyClassLoader = new GroovyClassLoader(ClassUtils.getDefaultClassLoader());
    private Class scriptClass;
    private Class scriptResultClass;
    private final Object scriptClassMonitor = new Object();
    private Class[] scriptInterfaces;

    public GroovyScriptFactory(String scriptSourceLocator) {
        Assert.hasText((String)scriptSourceLocator, (String)"'scriptSourceLocator' must not be empty");
        this.scriptSourceLocator = scriptSourceLocator;
        this.groovyObjectCustomizer = null;
    }

    public GroovyScriptFactory(String scriptSourceLocator, GroovyObjectCustomizer groovyObjectCustomizer) {
        Assert.hasText((String)scriptSourceLocator, (String)"'scriptSourceLocator' must not be empty");
        this.scriptSourceLocator = scriptSourceLocator;
        this.groovyObjectCustomizer = groovyObjectCustomizer;
    }

    public GroovyScriptFactory(String scriptSourceLocator, Class[] scriptInterfaces) {
        Assert.hasText((String)scriptSourceLocator, (String)"'scriptSourceLocator' must not be empty");
        this.scriptSourceLocator = scriptSourceLocator;
        this.groovyObjectCustomizer = null;
        this.scriptInterfaces = null == scriptInterfaces || scriptInterfaces.length < 1 ? new Class[0] : scriptInterfaces;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.groovyClassLoader = new GroovyClassLoader(classLoader);
    }

    public String getScriptSourceLocator() {
        return this.scriptSourceLocator;
    }

    public Class[] getScriptInterfaces() {
        return this.scriptInterfaces;
    }

    public boolean requiresConfigInterface() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getScriptedObject(ScriptSource scriptSource, Class[] actualInterfaces) throws IOException, ScriptCompilationException {
        try {
            Class scriptClassToExecute = null;
            Object object = this.scriptClassMonitor;
            synchronized (object) {
                if (this.scriptClass == null || scriptSource.isModified()) {
                    this.scriptClass = this.groovyClassLoader.parseClass(scriptSource.getScriptAsString());
                    if (Script.class.isAssignableFrom(this.scriptClass)) {
                        Object result = this.executeScript(this.scriptClass);
                        this.scriptResultClass = result != null ? result.getClass() : null;
                        return result;
                    }
                    this.scriptResultClass = this.scriptClass;
                }
                scriptClassToExecute = this.scriptClass;
            }
            return this.executeScript(scriptClassToExecute);
        }
        catch (CompilationFailedException ex) {
            throw new ScriptCompilationException("Could not compile Groovy script: " + scriptSource, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getScriptedObjectType(ScriptSource scriptSource) throws IOException, ScriptCompilationException {
        Object object = this.scriptClassMonitor;
        synchronized (object) {
            if (this.scriptClass == null || scriptSource.isModified()) {
                Object result;
                this.scriptClass = this.groovyClassLoader.parseClass(scriptSource.getScriptAsString());
                this.scriptResultClass = Script.class.isAssignableFrom(this.scriptClass) ? ((result = this.executeScript(this.scriptClass)) != null ? result.getClass() : null) : this.scriptClass;
            }
            return this.scriptResultClass;
        }
    }

    protected Object executeScript(Class scriptClass) throws ScriptCompilationException {
        try {
            GroovyObject goo = (GroovyObject)scriptClass.newInstance();
            if (this.groovyObjectCustomizer != null) {
                this.groovyObjectCustomizer.customize(goo);
            }
            if (goo instanceof Script) {
                return ((Script)goo).run();
            }
            return goo;
        }
        catch (InstantiationException ex) {
            throw new ScriptCompilationException("Could not instantiate Groovy script class: " + scriptClass.getName(), (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new ScriptCompilationException("Could not access Groovy script constructor: " + scriptClass.getName(), (Throwable)ex);
        }
    }

    public String toString() {
        return "GroovyScriptFactory: script source locator [" + this.scriptSourceLocator + "]";
    }
}

