/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.pooling;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.red5.server.pooling.ThreadPool;
import org.red5.server.pooling.WorkerThreadMBean;

public class WorkerThread
extends Thread
implements WorkerThreadMBean {
    private static Log log = LogFactory.getLog(WorkerThread.class);
    private boolean stopped;
    private boolean running;
    private boolean done = true;
    private String className;
    private String methodName;
    private Object[] methodParams;
    private Class[] parmTypes;
    private Object syncObject;
    private Object result;
    private ThreadPool pool;

    public void setPool(ThreadPool pool) {
        this.pool = pool;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public Object getResult() {
        return this.result;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Object[] getMethodParams() {
        return this.methodParams;
    }

    public void setMethodParams(Object[] methodParams) {
        this.methodParams = methodParams;
    }

    public Class[] getParmTypes() {
        return this.parmTypes;
    }

    public void setParmTypes(Class[] parmTypes) {
        this.parmTypes = parmTypes;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    public Object getSyncObject() {
        return this.syncObject;
    }

    public void setSyncObject(Object syncObject) {
        this.syncObject = syncObject;
    }

    public synchronized void execute(String clsName, String methName, Object[] params, Class[] paramTypes, Object synObj) {
        this.className = clsName;
        this.methodName = methName;
        this.methodParams = params;
        this.syncObject = synObj;
        this.parmTypes = paramTypes;
        this.done = false;
        if (!this.running) {
            this.setDaemon(true);
            this.start();
        } else {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.running = true;
        while (!this.stopped) {
            Object object;
            if (this.done) {
                object = this;
                synchronized (object) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        this.stopped = true;
                        log.error((Object)"", (Throwable)e);
                    }
                    continue;
                }
            }
            try {
                this.execute();
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
            finally {
                if (this.syncObject != null) {
                    object = this.syncObject;
                    synchronized (object) {
                        this.syncObject.notify();
                    }
                }
                this.reset();
                this.returnToPool();
            }
        }
    }

    private void returnToPool() {
        if (this.pool != null) {
            try {
                this.pool.returnObject(this);
            }
            catch (Exception e1) {
                log.error((Object)"Exception :", (Throwable)e1);
            }
            this.pool = null;
        }
    }

    public void reset() {
        this.done = true;
        this.className = null;
        this.methodName = null;
        this.methodParams = null;
        this.parmTypes = null;
        this.syncObject = null;
    }

    private static Class getClass(String cls) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = WorkerThread.class.getClassLoader();
        }
        return classLoader.loadClass(cls);
    }

    private void execute() {
        try {
            Class cls = WorkerThread.getClass(this.getClassName());
            Object obj = cls.newInstance();
            this.result = MethodUtils.invokeExactMethod(obj, (String)this.getMethodName(), (Object[])this.getMethodParams(), (Class[])this.getParmTypes());
            if (log.isDebugEnabled()) {
                log.debug((Object)(" #### Execution Result = " + this.result + " for : " + this));
            }
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("ClassNotFoundException - " + e));
        }
        catch (NoSuchMethodException e) {
            log.error((Object)("NoSuchMethodException - " + e));
        }
        catch (IllegalAccessException e) {
            log.error((Object)("IllegalAccessException - " + e));
        }
        catch (InvocationTargetException e) {
            log.error((Object)("InvocationTargetException - " + e));
        }
        catch (InstantiationException e) {
            log.error((Object)("InstantiationException - " + e));
        }
    }
}

