/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.pooling;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.red5.server.pooling.WorkerThread;

public class ThreadObjectFactory
implements PoolableObjectFactory {
    private static final Log log = LogFactory.getLog(ThreadObjectFactory.class);

    public Object makeObject() {
        if (log.isDebugEnabled()) {
            log.debug((Object)" makeObject...");
        }
        return new WorkerThread();
    }

    public void destroyObject(Object obj) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(" !!! destroyObject... !!!" + obj));
        }
        if (obj instanceof WorkerThread) {
            WorkerThread rt = (WorkerThread)obj;
            rt.setStopped(true);
        }
    }

    public boolean validateObject(Object obj) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(" validateObject..." + obj));
        }
        if (obj instanceof WorkerThread) {
            WorkerThread rt = (WorkerThread)obj;
            if (!rt.isDone()) {
                return false;
            }
            if (rt.isRunning()) {
                return rt.getThreadGroup() != null;
            }
        }
        return true;
    }

    public void activateObject(Object obj) {
        log.debug((Object)" activateObject...");
    }

    public void passivateObject(Object obj) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(" passivateObject..." + obj));
        }
        if (obj instanceof WorkerThread) {
            WorkerThread wt = (WorkerThread)obj;
            wt.setResult(null);
        }
    }
}

