/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletUtils {
    public static final int DEFAULT_BUFFER_SIZE = 2048;

    public static void copy(InputStream input, OutputStream output) throws IOException {
        ServletUtils.copy(input, output, 2048);
    }

    public static void copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        byte[] buf = new byte[bufferSize];
        int bytesRead = input.read(buf);
        while (bytesRead != -1) {
            output.write(buf, 0, bytesRead);
            bytesRead = input.read(buf);
        }
        output.flush();
    }

    public static void copyThenClose(InputStream input, OutputStream output) throws IOException {
        ServletUtils.copy(input, output);
        input.close();
        output.close();
    }

    public static byte[] getBytes(InputStream input) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        ServletUtils.copy(input, result);
        result.close();
        return result.toByteArray();
    }

    public static List<String> getRemoteAddresses(HttpServletRequest request) {
        String httpVia;
        String forwardedFor;
        ArrayList<String> addresses = new ArrayList<String>();
        addresses.add(request.getRemoteHost());
        if (!request.getRemoteAddr().equals(request.getRemoteHost())) {
            addresses.add(request.getRemoteAddr());
        }
        if ((forwardedFor = request.getHeader("X-Forwarded-For")) != null) {
            String[] parts;
            for (String part : parts = forwardedFor.split(",")) {
                addresses.add(part);
            }
        }
        if ((httpVia = request.getHeader("Via")) != null) {
            String[] parts;
            for (String part : parts = httpVia.split(",")) {
                addresses.add(part);
            }
        }
        return Collections.unmodifiableList(addresses);
    }
}

