/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmpt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.ByteBuffer;
import org.red5.server.net.rtmpt.RTMPTConnection;
import org.red5.server.net.rtmpt.RTMPTHandler;
import org.red5.server.net.servlet.ServletUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class RTMPTServlet
extends HttpServlet {
    private static final long serialVersionUID = 5925399677454936613L;
    protected static Log log = LogFactory.getLog(RTMPTServlet.class);
    private static final String REQUEST_METHOD = "POST";
    private static final String CONTENT_TYPE = "application/x-fcs";
    private static final int RESPONSE_TARGET_SIZE = 32768;
    protected HashMap<Integer, RTMPTConnection> rtmptClients = new HashMap();
    protected WebApplicationContext appCtx;
    private static RTMPTHandler handler;

    public void setHandler(RTMPTHandler handler) {
        RTMPTServlet.handler = handler;
    }

    protected void handleBadRequest(String message, HttpServletResponse resp) throws IOException {
        resp.setStatus(400);
        resp.setContentType("text/plain");
        resp.setContentLength(message.length());
        resp.getWriter().write(message);
        resp.flushBuffer();
    }

    protected void returnMessage(byte message, HttpServletResponse resp) throws IOException {
        resp.setStatus(200);
        resp.setHeader("Connection", "Keep-Alive");
        resp.setHeader("Cache-Control", "no-cache");
        resp.setContentType(CONTENT_TYPE);
        resp.setContentLength(1);
        resp.getWriter().write(message);
        resp.flushBuffer();
    }

    protected void returnMessage(String message, HttpServletResponse resp) throws IOException {
        resp.setStatus(200);
        resp.setHeader("Connection", "Keep-Alive");
        resp.setHeader("Cache-Control", "no-cache");
        resp.setContentType(CONTENT_TYPE);
        resp.setContentLength(message.length());
        resp.getWriter().write(message);
        resp.flushBuffer();
    }

    protected void returnMessage(RTMPTConnection client, ByteBuffer buffer, HttpServletResponse resp) throws IOException {
        resp.setStatus(200);
        resp.setHeader("Connection", "Keep-Alive");
        resp.setHeader("Cache-Control", "no-cache");
        resp.setContentType(CONTENT_TYPE);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending " + buffer.limit() + " bytes."));
        }
        resp.setContentLength(buffer.limit() + 1);
        ServletOutputStream output = resp.getOutputStream();
        output.write((int)client.getPollingDelay());
        ServletUtils.copy(buffer.asInputStream(), (OutputStream)output);
        buffer.release();
        buffer = null;
    }

    protected Integer getClientId(HttpServletRequest req) {
        String path = req.getPathInfo();
        if (path.equals("")) {
            return null;
        }
        while (path.length() > 1 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        int endPos = path.indexOf(47);
        if (endPos != -1) {
            path = path.substring(0, endPos);
        }
        try {
            return Integer.parseInt(path);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected RTMPTConnection getClient(HttpServletRequest req) {
        Integer id = this.getClientId(req);
        if (id == null || !this.rtmptClients.containsKey(id)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unknown client id: " + id));
            }
            return null;
        }
        return this.rtmptClients.get(id);
    }

    protected void skipData(HttpServletRequest req) throws IOException {
        ByteBuffer data = ByteBuffer.allocate((int)req.getContentLength());
        ServletUtils.copy((InputStream)req.getInputStream(), data.asOutputStream());
        data.flip();
        data.release();
        data = null;
    }

    protected void returnPendingMessages(RTMPTConnection client, HttpServletResponse resp) throws IOException {
        ByteBuffer data = client.getPendingMessages(32768);
        if (data == null) {
            if (client.isClosing()) {
                this.returnMessage((byte)0, resp);
            } else {
                this.returnMessage(client.getPollingDelay(), resp);
            }
            return;
        }
        this.returnMessage(client, data, resp);
    }

    protected void handleOpen(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.skipData(req);
        RTMPTConnection client = handler.createRTMPTConnection();
        if (client.getId() == 0) {
            this.returnMessage((byte)0, resp);
            return;
        }
        this.rtmptClients.put(client.getId(), client);
        this.returnMessage(client.getId() + "\n", resp);
    }

    protected void handleClose(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.skipData(req);
        RTMPTConnection client = this.getClient(req);
        if (client == null) {
            this.handleBadRequest("Unknown client.", resp);
            return;
        }
        this.rtmptClients.remove(client.getId());
        client.setServletRequest(req);
        handler.connectionClosed(client, client.getState());
        this.returnMessage((byte)0, resp);
        client.realClose();
    }

    protected void handleSend(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RTMPTConnection client = this.getClient(req);
        if (client == null) {
            this.handleBadRequest("Unknown client.", resp);
            return;
        }
        if (client.getState().getState() == 4) {
            this.rtmptClients.remove(client.getId());
            this.handleBadRequest("Connection already closed.", resp);
            return;
        }
        client.setServletRequest(req);
        int length = req.getContentLength();
        ByteBuffer data = ByteBuffer.allocate((int)length);
        ServletUtils.copy((InputStream)req.getInputStream(), data.asOutputStream());
        data.flip();
        List messages = client.decode(data);
        data.release();
        data = null;
        if (messages == null || messages.isEmpty()) {
            this.returnMessage(client.getPollingDelay(), resp);
            return;
        }
        for (Object message : messages) {
            try {
                handler.messageReceived(client, client.getState(), message);
            }
            catch (Exception e) {
                log.error((Object)"Could not process message.", (Throwable)e);
            }
        }
        this.returnPendingMessages(client, resp);
        if (client.isClosing()) {
            client.realClose();
        }
    }

    protected void handleIdle(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.skipData(req);
        RTMPTConnection client = this.getClient(req);
        if (client == null) {
            this.handleBadRequest("Unknown client.", resp);
            return;
        }
        if (client.isClosing()) {
            this.returnMessage((byte)0, resp);
            client.realClose();
            return;
        }
        if (client.getState().getState() == 4) {
            this.rtmptClients.remove(client.getId());
            this.handleBadRequest("Connection already closed.", resp);
            return;
        }
        client.setServletRequest(req);
        this.returnPendingMessages(client, resp);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!REQUEST_METHOD.equals(req.getMethod()) || req.getContentLength() == 0 || !CONTENT_TYPE.equals(req.getContentType())) {
            this.handleBadRequest("Bad request, only RTMPT supported.", resp);
            return;
        }
        String path = req.getServletPath();
        char p = path.charAt(1);
        switch (p) {
            case 'o': {
                this.handleOpen(req, resp);
                break;
            }
            case 'c': {
                this.handleClose(req, resp);
                break;
            }
            case 's': {
                this.handleSend(req, resp);
                break;
            }
            case 'i': {
                this.handleIdle(req, resp);
                break;
            }
            default: {
                this.handleBadRequest("RTMPT command " + path + " is not supported.", resp);
            }
        }
    }

    public void init() throws ServletException {
        super.init();
        this.appCtx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        if (this.appCtx == null) {
            this.appCtx = (WebApplicationContext)this.getServletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        }
    }
}

