/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.status;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.BeanMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.ByteBuffer;
import org.red5.io.amf.Output;
import org.red5.io.object.Serializer;
import org.red5.io.utils.HexDump;
import org.red5.server.net.rtmp.status.RuntimeStatusObject;
import org.red5.server.net.rtmp.status.StatusCodes;
import org.red5.server.net.rtmp.status.StatusObject;

public class StatusObjectService
implements StatusCodes {
    protected static Log log = LogFactory.getLog((String)StatusObjectService.class.getName());
    protected Serializer serializer;
    protected Map<String, StatusObject> statusObjects;
    protected Map<String, byte[]> cachedStatusObjects;

    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    public void initialize() {
        log.debug((Object)"Loading status objects");
        this.loadStatusObjects();
        log.debug((Object)"Caching status objects");
        this.cacheStatusObjects();
        log.debug((Object)"Status service ready");
    }

    public void loadStatusObjects() {
        this.statusObjects = new HashMap<String, StatusObject>();
        this.statusObjects.put("NetConnection.Call.Failed", new StatusObject("NetConnection.Call.Failed", "error", ""));
        this.statusObjects.put("NetConnection.Call.BadVersion", new StatusObject("NetConnection.Call.BadVersion", "error", ""));
        this.statusObjects.put("NetConnection.Connect.AppShutdown", new StatusObject("NetConnection.Connect.AppShutdown", "error", ""));
        this.statusObjects.put("NetConnection.Connect.Closed", new StatusObject("NetConnection.Connect.Closed", "status", ""));
        this.statusObjects.put("NetConnection.Connect.Failed", new StatusObject("NetConnection.Connect.Failed", "error", ""));
        this.statusObjects.put("NetConnection.Connect.Rejected", new StatusObject("NetConnection.Connect.Rejected", "error", ""));
        this.statusObjects.put("NetConnection.Connect.Success", new StatusObject("NetConnection.Connect.Success", "status", "Connection succeeded."));
        this.statusObjects.put("NetConnection.Connect.InvalidApp", new StatusObject("NetConnection.Connect.InvalidApp", "error", ""));
        this.statusObjects.put("NetStream.InvalidArg", new StatusObject("NetStream.InvalidArg", "error", ""));
        this.statusObjects.put("NetStream.Clear.Success", new StatusObject("NetStream.Clear.Success", "status", ""));
        this.statusObjects.put("NetStream.Clear.Failed", new StatusObject("NetStream.Clear.Failed", "error", ""));
        this.statusObjects.put("NetStream.Publish.Start", new StatusObject("NetStream.Publish.Start", "status", ""));
        this.statusObjects.put("NetStream.Publish.BadName", new StatusObject("NetStream.Publish.BadName", "error", ""));
        this.statusObjects.put("NetStream.Failed", new StatusObject("NetStream.Failed", "error", ""));
        this.statusObjects.put("NetStream.Unpublish.Success", new StatusObject("NetStream.Unpublish.Success", "status", ""));
        this.statusObjects.put("NetStream.Record.Start", new StatusObject("NetStream.Record.Start", "status", ""));
        this.statusObjects.put("NetStream.Record.NoAccess", new StatusObject("NetStream.Record.NoAccess", "error", ""));
        this.statusObjects.put("NetStream.Record.Stop", new StatusObject("NetStream.Record.Stop", "status", ""));
        this.statusObjects.put("NetStream.Record.Failed", new StatusObject("NetStream.Record.Failed", "error", ""));
        this.statusObjects.put("NetStream.Play.InsufficientBW", new RuntimeStatusObject("NetStream.Play.InsufficientBW", "warning", ""));
        this.statusObjects.put("NetStream.Play.Start", new RuntimeStatusObject("NetStream.Play.Start", "status", ""));
        this.statusObjects.put("NetStream.Play.StreamNotFound", new RuntimeStatusObject("NetStream.Play.StreamNotFound", "error", ""));
        this.statusObjects.put("NetStream.Play.Stop", new RuntimeStatusObject("NetStream.Play.Stop", "status", ""));
        this.statusObjects.put("NetStream.Play.Failed", new RuntimeStatusObject("NetStream.Play.Failed", "error", ""));
        this.statusObjects.put("NetStream.Play.Reset", new RuntimeStatusObject("NetStream.Play.Reset", "status", ""));
        this.statusObjects.put("NetStream.Play.PublishNotify", new RuntimeStatusObject("NetStream.Play.PublishNotify", "status", ""));
        this.statusObjects.put("NetStream.Play.UnpublishNotify", new RuntimeStatusObject("NetStream.Play.UnpublishNotify", "status", ""));
        this.statusObjects.put("NetStream.Data.Start", new StatusObject("NetStream.Data.Start", "status", ""));
        this.statusObjects.put("Application.Script.Error", new StatusObject("Application.Script.Error", "status", ""));
        this.statusObjects.put("Application.Script.Warning", new StatusObject("Application.Script.Warning", "status", ""));
        this.statusObjects.put("Application.Resource.LowMemory", new StatusObject("Application.Resource.LowMemory", "status", ""));
        this.statusObjects.put("Application.Shutdown", new StatusObject("Application.Shutdown", "status", ""));
        this.statusObjects.put("Application.GC", new StatusObject("Application.GC", "status", ""));
    }

    public void cacheStatusObjects() {
        this.cachedStatusObjects = new HashMap<String, byte[]>();
        ByteBuffer out = ByteBuffer.allocate((int)256);
        out.setAutoExpand(true);
        for (String s : this.statusObjects.keySet()) {
            String statusCode = s;
            StatusObject statusObject = this.statusObjects.get(statusCode);
            if (statusObject instanceof RuntimeStatusObject) continue;
            this.serializeStatusObject(out, statusObject);
            out.flip();
            log.debug((Object)HexDump.formatHexDump(out.getHexDump()));
            byte[] cachedBytes = new byte[out.limit()];
            out.get(cachedBytes);
            out.clear();
            this.cachedStatusObjects.put(statusCode, cachedBytes);
        }
        out.release();
        out = null;
    }

    public void serializeStatusObject(ByteBuffer out, StatusObject statusObject) {
        BeanMap statusMap = new BeanMap((Object)statusObject);
        Output output = new Output(out);
        this.serializer.serialize(output, statusMap);
    }

    public StatusObject getStatusObject(String statusCode) {
        return this.statusObjects.get(statusCode);
    }

    public byte[] getCachedStatusObjectAsByteArray(String statusCode) {
        return this.cachedStatusObjects.get(statusCode);
    }
}

