/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.codec;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;
import org.red5.server.api.IConnection;
import org.red5.server.net.protocol.ProtocolState;
import org.red5.server.net.rtmp.message.Header;
import org.red5.server.net.rtmp.message.Packet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTMP
extends ProtocolState {
    public static final byte STATE_CONNECT = 0;
    public static final byte STATE_HANDSHAKE = 1;
    public static final byte STATE_CONNECTED = 2;
    public static final byte STATE_ERROR = 3;
    public static final byte STATE_DISCONNECTED = 4;
    public static final boolean MODE_CLIENT = true;
    public static final boolean MODE_SERVER = false;
    public static final int DEFAULT_CHUNK_SIZE = 128;
    private byte state = 0;
    private boolean mode = false;
    private boolean debug;
    private int lastReadChannel = 0;
    private int lastWriteChannel = 0;
    private Map<Integer, Header> readHeaders = new HashMap<Integer, Header>();
    private Map<Integer, Header> writeHeaders = new HashMap<Integer, Header>();
    private Map<Integer, Packet> readPackets = new HashMap<Integer, Packet>();
    private Map<Integer, Packet> writePackets = new HashMap<Integer, Packet>();
    private int readChunkSize = 128;
    private int writeChunkSize = 128;
    private IConnection.Encoding encoding = IConnection.Encoding.AMF0;
    private byte[] handshake;

    public RTMP(boolean mode) {
        this.mode = mode;
    }

    public boolean getMode() {
        return this.mode;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public byte getState() {
        return this.state;
    }

    private void freePackets(Map<Integer, Packet> packets) {
        for (Packet packet : packets.values()) {
            if (packet == null || packet.getData() == null) continue;
            packet.getData().release();
            packet.setData(null);
        }
        packets.clear();
    }

    public void setState(byte state) {
        this.state = state;
        if (state == 4) {
            this.freePackets(this.readPackets);
            this.freePackets(this.writePackets);
            this.readHeaders.clear();
            this.writeHeaders.clear();
        }
    }

    public void setLastReadHeader(int channelId, Header header) {
        this.lastReadChannel = channelId;
        this.readHeaders.put(channelId, header);
    }

    public Header getLastReadHeader(int channelId) {
        return this.readHeaders.get(channelId);
    }

    public void setLastWriteHeader(int channelId, Header header) {
        this.lastWriteChannel = channelId;
        this.writeHeaders.put(channelId, header);
    }

    public Header getLastWriteHeader(int channelId) {
        return this.writeHeaders.get(channelId);
    }

    public void setLastReadPacket(int channelId, Packet packet) {
        Packet prevPacket = this.readPackets.put(channelId, packet);
        if (prevPacket != null && prevPacket.getData() != null) {
            prevPacket.getData().release();
            prevPacket.setData(null);
        }
    }

    public Packet getLastReadPacket(int channelId) {
        return this.readPackets.get(channelId);
    }

    public void setLastWritePacket(int channelId, Packet packet) {
    }

    public Packet getLastWritePacket(int channelId) {
        return this.writePackets.get(channelId);
    }

    public int getLastReadChannel() {
        return this.lastReadChannel;
    }

    public int getLastWriteChannel() {
        return this.lastWriteChannel;
    }

    public int getReadChunkSize() {
        return this.readChunkSize;
    }

    public void setReadChunkSize(int readChunkSize) {
        this.readChunkSize = readChunkSize;
    }

    public int getWriteChunkSize() {
        return this.writeChunkSize;
    }

    public void setWriteChunkSize(int writeChunkSize) {
        this.writeChunkSize = writeChunkSize;
    }

    public IConnection.Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(IConnection.Encoding encoding) {
        this.encoding = encoding;
    }

    public void setHandshake(ByteBuffer data, int start, int length) {
        this.handshake = new byte[length];
        int old = data.position();
        data.position(start);
        data.get(this.handshake);
        data.position(old);
    }

    public boolean validateHandshakeReply(ByteBuffer data, int start, int length) {
        if (this.handshake == null || length != this.handshake.length) {
            return false;
        }
        byte[] reply = new byte[length];
        int old = data.position();
        data.position(start);
        data.get(reply);
        data.position(old);
        return Arrays.equals(reply, this.handshake);
    }
}

