/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import java.lang.ref.WeakReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.red5.server.api.service.IPendingServiceCall;
import org.red5.server.net.rtmp.Channel;
import org.red5.server.net.rtmp.event.Invoke;

public class DeferredResult {
    protected static Log log = LogFactory.getLog((String)DeferredResult.class.getName());
    private WeakReference<Channel> channel;
    private IPendingServiceCall call;
    private int invokeId;
    private boolean resultSent = false;

    public void setResult(Object result) {
        if (this.resultSent) {
            throw new RuntimeException("You can only set the result once.");
        }
        this.resultSent = true;
        Channel channel = (Channel)this.channel.get();
        if (channel == null) {
            log.warn((Object)"The client is no longer connected.");
            return;
        }
        Invoke reply = new Invoke();
        this.call.setResult(result);
        reply.setCall(this.call);
        reply.setInvokeId(this.invokeId);
        channel.write(reply);
        channel.getConnection().unregisterDeferredResult(this);
    }

    public boolean wasSent() {
        return this.resultSent;
    }

    protected void setInvokeId(int id) {
        this.invokeId = id;
    }

    protected void setServiceCall(IPendingServiceCall call) {
        this.call = call;
    }

    protected void setChannel(Channel channel) {
        this.channel = new WeakReference<Channel>(channel);
    }
}

