/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.red5.server.api.stream.IClientStream;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.event.Invoke;
import org.red5.server.net.rtmp.event.Notify;
import org.red5.server.net.rtmp.message.Header;
import org.red5.server.net.rtmp.message.Packet;
import org.red5.server.net.rtmp.status.Status;
import org.red5.server.service.Call;
import org.red5.server.service.PendingCall;

public class Channel {
    protected static Log log = LogFactory.getLog((String)Channel.class.getName());
    private RTMPConnection connection;
    private int id;

    public Channel(RTMPConnection conn, int channelId) {
        this.connection = conn;
        this.id = channelId;
    }

    public void close() {
        this.connection.closeChannel(this.id);
    }

    public int getId() {
        return this.id;
    }

    protected RTMPConnection getConnection() {
        return this.connection;
    }

    public void write(IRTMPEvent event) {
        IClientStream stream = this.connection.getStreamByChannelId(this.id);
        if (this.id > 3 && stream == null) {
            log.info((Object)("Stream doesn't exist any longer, discarding message " + event));
            return;
        }
        int streamId = stream == null ? 0 : stream.getStreamId();
        this.write(event, streamId);
    }

    private void write(IRTMPEvent event, int streamId) {
        Header header = new Header();
        Packet packet = new Packet(header, event);
        header.setChannelId(this.id);
        header.setTimer(event.getTimestamp());
        header.setStreamId(streamId);
        header.setDataType(event.getDataType());
        if (event.getHeader() != null) {
            header.setTimerRelative(event.getHeader().isTimerRelative());
        }
        this.connection.write(packet);
    }

    public void sendStatus(Status status) {
        Invoke invoke;
        boolean andReturn;
        boolean bl = andReturn = !status.getCode().equals("NetStream.Data.Start");
        if (andReturn) {
            PendingCall call = new PendingCall(null, "onStatus", new Object[]{status});
            invoke = new Invoke();
            invoke.setInvokeId(1);
            invoke.setCall(call);
        } else {
            Call call = new Call(null, "onStatus", new Object[]{status});
            invoke = (Invoke)new Notify();
            invoke.setInvokeId(1);
            invoke.setCall(call);
        }
        this.write(invoke, this.connection.getStreamIdForChannel(this.id));
    }
}

