/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.remoting.codec;

import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.red5.compatibility.flex.messaging.messages.AbstractMessage;
import org.red5.compatibility.flex.messaging.messages.ErrorMessage;
import org.red5.io.amf3.Output;
import org.red5.io.object.Serializer;
import org.red5.server.api.IConnection;
import org.red5.server.api.Red5;
import org.red5.server.api.remoting.IRemotingConnection;
import org.red5.server.api.remoting.IRemotingHeader;
import org.red5.server.net.protocol.BaseProtocolEncoder;
import org.red5.server.net.protocol.ProtocolState;
import org.red5.server.net.protocol.SimpleProtocolEncoder;
import org.red5.server.net.remoting.FlexMessagingService;
import org.red5.server.net.remoting.message.RemotingCall;
import org.red5.server.net.remoting.message.RemotingPacket;
import org.red5.server.service.ServiceNotFoundException;

public class RemotingProtocolEncoder
extends BaseProtocolEncoder
implements SimpleProtocolEncoder {
    protected static Log log = LogFactory.getLog((String)RemotingProtocolEncoder.class.getName());
    protected static Log ioLog = LogFactory.getLog((String)(RemotingProtocolEncoder.class.getName() + ".out"));
    private Serializer serializer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer encode(ProtocolState state, Object message) throws Exception {
        org.red5.io.amf.Output output;
        Collection<IRemotingHeader> headers;
        RemotingPacket resp = (RemotingPacket)message;
        ByteBuffer buf = ByteBuffer.allocate((int)1024);
        buf.setAutoExpand(true);
        if (resp.getEncoding() == IConnection.Encoding.AMF0) {
            buf.putShort((short)0);
        } else {
            buf.putShort((short)3);
        }
        IRemotingConnection conn = (IRemotingConnection)Red5.getConnectionLocal();
        Collection<IRemotingHeader> collection = headers = conn.getHeaders();
        synchronized (collection) {
            buf.putShort((short)headers.size());
            output = resp.getEncoding() == IConnection.Encoding.AMF0 ? new org.red5.io.amf.Output(buf) : new Output(buf);
            for (IRemotingHeader header : headers) {
                org.red5.io.amf.Output.putString(buf, "RequestPersistentHeader");
                output.writeBoolean(false);
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("name", header.getName());
                param.put("mustUnderstand", header.getMustUnderstand() ? Boolean.TRUE : Boolean.FALSE);
                param.put("data", header.getName());
                this.serializer.serialize(output, param);
            }
            headers.clear();
        }
        buf.putShort((short)resp.getCalls().size());
        for (RemotingCall call : resp.getCalls()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Call");
            }
            org.red5.io.amf.Output.putString(buf, call.getClientResponse());
            if (!call.isMessaging) {
                org.red5.io.amf.Output.putString(buf, "null");
            } else {
                org.red5.io.amf.Output.putString(buf, "");
            }
            buf.putInt(-1);
            if (log.isDebugEnabled()) {
                log.info((Object)("result:" + call.getResult()));
            }
            output = call.isAMF3 ? new Output(buf) : new org.red5.io.amf.Output(buf);
            Object result = call.getClientResult();
            if (!call.isSuccess()) {
                if (call.isMessaging && !(result instanceof ErrorMessage)) {
                    ServiceNotFoundException ex;
                    AbstractMessage request = (AbstractMessage)call.getArguments()[0];
                    result = result instanceof ServiceNotFoundException ? ("flexMessaging".equals((ex = (ServiceNotFoundException)result).getServiceName()) ? FlexMessagingService.returnError(request, "serviceNotAvailable", "Flex messaging not activated", ex.getMessage()) : FlexMessagingService.returnError(request, "serviceNotAvailable", "Flex messaging not activated", ex.getMessage())) : (result instanceof Throwable ? FlexMessagingService.returnError(request, "Server.Invoke.Error", ((Throwable)result).getMessage(), (Throwable)result) : FlexMessagingService.returnError(request, "Server.Invoke.Error", result.toString(), ""));
                } else if (!call.isMessaging) {
                    result = this.generateErrorResult("NetConnection.Call.Failed", call.getException());
                }
            }
            this.serializer.serialize(output, result);
        }
        buf.flip();
        if (log.isDebugEnabled()) {
            log.debug((Object)(">>" + buf.getHexDump()));
        }
        return buf;
    }

    public void dispose(IoSession ioSession) throws Exception {
    }

    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }
}

