/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.remoting.codec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.red5.io.amf3.Input;
import org.red5.io.object.BaseInput;
import org.red5.io.object.Deserializer;
import org.red5.server.net.protocol.ProtocolState;
import org.red5.server.net.protocol.SimpleProtocolDecoder;
import org.red5.server.net.remoting.message.RemotingCall;
import org.red5.server.net.remoting.message.RemotingPacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemotingProtocolDecoder
implements SimpleProtocolDecoder {
    protected static Log log = LogFactory.getLog((String)RemotingProtocolDecoder.class.getName());
    protected static Log ioLog = LogFactory.getLog((String)(RemotingProtocolDecoder.class.getName() + ".in"));
    private Deserializer deserializer;

    public void setDeserializer(Deserializer deserializer) {
        this.deserializer = deserializer;
    }

    @Override
    public List<Object> decodeBuffer(ProtocolState state, ByteBuffer buffer) {
        LinkedList<Object> list = new LinkedList<Object>();
        Object packet = null;
        try {
            packet = this.decode(state, buffer);
        }
        catch (Exception e) {
            log.error((Object)"Decoding error", (Throwable)e);
            packet = null;
        }
        if (packet != null) {
            list.add(packet);
        }
        return list;
    }

    @Override
    public Object decode(ProtocolState state, ByteBuffer in) throws Exception {
        Map<String, Object> headers = this.readHeaders(in);
        List<RemotingCall> calls = this.decodeCalls(in);
        return new RemotingPacket(headers, calls);
    }

    public void dispose(IoSession session) throws Exception {
    }

    protected Map<String, Object> readHeaders(ByteBuffer in) {
        int version = in.getUnsignedShort();
        int count = in.getUnsignedShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Skip headers");
            log.debug((Object)("Version: " + version));
            log.debug((Object)("Count: " + count));
        }
        if (count == 0) {
            return Collections.EMPTY_MAP;
        }
        Deserializer deserializer = new Deserializer();
        org.red5.io.amf.Input input = version == 3 ? new Input(in) : new org.red5.io.amf.Input(in);
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < count; ++i) {
            String name = org.red5.io.amf.Input.getString(in);
            boolean required = in.get() == 1;
            int size = in.getInt();
            Object value = deserializer.deserialize(input);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Header: " + name));
                log.debug((Object)("Required: " + required));
                log.debug((Object)("Size: " + size));
                log.debug((Object)("Value: " + value));
            }
            result.put(name, value);
        }
        return result;
    }

    protected List<RemotingCall> decodeCalls(ByteBuffer in) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Decode calls");
        }
        LinkedList<RemotingCall> calls = new LinkedList<RemotingCall>();
        int count = in.getUnsignedShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Calls: " + count));
        }
        int limit = in.limit();
        for (int i = 0; i < count; ++i) {
            String serviceMethod;
            String serviceName;
            in.limit(limit);
            String serviceString = org.red5.io.amf.Input.getString(in);
            String clientCallback = org.red5.io.amf.Input.getString(in);
            if (log.isDebugEnabled()) {
                log.debug((Object)("callback: " + clientCallback));
            }
            int length = in.getInt();
            byte type = in.get();
            if (type != 10) {
                throw new RuntimeException("AMF0 array type expected but found " + type);
            }
            int elements = in.getInt();
            boolean isAMF3 = false;
            ArrayList<Object> values = new ArrayList<Object>();
            for (int j = 0; j < elements; ++j) {
                byte amf3Check = in.get();
                in.position(in.position() - 1);
                isAMF3 = amf3Check == 17;
                org.red5.io.amf.Input input = isAMF3 ? new Input(in) : new org.red5.io.amf.Input(in);
                input.reset(BaseInput.ReferenceMode.MODE_REMOTING);
                values.add(this.deserializer.deserialize(input));
            }
            int dotPos = serviceString.lastIndexOf(46);
            if (dotPos != -1) {
                serviceName = serviceString.substring(0, dotPos);
                serviceMethod = serviceString.substring(dotPos + 1, serviceString.length());
            } else {
                serviceName = "";
                serviceMethod = serviceString;
            }
            boolean isMessaging = false;
            if ("".equals(serviceName) && "null".equals(serviceMethod)) {
                serviceName = "flexMessaging";
                serviceMethod = "handleRequest";
                isMessaging = true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Service: " + serviceName + " Method: " + serviceMethod));
            }
            Object[] args = values.toArray(new Object[values.size()]);
            if (log.isDebugEnabled()) {
                for (Object element : args) {
                    log.debug((Object)("> " + element));
                }
            }
            calls.add(new RemotingCall(serviceName, serviceMethod, args, clientCallback, isAMF3, isMessaging));
        }
        return calls;
    }
}

