/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.remoting;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.ByteBuffer;
import org.red5.io.amf.Input;
import org.red5.io.amf.Output;
import org.red5.io.object.Deserializer;
import org.red5.io.object.RecordSet;
import org.red5.io.object.Serializer;
import org.red5.server.net.remoting.IRemotingCallback;
import org.red5.server.net.remoting.RemotingHeader;
import org.red5.server.net.servlet.ServletUtils;
import org.red5.server.pooling.ThreadPool;
import org.red5.server.pooling.WorkerThread;

public class RemotingClient {
    protected static Log log = LogFactory.getLog((String)RemotingClient.class.getName());
    public static final int DEFAULT_TIMEOUT = 30000;
    private static final String CONTENT_TYPE = "application/x-amf";
    private static HttpConnectionManager connectionMgr = new MultiThreadedHttpConnectionManager();
    private HttpClient client;
    private String url;
    private String appendToUrl = "";
    protected Map<String, RemotingHeader> headers = new ConcurrentHashMap<String, RemotingHeader>();
    protected static ThreadPool threadPool;

    public RemotingClient() {
    }

    public RemotingClient(String url) {
        this(url, 30000);
    }

    public void setThreadPool(ThreadPool threadPool) {
        RemotingClient.threadPool = threadPool;
    }

    public RemotingClient(String url, int timeout) {
        this.client = new HttpClient(connectionMgr);
        this.client.getHttpConnectionManager().getParams().setConnectionTimeout(timeout);
        this.url = url;
    }

    private ByteBuffer encodeInvoke(String method, Object[] params) {
        ByteBuffer result = ByteBuffer.allocate((int)1024);
        result.setAutoExpand(true);
        result.putShort((short)0);
        Collection<RemotingHeader> hdr = this.headers.values();
        result.putShort((short)hdr.size());
        for (RemotingHeader header : hdr) {
            Output.putString(result, header.name);
            result.put(header.required ? (byte)1 : 0);
            ByteBuffer tmp = ByteBuffer.allocate((int)1024);
            tmp.setAutoExpand(true);
            Output tmpOut = new Output(tmp);
            Serializer tmpSer = new Serializer();
            tmpSer.serialize(tmpOut, header.data);
            tmp.flip();
            result.putInt(tmp.limit());
            result.put(tmp);
            tmp.release();
            tmp = null;
        }
        result.putShort((short)1);
        Output.putString(result, method);
        Output.putString(result, "");
        ByteBuffer tmp = ByteBuffer.allocate((int)1024);
        tmp.setAutoExpand(true);
        Output tmpOut = new Output(tmp);
        tmpOut.writeArray(params, new Serializer());
        tmp.flip();
        result.putInt(tmp.limit());
        result.put(tmp);
        tmp.release();
        tmp = null;
        result.flip();
        return result;
    }

    protected void processHeaders(ByteBuffer in) {
        int version = in.getUnsignedShort();
        int count = in.getUnsignedShort();
        Deserializer deserializer = new Deserializer();
        Input input = new Input(in);
        for (int i = 0; i < count; ++i) {
            String name = Input.getString(in);
            boolean required = in.get() == 1;
            int len = in.getInt();
            Object value = deserializer.deserialize(input);
            if (name.equals("AppendToGatewayUrl")) {
                this.appendToUrl = (String)value;
                continue;
            }
            if (name.equals("ReplaceGatewayUrl")) {
                this.url = (String)value;
                continue;
            }
            if (name.equals("RequestPersistentHeader")) {
                if (value instanceof Map) {
                    Map valueMap = (Map)value;
                    RemotingHeader header = new RemotingHeader((String)valueMap.get("name"), (Boolean)valueMap.get("mustUnderstand"), valueMap.get("data"));
                    this.headers.put(header.name, header);
                    continue;
                }
                log.error((Object)("Expected Map but received " + value));
                continue;
            }
            log.warn((Object)("Unsupported remoting header \"" + name + "\" received with value " + value));
        }
    }

    private Object decodeResult(ByteBuffer data) {
        this.processHeaders(data);
        int count = data.getUnsignedShort();
        if (count != 1) {
            throw new RuntimeException("Expected exactly one result but got " + count);
        }
        Input input = new Input(data);
        String target = input.getString();
        String nullString = input.getString();
        Deserializer deserializer = new Deserializer();
        return deserializer.deserialize(input);
    }

    public void setCredentials(String userid, String password) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("userid", userid);
        data.put("password", password);
        RemotingHeader header = new RemotingHeader("Credentials", true, data);
        this.headers.put("Credentials", header);
    }

    public void resetCredentials() {
        this.removeHeader("Credentials");
    }

    public void addHeader(String name, boolean required, Object value) {
        RemotingHeader header = new RemotingHeader(name, required, value);
        this.headers.put(name, header);
    }

    public void removeHeader(String name) {
        this.headers.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeMethod(String method, Object[] params) {
        PostMethod post = new PostMethod(this.url + this.appendToUrl);
        ByteBuffer resultBuffer = null;
        ByteBuffer data = this.encodeInvoke(method, params);
        post.setRequestEntity((RequestEntity)new InputStreamRequestEntity(data.asInputStream(), (long)data.limit(), CONTENT_TYPE));
        try {
            int resultCode = this.client.executeMethod((HttpMethod)post);
            if (resultCode / 100 != 2) {
                throw new RuntimeException("Didn't receive success from remoting server.");
            }
            resultBuffer = ByteBuffer.allocate((int)((int)post.getResponseContentLength()));
            ServletUtils.copy(post.getResponseBodyAsStream(), resultBuffer.asOutputStream());
            resultBuffer.flip();
            Object result = this.decodeResult(resultBuffer);
            if (result instanceof RecordSet) {
                ((RecordSet)result).setRemotingClient(this);
            }
            Object object = result;
            return object;
        }
        catch (Exception ex) {
            log.error((Object)"Error while invoking remoting method.", (Throwable)ex);
        }
        finally {
            post.releaseConnection();
            if (resultBuffer != null) {
                resultBuffer.release();
                resultBuffer = null;
            }
            data.release();
            data = null;
        }
        return null;
    }

    public void invokeMethod(String method, Object[] methodParams, IRemotingCallback callback) {
        if (threadPool == null) {
            throw new RuntimeException("No thread pool configured.");
        }
        try {
            WorkerThread wt = (WorkerThread)threadPool.borrowObject();
            Object[] params = new Object[]{this, method, methodParams, callback};
            Class[] paramTypes = new Class[]{RemotingClient.class, String.class, Object[].class, IRemotingCallback.class};
            wt.execute("org.red5.server.net.remoting.RemotingClient$RemotingWorker", "executeTask", params, paramTypes, null);
        }
        catch (Exception err) {
            log.warn((Object)("Exception invoking method: " + method));
        }
    }

    public static class RemotingWorker {
        public void executeTask(RemotingClient client, String method, Object[] params, IRemotingCallback callback) {
            try {
                Object result = client.invokeMethod(method, params);
                callback.resultReceived(client, method, params, result);
            }
            catch (Exception err) {
                callback.errorReceived(client, method, params, err);
            }
        }
    }
}

