/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.messaging;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.red5.server.messaging.IConsumer;
import org.red5.server.messaging.IPipe;
import org.red5.server.messaging.IPipeConnectionListener;
import org.red5.server.messaging.IProvider;
import org.red5.server.messaging.OOBControlMessage;
import org.red5.server.messaging.PipeConnectionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPipe
implements IPipe {
    private static final Log log = LogFactory.getLog(AbstractPipe.class);
    protected volatile List<IConsumer> consumers = new CopyOnWriteArrayList<IConsumer>();
    protected volatile List<IProvider> providers = new CopyOnWriteArrayList<IProvider>();
    protected volatile List<IPipeConnectionListener> listeners = new CopyOnWriteArrayList<IPipeConnectionListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean subscribe(IConsumer consumer, Map paramMap) {
        List<IConsumer> list = this.consumers;
        synchronized (list) {
            if (this.consumers.contains(consumer)) {
                return false;
            }
            this.consumers.add(consumer);
        }
        if (consumer instanceof IPipeConnectionListener) {
            this.listeners.add((IPipeConnectionListener)((Object)consumer));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean subscribe(IProvider provider, Map paramMap) {
        List<IProvider> list = this.providers;
        synchronized (list) {
            if (this.providers.contains(provider)) {
                return false;
            }
            this.providers.add(provider);
        }
        if (provider instanceof IPipeConnectionListener) {
            this.listeners.add((IPipeConnectionListener)((Object)provider));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unsubscribe(IProvider provider) {
        List<IProvider> list = this.providers;
        synchronized (list) {
            if (!this.providers.contains(provider)) {
                return false;
            }
            this.providers.remove(provider);
        }
        this.fireProviderConnectionEvent(provider, 2, null);
        if (provider instanceof IPipeConnectionListener) {
            this.listeners.remove(provider);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unsubscribe(IConsumer consumer) {
        List<IConsumer> list = this.consumers;
        synchronized (list) {
            if (!this.consumers.contains(consumer)) {
                return false;
            }
            this.consumers.remove(consumer);
        }
        this.fireConsumerConnectionEvent(consumer, 5, null);
        if (consumer instanceof IPipeConnectionListener) {
            this.listeners.remove(consumer);
        }
        return true;
    }

    @Override
    public void addPipeConnectionListener(IPipeConnectionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removePipeConnectionListener(IPipeConnectionListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void sendOOBControlMessage(IProvider provider, OOBControlMessage oobCtrlMsg) {
        for (IConsumer consumer : this.consumers) {
            try {
                consumer.onOOBControlMessage(provider, this, oobCtrlMsg);
            }
            catch (Throwable t) {
                log.error((Object)"exception when passing OOBCM from provider to consumers", t);
            }
        }
    }

    @Override
    public void sendOOBControlMessage(IConsumer consumer, OOBControlMessage oobCtrlMsg) {
        for (IProvider provider : this.providers) {
            try {
                provider.onOOBControlMessage(consumer, this, oobCtrlMsg);
            }
            catch (Throwable t) {
                log.error((Object)"exception when passing OOBCM from consumer to providers", t);
            }
        }
    }

    public List<IPipeConnectionListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<IPipeConnectionListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public List<IProvider> getProviders() {
        return this.providers;
    }

    @Override
    public List<IConsumer> getConsumers() {
        return this.consumers;
    }

    protected void fireConsumerConnectionEvent(IConsumer consumer, int type, Map paramMap) {
        PipeConnectionEvent event = new PipeConnectionEvent(this);
        event.setConsumer(consumer);
        event.setType(type);
        event.setParamMap(paramMap);
        this.firePipeConnectionEvent(event);
    }

    protected void fireProviderConnectionEvent(IProvider provider, int type, Map paramMap) {
        PipeConnectionEvent event = new PipeConnectionEvent(this);
        event.setProvider(provider);
        event.setType(type);
        event.setParamMap(paramMap);
        this.firePipeConnectionEvent(event);
    }

    protected void firePipeConnectionEvent(PipeConnectionEvent event) {
        for (IPipeConnectionListener element : this.listeners) {
            try {
                element.onPipeConnectionEvent(event);
            }
            catch (Throwable t) {
                log.error((Object)"exception when handling pipe connection event", t);
            }
        }
        for (Runnable task : event.getTaskList()) {
            try {
                task.run();
            }
            catch (Throwable t) {}
        }
        event.getTaskList().clear();
    }
}

