/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.cache;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationHelper;
import net.sf.ehcache.event.CacheManagerEventListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.red5.server.api.cache.ICacheStore;
import org.red5.server.api.cache.ICacheable;
import org.red5.server.cache.CacheableImpl;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhCacheImpl
implements ICacheStore,
ApplicationContextAware {
    protected static Log log = LogFactory.getLog((String)EhCacheImpl.class.getName());
    private static Ehcache cache;
    private List<CacheConfiguration> configs;
    private String memoryStoreEvictionPolicy = "LRU";
    private int diskExpiryThreadIntervalSeconds = 120;
    private String diskStore = System.getProperty("java.io.tmpdir");
    private CacheManagerEventListener cacheManagerEventListener;
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        applicationContext = context;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public void init() {
        log.info((Object)"Loading ehcache");
        try {
            CacheManager cm = CacheManager.getInstance();
            Configuration configuration = new Configuration();
            String defaultCacheName = "default";
            for (CacheConfiguration conf : this.configs) {
                conf.setDiskExpiryThreadIntervalSeconds(this.diskExpiryThreadIntervalSeconds);
                conf.setMemoryStoreEvictionPolicy(this.memoryStoreEvictionPolicy);
                if (null == cache) {
                    defaultCacheName = conf.getName();
                    configuration.addDefaultCache(conf);
                    continue;
                }
                configuration.addCache(conf);
            }
            ConfigurationHelper helper = new ConfigurationHelper(cm, configuration);
            cache = helper.createDefaultCache();
            cache.initialise();
            cache.bootstrap();
            Set caches = helper.createCaches();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Number of caches: " + caches.size() + " Default cache: " + (cache != null ? 1 : 0)));
            }
            for (Cache cache : caches) {
                cache.initialise();
                cache.bootstrap();
                if (null != cache) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Default cache name: " + defaultCacheName));
                }
                cache = cm.getCache(defaultCacheName);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Error on cache init", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cache is null? " + (null == cache)));
        }
    }

    @Override
    public ICacheable get(String name) {
        ICacheable ic = null;
        try {
            ic = (ICacheable)cache.get((Serializable)((Object)name)).getObjectValue();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return ic;
    }

    @Override
    public void put(String name, Object obj) {
        if (obj instanceof ICacheable) {
            cache.put(new Element((Object)name, obj));
        } else {
            cache.put(new Element((Object)name, (Object)new CacheableImpl(obj)));
        }
    }

    @Override
    public Iterator<String> getObjectNames() {
        return cache.getKeys().iterator();
    }

    @Override
    public Iterator<SoftReference<? extends ICacheable>> getObjects() {
        return null;
    }

    @Override
    public boolean offer(String name, Object obj) {
        boolean result = false;
        try {
            result = cache.isKeyInCache((Object)name);
            if (!result) {
                this.put(name, obj);
            }
            result = cache.isKeyInCache((Object)name);
        }
        catch (NullPointerException npe) {
            log.debug((Object)("Name: " + name + " Object: " + obj.getClass().getName()), (Throwable)npe);
        }
        return result;
    }

    @Override
    public boolean remove(ICacheable obj) {
        return cache.remove((Serializable)((Object)obj.getName()));
    }

    @Override
    public boolean remove(String name) {
        return cache.remove((Serializable)((Object)name));
    }

    public void setCacheConfigs(List<CacheConfiguration> configs) {
        this.configs = configs;
    }

    @Override
    public void setMaxEntries(int capacity) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting max entries for this cache to " + capacity));
        }
    }

    public String getMemoryStoreEvictionPolicy() {
        return this.memoryStoreEvictionPolicy;
    }

    public void setMemoryStoreEvictionPolicy(String memoryStoreEvictionPolicy) {
        this.memoryStoreEvictionPolicy = memoryStoreEvictionPolicy;
    }

    public int getDiskExpiryThreadIntervalSeconds() {
        return this.diskExpiryThreadIntervalSeconds;
    }

    public void setDiskExpiryThreadIntervalSeconds(int diskExpiryThreadIntervalSeconds) {
        this.diskExpiryThreadIntervalSeconds = diskExpiryThreadIntervalSeconds;
    }

    public String getDiskStore() {
        return this.diskStore;
    }

    public void setDiskStore(String diskStore) {
        this.diskStore = System.getProperty("diskStore");
    }

    public CacheManagerEventListener getCacheManagerEventListener() {
        return this.cacheManagerEventListener;
    }

    public void setCacheManagerEventListener(CacheManagerEventListener cacheManagerEventListener) {
        this.cacheManagerEventListener = cacheManagerEventListener;
    }

    public static long getCacheHit() {
        return cache.getHitCount();
    }

    public static long getCacheMiss() {
        return cache.getMissCountExpired() + cache.getMissCountNotFound();
    }

    @Override
    public void destroy() {
        try {
            CacheManager.getInstance().shutdown();
        }
        catch (Exception e) {
            log.warn((Object)"Error on cache shutdown", (Throwable)e);
        }
    }
}

