/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.cache;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.ByteBuffer;
import org.red5.server.api.cache.ICacheable;
import org.springframework.context.ApplicationContext;

public class CacheableImpl
implements ICacheable {
    protected static Log log = LogFactory.getLog((String)CacheableImpl.class.getName());
    protected ApplicationContext applicationContext;
    private byte[] bytes;
    private String name;
    private boolean cached;

    public CacheableImpl(Object obj) {
        ByteBuffer tmp = ByteBuffer.allocate((int)1024, (boolean)true);
        tmp.setAutoExpand(true);
        tmp.putObject(obj);
        this.bytes = new byte[tmp.capacity()];
        tmp.get(this.bytes);
        this.cached = true;
        tmp.release();
        tmp = null;
    }

    public CacheableImpl(ByteBuffer buffer) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Buffer is direct: " + buffer.isDirect() + " capacity: " + buffer.capacity()));
            log.debug((Object)("Buffer limit: " + buffer.limit() + " remaining: " + buffer.remaining() + " position: " + buffer.position()));
        }
        this.bytes = new byte[buffer.capacity()];
        buffer.rewind();
        int i = 0;
        while (i < buffer.limit()) {
            buffer.position(i);
            while (buffer.remaining() > 0) {
                this.bytes[i++] = buffer.get();
            }
        }
        this.cached = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Buffer size: " + buffer.capacity()));
        }
        buffer = null;
    }

    public void addRequest() {
        log.info((Object)("Adding request for: " + this.name));
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public ByteBuffer getByteBuffer() {
        return ByteBuffer.wrap((byte[])this.bytes).asReadOnlyBuffer();
    }

    public String getName() {
        return this.name;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public void setName(String name) {
        this.name = name;
    }
}

