/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.api.service;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.red5.server.api.IClient;
import org.red5.server.api.IConnection;
import org.red5.server.api.IScope;
import org.red5.server.api.Red5;
import org.red5.server.api.service.IPendingServiceCallback;
import org.red5.server.api.service.IServiceCapableConnection;

public class ServiceUtils {
    public static boolean invokeOnConnection(String method, Object[] params) {
        return ServiceUtils.invokeOnConnection(method, params, null);
    }

    public static boolean invokeOnConnection(String method, Object[] params, IPendingServiceCallback callback) {
        IConnection conn = Red5.getConnectionLocal();
        return ServiceUtils.invokeOnConnection(conn, method, params, callback);
    }

    public static boolean invokeOnConnection(IConnection conn, String method, Object[] params) {
        return ServiceUtils.invokeOnConnection(conn, method, params, null);
    }

    public static boolean invokeOnConnection(IConnection conn, String method, Object[] params, IPendingServiceCallback callback) {
        if (conn instanceof IServiceCapableConnection) {
            if (callback == null) {
                ((IServiceCapableConnection)conn).invoke(method, params);
            } else {
                ((IServiceCapableConnection)conn).invoke(method, params, callback);
            }
            return true;
        }
        return false;
    }

    public static void invokeOnAllConnections(String method, Object[] params) {
        ServiceUtils.invokeOnAllConnections(method, params, null);
    }

    public static void invokeOnAllConnections(String method, Object[] params, IPendingServiceCallback callback) {
        IScope scope = Red5.getConnectionLocal().getScope();
        ServiceUtils.invokeOnAllConnections(scope, method, params, callback);
    }

    public static void invokeOnAllConnections(IScope scope, String method, Object[] params) {
        ServiceUtils.invokeOnAllConnections(scope, method, params, null);
    }

    public static void invokeOnAllConnections(IScope scope, String method, Object[] params, IPendingServiceCallback callback) {
        ServiceUtils.invokeOnClient(null, scope, method, params, callback);
    }

    public static void invokeOnClient(IClient client, IScope scope, String method, Object[] params) {
        ServiceUtils.invokeOnClient(client, scope, method, params, null);
    }

    public static void invokeOnClient(IClient client, IScope scope, String method, Object[] params, IPendingServiceCallback callback) {
        Set<Object> connections;
        if (client == null) {
            connections = new HashSet();
            Iterator<IConnection> iter = scope.getConnections();
            while (iter.hasNext()) {
                connections.add(iter.next());
            }
        } else {
            connections = scope.lookupConnections(client);
            if (connections == null) {
                return;
            }
        }
        if (callback == null) {
            for (IConnection iConnection : connections) {
                ServiceUtils.invokeOnConnection(iConnection, method, params);
            }
        } else {
            for (IConnection iConnection : connections) {
                ServiceUtils.invokeOnConnection(iConnection, method, params, callback);
            }
        }
    }

    public static boolean notifyOnConnection(String method, Object[] params) {
        IConnection conn = Red5.getConnectionLocal();
        return ServiceUtils.notifyOnConnection(conn, method, params);
    }

    public static boolean notifyOnConnection(IConnection conn, String method, Object[] params) {
        if (conn instanceof IServiceCapableConnection) {
            ((IServiceCapableConnection)conn).notify(method, params);
            return true;
        }
        return false;
    }

    public static void notifyOnAllConnections(String method, Object[] params) {
        IScope scope = Red5.getConnectionLocal().getScope();
        ServiceUtils.notifyOnAllConnections(scope, method, params);
    }

    public static void notifyOnAllConnections(IScope scope, String method, Object[] params) {
        ServiceUtils.notifyOnClient(null, scope, method, params);
    }

    public static void notifyOnClient(IClient client, IScope scope, String method, Object[] params) {
        Set<Object> connections;
        if (client == null) {
            connections = new HashSet();
            Iterator<IConnection> iter = scope.getConnections();
            while (iter.hasNext()) {
                connections.add(iter.next());
            }
        } else {
            connections = scope.lookupConnections(client);
        }
        for (IConnection iConnection : connections) {
            ServiceUtils.notifyOnConnection(iConnection, method, params);
        }
    }
}

