/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.api;

import java.lang.ref.WeakReference;
import org.red5.server.api.IClient;
import org.red5.server.api.IConnection;
import org.red5.server.api.IContext;
import org.red5.server.api.IScope;
import org.red5.server.api.Red5MBean;

public final class Red5
implements Red5MBean {
    private static ThreadLocal<WeakReference<IConnection>> connThreadLocal = new ThreadLocal();
    public IConnection conn;

    public Red5(IConnection conn) {
        this.conn = conn;
    }

    public Red5() {
        this.conn = Red5.getConnectionLocal();
    }

    public static void setConnectionLocal(IConnection connection) {
        connThreadLocal.set(new WeakReference<IConnection>(connection));
    }

    public static IConnection getConnectionLocal() {
        WeakReference<IConnection> ref = connThreadLocal.get();
        if (ref != null) {
            return (IConnection)ref.get();
        }
        return null;
    }

    public IConnection getConnection() {
        return this.conn;
    }

    public IScope getScope() {
        return this.conn.getScope();
    }

    public IClient getClient() {
        return this.conn.getClient();
    }

    public IContext getContext() {
        return this.conn.getScope().getContext();
    }
}

