/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.util.Iterator;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.red5.server.LoaderBase;
import org.red5.server.Scope;
import org.red5.server.api.IApplicationContext;
import org.red5.server.api.IApplicationLoader;
import org.red5.server.api.IConnection;
import org.red5.server.api.IGlobalScope;
import org.red5.server.api.IServer;
import org.springframework.web.context.ServletContextAware;

public class WebScope
extends Scope
implements ServletContextAware {
    protected static Log log = LogFactory.getLog((String)WebScope.class.getName());
    protected IServer server;
    protected ServletContext servletContext;
    protected String contextPath;
    protected String virtualHosts;
    protected String[] hostnames;
    protected boolean registered;
    protected IApplicationContext appContext;
    protected IApplicationLoader appLoader;
    protected boolean shuttingDown;

    public void setGlobalScope(IGlobalScope globalScope) {
        super.setParent(globalScope);
        try {
            this.setPersistenceClass(globalScope.getStore().getClass().getName());
        }
        catch (Exception error) {
            log.error((Object)"Could not set persistence class.", (Throwable)error);
        }
    }

    public void setName() {
        throw new RuntimeException("Cannot set name, you must set context path");
    }

    public void setParent() {
        throw new RuntimeException("Cannot set parent, you must set global scope");
    }

    public void setServer(IServer server) {
        log.info((Object)server);
        this.server = server;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
        super.setName(contextPath.substring(1));
    }

    public void setVirtualHosts(String virtualHosts) {
        this.virtualHosts = virtualHosts;
        this.hostnames = virtualHosts.split(",");
        for (int i = 0; i < this.hostnames.length; ++i) {
            this.hostnames[i] = this.hostnames[i].trim();
            if (!this.hostnames[i].equals("*")) continue;
            this.hostnames[i] = "";
        }
    }

    public synchronized void register() {
        if (this.registered) {
            return;
        }
        this.appContext = LoaderBase.getRed5ApplicationContext(this.contextPath);
        this.appLoader = LoaderBase.getApplicationLoader();
        LoaderBase.setRed5ApplicationContext(this.contextPath, null);
        if (this.hostnames != null && this.hostnames.length > 0) {
            for (String element : this.hostnames) {
                this.server.addMapping(element, this.getName(), this.getParent().getName());
            }
        }
        this.init();
        this.keepOnDisconnect = true;
        this.registered = true;
    }

    public synchronized void unregister() {
        if (!this.registered) {
            return;
        }
        this.shuttingDown = true;
        this.keepOnDisconnect = false;
        this.uninit();
        Iterator<IConnection> iter = this.getConnections();
        while (iter.hasNext()) {
            IConnection conn = iter.next();
            conn.close();
        }
        if (this.hostnames != null && this.hostnames.length > 0) {
            for (String element : this.hostnames) {
                this.server.removeMapping(element, this.getName());
            }
        }
        if (this.appContext != null) {
            this.appContext.stop();
        }
        this.setStore(null);
        super.setParent(null);
        this.setServletContext(null);
        this.setServer(null);
        this.setName(null);
        this.appContext = null;
        this.registered = false;
        this.shuttingDown = false;
    }

    public IServer getServer() {
        return this.server;
    }

    public IApplicationLoader getApplicationLoader() {
        return this.appLoader;
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }
}

