/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.red5.io.object.Deserializer;
import org.red5.io.object.Input;
import org.red5.io.object.Output;
import org.red5.io.object.Serializer;
import org.red5.server.AttributeStore;
import org.red5.server.api.IAttributeStore;
import org.red5.server.api.persistence.IPersistable;
import org.red5.server.api.persistence.IPersistenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistableAttributeStore
extends AttributeStore
implements IPersistable {
    protected boolean persistent = true;
    protected String name;
    protected String type;
    protected String path;
    protected long lastModified = -1L;
    protected IPersistenceStore store;

    public PersistableAttributeStore(String type, String name, String path, boolean persistent) {
        this.type = type;
        this.name = name;
        this.path = path;
        this.persistent = persistent;
    }

    protected void modified() {
        this.lastModified = System.currentTimeMillis();
        if (this.store != null) {
            this.store.save(this);
        }
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    @Override
    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void serialize(Output output) throws IOException {
        Serializer serializer = new Serializer();
        HashMap persistentAttributes = new HashMap();
        for (String name : this.attributes.keySet()) {
            if (name.startsWith("_transient")) continue;
            persistentAttributes.put(name, this.attributes.get(name));
        }
        serializer.serialize(output, persistentAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deserialize(Input input) throws IOException {
        Deserializer deserializer = new Deserializer();
        Object obj = deserializer.deserialize(input);
        if (!(obj instanceof Map)) {
            throw new IOException("required Map object");
        }
        Map values = (Map)obj;
        values.remove(null);
        Map map = this.attributes;
        synchronized (map) {
            for (Map.Entry entry : values.entrySet()) {
                Object value = entry.getValue();
                if (value == null) continue;
                this.attributes.put(entry.getKey(), value);
                this.hashes.put(entry.getKey(), value.hashCode());
            }
        }
    }

    @Override
    public void setStore(IPersistenceStore store) {
        if (this.store != null) {
            this.store.notifyClose();
        }
        this.store = store;
        if (store != null) {
            store.load(this);
        }
    }

    @Override
    public IPersistenceStore getStore() {
        return this.store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setAttribute(String name, Object value) {
        Map map = this.attributes;
        synchronized (map) {
            boolean result = super.setAttribute(name, value);
            if (result && !name.startsWith("_transient")) {
                this.modified();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttributes(Map<String, Object> values) {
        Map map = this.attributes;
        synchronized (map) {
            super.setAttributes(values);
            this.modified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttributes(IAttributeStore values) {
        Map map = this.attributes;
        synchronized (map) {
            super.setAttributes(values);
            this.modified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAttribute(String name) {
        Map map = this.attributes;
        synchronized (map) {
            boolean result = super.removeAttribute(name);
            if (result && !name.startsWith("_transient")) {
                this.modified();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttributes() {
        Map map = this.attributes;
        synchronized (map) {
            super.removeAttributes();
            this.modified();
        }
    }
}

