/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.red5.server.AttributeStore;
import org.red5.server.Client;
import org.red5.server.Scope;
import org.red5.server.api.IBasicScope;
import org.red5.server.api.IClient;
import org.red5.server.api.IConnection;
import org.red5.server.api.IScope;
import org.red5.server.api.event.IEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseConnection
extends AttributeStore
implements IConnection {
    protected static Log log = LogFactory.getLog((String)BaseConnection.class.getName());
    protected String type;
    protected String host;
    protected String remoteAddress;
    protected List<String> remoteAddresses;
    protected int remotePort;
    protected String path;
    protected String sessionId;
    protected long readMessages;
    protected long writtenMessages;
    protected long droppedMessages;
    protected Map<String, Object> params = null;
    protected IClient client;
    protected Scope scope;
    protected Set<IBasicScope> basicScopes;

    public BaseConnection(String type, String host, String remoteAddress, int remotePort, String path, String sessionId, Map<String, Object> params) {
        this.type = type;
        this.host = host;
        this.remoteAddress = remoteAddress;
        this.remoteAddresses = new ArrayList<String>();
        this.remoteAddresses.add(remoteAddress);
        this.remoteAddresses = Collections.unmodifiableList(this.remoteAddresses);
        this.remotePort = remotePort;
        this.path = path;
        this.sessionId = sessionId;
        this.params = params;
        this.basicScopes = new HashSet<IBasicScope>();
    }

    @Override
    public void initialize(IClient client) {
        if (this.client != null && this.client instanceof Client) {
            ((Client)this.client).unregister(this);
        }
        this.client = client;
        if (this.client instanceof Client) {
            ((Client)this.client).register(this);
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public List<String> getRemoteAddresses() {
        return this.remoteAddresses;
    }

    @Override
    public int getRemotePort() {
        return this.remotePort;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public Map<String, Object> getConnectParams() {
        return Collections.unmodifiableMap(this.params);
    }

    @Override
    public IClient getClient() {
        return this.client;
    }

    @Override
    public boolean isConnected() {
        return this.scope != null;
    }

    @Override
    public boolean connect(IScope newScope) {
        return this.connect(newScope, null);
    }

    @Override
    public boolean connect(IScope newScope, Object[] params) {
        Scope oldScope = this.scope;
        this.scope = (Scope)newScope;
        if (this.scope.connect(this, params)) {
            if (oldScope != null) {
                oldScope.disconnect(this);
            }
            return true;
        }
        this.scope = oldScope;
        return false;
    }

    @Override
    public IScope getScope() {
        return this.scope;
    }

    @Override
    public synchronized void close() {
        if (this.scope != null) {
            log.debug((Object)"Close, disconnect from scope, and children");
            try {
                HashSet<IBasicScope> tmpScopes = new HashSet<IBasicScope>(this.basicScopes);
                for (IBasicScope basicScope : tmpScopes) {
                    this.unregisterBasicScope(basicScope);
                }
            }
            catch (Exception err) {
                log.error((Object)"Error while unregistering basic scopes.", (Throwable)err);
            }
            try {
                this.scope.disconnect(this);
            }
            catch (Exception err) {
                log.error((Object)("Error while disconnecting from scope " + this.scope), (Throwable)err);
            }
            if (this.client != null && this.client instanceof Client) {
                ((Client)this.client).unregister(this);
                this.client = null;
            }
            this.scope = null;
        } else {
            log.debug((Object)"Close, not connected nothing to do.");
        }
    }

    @Override
    public void notifyEvent(IEvent event) {
    }

    @Override
    public void dispatchEvent(IEvent event) {
    }

    @Override
    public boolean handleEvent(IEvent event) {
        return this.getScope().handleEvent(event);
    }

    @Override
    public Iterator<IBasicScope> getBasicScopes() {
        return this.basicScopes.iterator();
    }

    public void registerBasicScope(IBasicScope basicScope) {
        this.basicScopes.add(basicScope);
        basicScope.addEventListener(this);
    }

    public void unregisterBasicScope(IBasicScope basicScope) {
        this.basicScopes.remove(basicScope);
        basicScope.removeEventListener(this);
    }

    @Override
    public abstract long getReadBytes();

    @Override
    public abstract long getWrittenBytes();

    @Override
    public long getReadMessages() {
        return this.readMessages;
    }

    @Override
    public long getWrittenMessages() {
        return this.writtenMessages;
    }

    @Override
    public long getDroppedMessages() {
        return this.droppedMessages;
    }

    @Override
    public long getPendingMessages() {
        return 0L;
    }

    public long getPendingVideoMessages(int streamId) {
        return 0L;
    }
}

