/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.red5.server.api.IAttributeStore;
import org.red5.server.api.ICastingAttributeStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeStore
implements ICastingAttributeStore {
    protected Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    protected Map<String, Integer> hashes = new HashMap<String, Integer>();

    @Override
    public Set<String> getAttributeNames() {
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    @Override
    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public Object getAttribute(String name) {
        if (name == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttribute(String name, Object defaultValue) {
        if (name == null) {
            return null;
        }
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            if (!this.hasAttribute(name)) {
                this.setAttribute(name, defaultValue);
            }
        }
        return this.getAttribute(name);
    }

    @Override
    public boolean hasAttribute(String name) {
        if (name == null) {
            return false;
        }
        return this.attributes.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setAttribute(String name, Object value) {
        if (name == null) {
            return false;
        }
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            Object old = this.attributes.get(name);
            Integer newHash = value != null ? value.hashCode() : 0;
            if (old == null && value != null || old != null && !old.equals(value) || !newHash.equals(this.hashes.get(name))) {
                if (value == null) {
                    this.attributes.remove(name);
                    this.hashes.remove(name);
                } else {
                    this.attributes.put(name, value);
                    this.hashes.put(name, newHash);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttributes(Map<String, Object> values) {
        values.remove(null);
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            this.attributes.clear();
            this.hashes.clear();
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                Object value = entry.getValue();
                if (value == null) continue;
                this.attributes.put(entry.getKey(), value);
                this.hashes.put(entry.getKey(), value.hashCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttributes(IAttributeStore values) {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            for (String name : values.getAttributeNames()) {
                Object value = values.getAttribute(name);
                this.setAttribute(name, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAttribute(String name) {
        if (name == null) {
            return false;
        }
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            boolean result = this.hasAttribute(name);
            this.attributes.remove(name);
            this.hashes.remove(name);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttributes() {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            this.attributes.clear();
            this.hashes.clear();
        }
    }

    @Override
    public Boolean getBoolAttribute(String name) {
        return (Boolean)this.getAttribute(name);
    }

    @Override
    public Byte getByteAttribute(String name) {
        return (Byte)this.getAttribute(name);
    }

    @Override
    public Double getDoubleAttribute(String name) {
        return (Double)this.getAttribute(name);
    }

    @Override
    public Integer getIntAttribute(String name) {
        return (Integer)this.getAttribute(name);
    }

    @Override
    public List getListAttribute(String name) {
        return (List)this.getAttribute(name);
    }

    @Override
    public Long getLongAttribute(String name) {
        return (Long)this.getAttribute(name);
    }

    @Override
    public Map getMapAttribute(String name) {
        return (Map)this.getAttribute(name);
    }

    @Override
    public Set getSetAttribute(String name) {
        return (Set)this.getAttribute(name);
    }

    @Override
    public Short getShortAttribute(String name) {
        return (Short)this.getAttribute(name);
    }

    @Override
    public String getStringAttribute(String name) {
        return (String)this.getAttribute(name);
    }
}

