/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.utils;

import org.apache.mina.common.ByteBuffer;

public class BufferUtils {
    public static void writeMediumInt(ByteBuffer out, int value) {
        byte[] bytes = new byte[]{(byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        out.put(bytes);
    }

    public static int readUnsignedMediumInt(ByteBuffer in) {
        byte[] bytes = new byte[3];
        in.get(bytes);
        int val = 0;
        val += (bytes[0] & 0xFF) * 256 * 256;
        val += (bytes[1] & 0xFF) * 256;
        return val += bytes[2] & 0xFF;
    }

    public static int readMediumInt(ByteBuffer in) {
        byte[] bytes = new byte[3];
        in.get(bytes);
        int val = 0;
        val += bytes[0] * 256 * 256;
        val += bytes[1] * 256;
        if ((val += bytes[2]) < 0) {
            val += 256;
        }
        return val;
    }

    public static int put(ByteBuffer out, ByteBuffer in, int numBytesMax) {
        int limit = in.limit();
        int numBytesRead = numBytesMax > in.remaining() ? in.remaining() : numBytesMax;
        in.limit(in.position() + numBytesRead);
        out.put(in);
        in.limit(limit);
        return numBytesRead;
    }
}

