/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.flv.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.ByteBuffer;
import org.red5.io.ITag;
import org.red5.io.ITagReader;
import org.red5.io.ITagWriter;
import org.red5.io.flv.IFLV;
import org.red5.io.flv.impl.FLVReader;
import org.red5.io.flv.impl.FLVWriter;
import org.red5.io.flv.meta.IMetaData;
import org.red5.io.flv.meta.IMetaService;
import org.red5.io.flv.meta.MetaService;
import org.red5.server.api.cache.ICacheStore;
import org.red5.server.api.cache.ICacheable;

public class FLV
implements IFLV {
    protected static Log log = LogFactory.getLog((String)FLV.class.getName());
    private static ICacheStore cache;
    private File file;
    private boolean generateMetadata;
    private IMetaService metaService;
    private IMetaData metaData;

    public FLV() {
    }

    public FLV(File file) {
        this(file, false);
    }

    public FLV(File file, boolean generateMetadata) {
        this.file = file;
        this.generateMetadata = generateMetadata;
        int count = 0;
        if (!generateMetadata) {
            try {
                FLVReader reader = new FLVReader(this.file);
                ITag tag = null;
                while (reader.hasMoreTags() && ++count < 5) {
                    tag = reader.readTag();
                    if (tag.getDataType() != 18) continue;
                    if (this.metaService == null) {
                        this.metaService = new MetaService(this.file);
                    }
                    this.metaData = this.metaService.readMetaData(tag.getBody());
                }
                reader.close();
            }
            catch (Exception e) {
                log.error((Object)"An error occured looking for metadata:", (Throwable)e);
            }
        }
    }

    public void setCache(ICacheStore cache) {
        FLV.cache = cache;
    }

    public boolean hasMetaData() {
        return this.metaData != null;
    }

    public IMetaData getMetaData() throws FileNotFoundException {
        this.metaService.setInStream(new FileInputStream(this.file));
        return null;
    }

    public boolean hasKeyFrameData() {
        return false;
    }

    public void setKeyFrameData(Map keyframedata) {
    }

    public Map getKeyFrameData() {
        return null;
    }

    public void refreshHeaders() throws IOException {
    }

    public void flushHeaders() throws IOException {
    }

    public ITagReader getReader() throws IOException {
        FLVReader reader = null;
        String fileName = this.file.getName();
        ICacheable ic = cache.get(fileName);
        if (null == ic || null == ic.getByteBuffer()) {
            if (this.file.exists()) {
                ByteBuffer fileData;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("File size: " + this.file.length()));
                }
                if ((fileData = (reader = new FLVReader(this.file, this.generateMetadata)).getFileData()) != null && cache.offer(fileName, fileData)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Item accepted by the cache: " + fileName));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Item will not be cached: " + fileName));
                }
            } else {
                log.info((Object)("Creating new file: " + this.file));
                this.file.createNewFile();
            }
        } else {
            ByteBuffer fileData = ByteBuffer.wrap((byte[])ic.getBytes());
            reader = new FLVReader(fileData, this.generateMetadata);
        }
        return reader;
    }

    public ITagReader readerFromNearestKeyFrame(int seekPoint) {
        return null;
    }

    public ITagWriter getWriter() throws IOException {
        if (this.file.exists()) {
            this.file.delete();
        }
        this.file.createNewFile();
        FLVWriter writer = new FLVWriter(new FileOutputStream(this.file));
        writer.writeHeader();
        return writer;
    }

    public ITagWriter getAppendWriter() throws IOException {
        if (!this.file.exists()) {
            log.info((Object)"File does not exist, calling writer. This will create a new file.");
            return this.getWriter();
        }
        FLVWriter writer = new FLVWriter(new FileOutputStream(this.file, true));
        return writer;
    }

    public ITagWriter writerFromNearestKeyFrame(int seekPoint) {
        return null;
    }

    public void setMetaData(IMetaData meta) throws IOException {
        File tmpFile = File.createTempFile("setMeta_", ".flv");
        if (this.metaService == null) {
            this.metaService = new MetaService(this.file);
        }
        this.metaService.setInStream(new FileInputStream(this.file));
        this.metaService.setOutStream(new FileOutputStream(tmpFile));
        this.metaService.write(meta);
        this.metaData = meta;
        this.file.delete();
        if (!tmpFile.renameTo(this.file)) {
            FileInputStream fis = new FileInputStream(tmpFile);
            FileOutputStream fos = new FileOutputStream(this.file);
            byte[] buf = new byte[16384];
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
            fis.close();
            fos.close();
            tmpFile.delete();
        }
    }

    public void setMetaService(IMetaService service) {
        this.metaService = service;
    }
}

