/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.amf3;

import java.nio.ByteOrder;
import java.nio.charset.Charset;
import org.apache.mina.common.ByteBuffer;
import org.red5.io.amf3.AMF3;
import org.red5.io.amf3.IDataOutput;
import org.red5.io.amf3.Output;
import org.red5.io.object.Serializer;

public class DataOutput
implements IDataOutput {
    private Output output;
    private Serializer serializer;
    private ByteBuffer buffer;

    protected DataOutput(Output output, Serializer serializer) {
        this.output = output;
        this.serializer = serializer;
        this.buffer = output.getBuffer();
    }

    public ByteOrder getEndian() {
        return this.buffer.order();
    }

    public void setEndian(ByteOrder endian) {
        this.buffer.order(endian);
    }

    public void writeBoolean(boolean value) {
        this.buffer.put((byte)(value ? 1 : 0));
    }

    public void writeByte(byte value) {
        this.buffer.put(value);
    }

    public void writeBytes(byte[] bytes) {
        this.buffer.put(bytes);
    }

    public void writeBytes(byte[] bytes, int offset) {
        this.buffer.put(bytes, offset, bytes.length - offset);
    }

    public void writeBytes(byte[] bytes, int offset, int length) {
        this.buffer.put(bytes, offset, length);
    }

    public void writeDouble(double value) {
        this.buffer.putDouble(value);
    }

    public void writeFloat(float value) {
        this.buffer.putFloat(value);
    }

    public void writeInt(int value) {
        this.buffer.putInt(value);
    }

    public void writeMultiByte(String value, String encoding) {
        Charset cs = Charset.forName(encoding);
        java.nio.ByteBuffer strBuf = cs.encode(value);
        this.buffer.put(strBuf);
    }

    public void writeObject(Object value) {
        this.serializer.serialize(this.output, value);
    }

    public void writeShort(short value) {
        this.buffer.putShort(value);
    }

    public void writeUnsignedInt(long value) {
        this.buffer.putInt((int)value);
    }

    public void writeUTF(String value) {
        this.buffer.putShort((short)value.length());
        java.nio.ByteBuffer strBuf = AMF3.CHARSET.encode(value);
        this.buffer.put(strBuf);
    }

    public void writeUTFBytes(String value) {
        java.nio.ByteBuffer strBuf = AMF3.CHARSET.encode(value);
        this.buffer.put(strBuf);
    }
}

