/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.amf3;

import java.nio.ByteOrder;
import java.nio.charset.Charset;
import org.apache.mina.common.ByteBuffer;
import org.red5.io.amf3.AMF3;
import org.red5.io.amf3.IDataInput;
import org.red5.io.amf3.Input;
import org.red5.io.object.Deserializer;

public class DataInput
implements IDataInput {
    private Input input;
    private Deserializer deserializer;
    private ByteBuffer buffer;

    protected DataInput(Input input, Deserializer deserializer) {
        this.input = input;
        this.deserializer = deserializer;
        this.buffer = input.getBuffer();
    }

    public ByteOrder getEndian() {
        return this.buffer.order();
    }

    public void setEndian(ByteOrder endian) {
        this.buffer.order(endian);
    }

    public boolean readBoolean() {
        return this.buffer.get() != 0;
    }

    public byte readByte() {
        return this.buffer.get();
    }

    public void readBytes(byte[] bytes) {
        this.buffer.get(bytes);
    }

    public void readBytes(byte[] bytes, int offset) {
        this.buffer.get(bytes, offset, bytes.length - offset);
    }

    public void readBytes(byte[] bytes, int offset, int length) {
        this.buffer.get(bytes, offset, length);
    }

    public double readDouble() {
        return this.buffer.getDouble();
    }

    public float readFloat() {
        return this.buffer.getFloat();
    }

    public int readInt() {
        return this.buffer.getInt();
    }

    public String readMultiByte(int length, String charSet) {
        Charset cs = Charset.forName(charSet);
        int limit = this.buffer.limit();
        java.nio.ByteBuffer strBuf = this.buffer.buf();
        strBuf.limit(strBuf.position() + length);
        String string = cs.decode(strBuf).toString();
        this.buffer.limit(limit);
        return string;
    }

    public Object readObject() {
        return this.deserializer.deserialize(this.input);
    }

    public short readShort() {
        return this.buffer.getShort();
    }

    public int readUnsignedByte() {
        return this.buffer.getUnsigned();
    }

    public long readUnsignedInt() {
        return this.buffer.getUnsignedInt();
    }

    public int readUnsignedShort() {
        return this.buffer.getUnsignedShort();
    }

    public String readUTF() {
        int length = this.buffer.getUnsignedShort();
        return this.readUTFBytes(length);
    }

    public String readUTFBytes(int length) {
        int limit = this.buffer.limit();
        java.nio.ByteBuffer strBuf = this.buffer.buf();
        strBuf.limit(strBuf.position() + length);
        String string = AMF3.CHARSET.decode(strBuf).toString();
        this.buffer.limit(limit);
        return string;
    }
}

