package org.lightdi.container.impl;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

import org.lightdi.container.DIContainer;
import org.lightdi.container.meta.MetaComponent;
import org.lightdi.container.security.ContainerLockKey;
import org.lightdi.util.ArrayUtil;
import org.lightdi.util.ReflectionUtil;

public class DIContainerImpl implements DIContainer
{
	private String name;
	private Map<String, MetaComponent> metaComponents = new ConcurrentHashMap<String, MetaComponent>();
	private Map<String, Object> singletonComponents = new ConcurrentHashMap<String, Object>();
	private ContainerLockKey key;

	public Map<String, MetaComponent> getMetaComponents()
	{
		return metaComponents;
	}

	public void setMetaComponents(Map<String, MetaComponent> metaComponents)
	{
		this.metaComponents = metaComponents;
	}

	public Map<String, Object> getSingletonComponents()
	{
		return singletonComponents;
	}

	public void setSingletonComponents(Map<String, Object> singletonComponents)
	{
		this.singletonComponents = singletonComponents;
	}

	public ContainerLockKey getKey()
	{
		return key;
	}

	public void setKey(ContainerLockKey key)
	{
		this.key = key;
	}

	public Object getComponent(String componentName)
	{
		// singleton
		if (singletonComponents.get(componentName) != null)
			return singletonComponents.get(componentName);
		// prototype
		Object returnObj = null;
		MetaComponent meta = null;
		Set<String> metaNameSet = metaComponents.keySet();
		for (String name : metaNameSet)
		{
			MetaComponent each = metaComponents.get(name);
			if (each.getName().equals(componentName))
			{
				meta = each;
				break;
			}
		}
		Object[] initArgs = null;
		List<Object> args = meta.getConstructorArgValues();
		List<Class<?>> types = meta.getConstructorArgTypes();
		if (args != null)
		{
			initArgs = new Object[args.size()];
			int len = initArgs.length;
			for (int i = 0; i < len; i++)
			{
				Class<?> clazz = types.get(i);
				initArgs[i] = ReflectionUtil.instantiate(clazz, args.get(i));
			}
		}
		try
		{
			returnObj = meta.getConstructor().newInstance((Object[]) initArgs);
			// TODO setter injection
			List<Class<?>> setterTypes = meta.getSetterArgTypes();
			List<Object> setterValues = meta.getSetterArgValues();
			List<String> setterNames = meta.getSetterNames();
			String className = meta.getClassName();
			Class<?> clazz = Class.forName(className);
			int len = setterTypes.size();
			for (int i = 0; i < len; i++)
			{
				String setterName = ReflectionUtil
				        .getSetterMethodName(setterNames.get(i));
				Class<?>[] argTypes = ArrayUtil.toArray(setterTypes);
				Method setter = clazz.getMethod(setterName, argTypes);
				setter.invoke(returnObj, ArrayUtil.toArray(setterValues));
			}

		} catch (Exception e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return returnObj;
	}

	public Map<String, Object> getComponents()
	{
		Map<String, Object> retMap = new HashMap<String, Object>();
		Set<String> metaNameSet = metaComponents.keySet();
		for (String name : metaNameSet)
		{
			MetaComponent meta = metaComponents.get(name);
			Object value = getComponent(meta.getName());
			retMap.put(meta.getName(), value);
		}
		return retMap;
	}

	public String getName()
	{
		return name;
	}

	public void setName(String name)
	{
		this.name = name;
	}

	public void lock(ContainerLockKey key)
	{
		this.key = key;
	}

	public void unlock(ContainerLockKey key)
	{
		if (this.key.equals(key))
			this.key = null;
		else
			throw new SecurityException("Cannot unlock the container : " + name);
	}

	public boolean isLocked()
	{
		return this.key != null ? true : false;
	}

}
