package org.lightdi.container.factory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.lightdi.container.DIContainer;
import org.lightdi.container.config.ConfigXML;

class DIContainerManager
{

	private Map<String, ConfigXML> registeredConfigXMLList = new ConcurrentHashMap<String, ConfigXML>();
	private Map<String, DIContainer> containerNameMapping = new ConcurrentHashMap<String, DIContainer>();

	public Map<String, ConfigXML> getRegisterdConfigXMLList()
	{
		return registeredConfigXMLList;
	}

	public void setRegisterdConfigXMLList(Map<String, ConfigXML> registeredConfigXMLList)
	{
		this.registeredConfigXMLList = registeredConfigXMLList;
	}

	public Map<String, DIContainer> getContainers()
	{
		return containerNameMapping;
	}

	public void setContainers(Map<String, DIContainer> containers)
	{
		this.containerNameMapping = containers;
	}

	public boolean isRegistered(String configXML)
	{
		if (registeredConfigXMLList.get(configXML) != null)
			return true;
		else
			return false;
	}

	public DIContainer getContainerByName(String containerName)
	{
		return containerNameMapping.get(containerName);
	}

}
