package org.lightdi.container.factory;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

import org.lightdi.container.DIContainer;
import org.lightdi.container.config.ComponentConfig;
import org.lightdi.container.config.ConfigXML;
import org.lightdi.container.config.ContainerConfig;
import org.lightdi.container.config.ComponentConfig.ConstructorArg;
import org.lightdi.container.config.ComponentConfig.SetterArg;
import org.lightdi.container.config.parser.ConfigLoadUtil;
import org.lightdi.container.impl.DIContainerImpl;
import org.lightdi.container.meta.MetaComponent;
import org.lightdi.util.ArrayUtil;
import org.lightdi.util.ReflectionUtil;
import org.lightdi.util.ResourceUtil;

public class DIContainerFactory
{
	private static final DIContainerManager containerManager = new DIContainerManager();

	private static final String LIGHT_DI_CONFIG_PATH = "lightdi-config.xml";
	static
	{
		// create di containers
		InputStream is = ResourceUtil.getResourceStream(LIGHT_DI_CONFIG_PATH);
		try
		{
			// load start
			if (is != null)
			{
				System.out.println("light di load start.");
				addConfigXML(LIGHT_DI_CONFIG_PATH);
				reloadContainers();
				Map<String, DIContainer> containers = getAllContainers();
				Set<String> nameSet = containers.keySet();
				for (String name : nameSet)
				{
					// TODO
					System.out.println("loaded container : " + name);
				}
				System.out.println("light di load end.");
			}
		} finally
		{
			if (is != null)
			{
				try
				{
					is.close();

				} catch (Exception ignore)
				{
				}
			}
		}
		// auto injection
		// TODO
		ClassLoader classLoader = DIContainerFactory.class.getClassLoader();
	}

	private DIContainerFactory()
	{
	}

	public static DIContainer getContainer(String containerName)
	{
		return containerManager.getContainers().get(containerName);
	}

	public static Map<String, DIContainer> getAllContainers()
	{
		return containerManager.getContainers();
	}

	public static void addConfigXML(String path)
	{
		containerManager.getRegisterdConfigXMLList().put(path, new ConfigXML());
	}

	public static void removeCofingXML(String path)
	{
		containerManager.getRegisterdConfigXMLList().get(path);
		containerManager.getRegisterdConfigXMLList().remove(path);
	}

	public static void clearAllContainers()
	{
		containerManager
		        .setRegisterdConfigXMLList(new ConcurrentHashMap<String, ConfigXML>());
		containerManager.setContainers(new ConcurrentHashMap<String, DIContainer>());
	}

	public static void reloadContainers()
	{
		parseConfigXML();

	}

	private static void parseConfigXML()
	{
		Map<String, ConfigXML> configXMLMapping = containerManager
		        .getRegisterdConfigXMLList();
		Map<String, ContainerConfig> containerMapping = new ConcurrentHashMap<String, ContainerConfig>();
		Set<String> configXMLSet = configXMLMapping.keySet();
		Map<String, ContainerConfig> configMap = null;
		for (String configXML : configXMLSet)
		{
			configMap = ConfigLoadUtil.readConfigXML(configXML);
			Set<String> containerNameSet = configMap.keySet();
			for (String containerName : containerNameSet)
			{
				containerMapping.put(containerName, configMap.get(containerName));
			}
			ConfigXML element = new ConfigXML();
			element.setContainers(configMap);
			configXMLMapping.put(configXML, element);

		}
		try
		{
			Map<String, DIContainer> containers = createContainerConfigMapping(containerMapping);
			containerManager.setContainers(containers);
		} catch (Exception e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	private static Map<String, DIContainer> createContainerConfigMapping(
	        Map<String, ContainerConfig> containerMapping) throws Exception
	{
		Map<String, DIContainer> ret = new ConcurrentHashMap<String, DIContainer>();
		Set<String> nameSet = containerMapping.keySet();
		for (String name : nameSet)
		{
			ContainerConfig config = containerMapping.get(name);
			DIContainer container = createContainer(config);
			ret.put(container.getName(), container);
		}
		return ret;
	}

	private static DIContainer createContainer(ContainerConfig config) throws Exception
	{
		Map<String, ComponentConfig> componentConfigs = config.getComponents();

		Map<String, MetaComponent> metaComponents = new ConcurrentHashMap<String, MetaComponent>();
		Map<String, Object> singletonComponents = new ConcurrentHashMap<String, Object>();

		Set<String> configNameSet = componentConfigs.keySet();
		for (String configName : configNameSet)
		{
			MetaComponent meta = new MetaComponent();
			ComponentConfig componentConfig = componentConfigs.get(configName);
			String name = componentConfig.getName();
			meta.setName(name);
			String className = componentConfig.getClassName();
			meta.setClassName(className);

			List<ConstructorArg> constructorArgList = componentConfig
			        .getConstructorArgs();
			for (ConstructorArg arg : constructorArgList)
			{
				if (arg == null)
					break;

				String conClassName = null;
				Object conValue = null;

				if (arg.getRef() != null)
				{
					// TODO
					String refName = arg.getRef().getName();
					// ComponentConfig compConfig =
					// config.getComponent(refName);
					// conClassName = compConfig.getClassName();
					// if
					// (MetaComponent.InstanceType.SINGLETON.equals(compConfig
					// .getInstanceType()))
					// {
					//
					// }
				} else
				{
					conClassName = arg.getClassName();
					conValue = arg.getValue();
					Class<?> conClass = Class.forName(conClassName);
					meta.getConstructorArgTypes().add(conClass);
					meta.getConstructorArgValues().add(conValue);
				}
			}
			Class<?> clazz = Class.forName(className);
			Constructor<?> constructor = clazz.getConstructor(ArrayUtil.toArray(meta
			        .getConstructorArgTypes()));
			meta.setConstructor(constructor);

			String instanceType = componentConfig.getInstanceType();
			meta.setInstanceType(instanceType);

			List<SetterArg> setterArgList = componentConfig.getSetterArgs();
			for (SetterArg arg : setterArgList)
			{
				if (arg == null)
					continue;
				String setName = arg.getName();
				meta.getSetterNames().add(setName);
				String setClassName = arg.getClassName();
				Class<?> conClass = Class.forName(setClassName);
				meta.getSetterArgTypes().add(conClass);
				Object setValue = arg.getValue();
				meta.getSetterArgValues().add(setValue);
				// TODO ref
			}
			// TODO singleton
			if (MetaComponent.InstanceType.SINGLETON.equals(instanceType))
			{
				List<Object> values = meta.getConstructorArgValues();
				int argLen = values.size();
				List<Class<?>> types = meta.getConstructorArgTypes();
				for (int i = 0; i < argLen; i++)
				{
					Object value = values.get(i);
					Class<?> type = types.get(i);
					values.set(i, ReflectionUtil.instantiate(type, value));
				}
				Object singleton = meta.getConstructor().newInstance(
				        ArrayUtil.toArray(values));
				List<String> fieldNames = meta.getSetterNames();
				int len = fieldNames.size();
				for (int i = 0; i < len; i++)
				{
					String setterName = ReflectionUtil.getSetterMethodName(fieldNames
					        .get(i));
					Class<?> type = meta.getSetterArgTypes().get(i);
					Method setter = clazz.getMethod(setterName, type);
					Object value = meta.getSetterArgValues().get(i);
					setter.invoke(singleton, value);
				}
				singletonComponents.put(meta.getName(), singleton);
			}

			metaComponents.put(name, meta);
		}
		DIContainer container = new DIContainerImpl();
		container.setName(config.getName());
		container.setMetaComponents(metaComponents);
		container.setSingletonComponents(singletonComponents);
		return container;
	}
}
