package org.lightdi.container;

import java.util.Map;

import org.lightdi.container.meta.MetaComponent;
import org.lightdi.container.security.ContainerLockKey;

public interface DIContainer
{

	public Map<String, MetaComponent> getMetaComponents();

	public void setMetaComponents(Map<String, MetaComponent> metaComponents);

	public Map<String, Object> getSingletonComponents();

	public void setSingletonComponents(Map<String, Object> singletonComponents);

	public ContainerLockKey getKey();

	public void setKey(ContainerLockKey key);

	public Object getComponent(String componentName);

	public Map<String, Object> getComponents();

	public String getName();

	public void setName(String name);

	public void lock(ContainerLockKey key);

	public void unlock(ContainerLockKey key);

	public boolean isLocked();

}
