/*
 * Decompiled with CFR 0.152.
 */
package game.base.symbol;

import game.base.common.HasAbsoluteXY;
import game.base.input.InputInterface;
import game.base.main.GameMain;
import game.base.symbol.MouseSymbolLayer;
import game.base.symbol.SymbolArea;
import java.util.HashSet;
import java.util.Set;

public class MouseSymbol {
    private Set<SymbolArea> areas = new HashSet<SymbolArea>();
    private boolean mouseOver = false;
    private boolean mouseEnter = false;
    private boolean mouseExit = false;
    private boolean mousePrimaryClicked = false;
    private boolean mouseSecondaryClicked = false;
    private boolean active = false;
    private GameMain game;
    private HasAbsoluteXY origin;
    private MouseSymbolLayer layer;

    public MouseSymbol(GameMain gameMain, MouseSymbolLayer mouseSymbolLayer) {
        this.layer = mouseSymbolLayer;
        this.game = gameMain;
    }

    public void update() {
        if (!this.checkActive()) {
            this.mouseEnter = false;
            this.mouseExit = false;
            this.mousePrimaryClicked = false;
            this.mouseSecondaryClicked = false;
            return;
        }
        this.mousePrimaryClicked = false;
        this.mouseSecondaryClicked = false;
        this.mouseEnter = false;
        this.mouseExit = false;
        boolean bl = this.checkMouseOver();
        if (bl && !this.mouseOver) {
            this.mouseEnter = true;
        } else if (!bl && this.mouseOver) {
            this.mouseExit = true;
        }
        this.mouseOver = bl;
        if (this.mouseOver) {
            InputInterface inputInterface = this.game.getInput();
            this.mousePrimaryClicked = inputInterface.isMousePrimaryClicked();
            this.mouseSecondaryClicked = inputInterface.isMouseSecondaryClicked();
        }
    }

    protected boolean checkActive() {
        if (this.layer == null) {
            return false;
        }
        return this.active && this.layer.isActive();
    }

    private boolean checkMouseOver() {
        for (SymbolArea symbolArea : this.areas) {
            if (!symbolArea.isInner(this.getMouseX(), this.getMouseY())) continue;
            return true;
        }
        return false;
    }

    public void setOrigin(HasAbsoluteXY hasAbsoluteXY) {
        this.origin = hasAbsoluteXY;
    }

    public int getMouseX() {
        InputInterface inputInterface = this.game.getInput();
        int n = inputInterface.getMouseX();
        if (this.origin != null) {
            n -= this.origin.getAbsoluteX();
        }
        return n;
    }

    public int getMouseY() {
        InputInterface inputInterface = this.game.getInput();
        int n = inputInterface.getMouseY();
        if (this.origin != null) {
            n -= this.origin.getAbsoluteY();
        }
        return n;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public Set<SymbolArea> getAreas() {
        return this.areas;
    }

    public void setAreas(Set<SymbolArea> set) {
        this.areas = set;
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    public boolean isMouseEnter() {
        return this.mouseEnter;
    }

    public boolean isMouseExit() {
        return this.mouseExit;
    }

    public boolean isMousePrimaryClicked() {
        return this.mousePrimaryClicked;
    }

    public boolean isMouseSecondaryClicked() {
        return this.mouseSecondaryClicked;
    }
}

