/*
 * Decompiled with CFR 0.152.
 */
package game.base.calc;

public class AffineMatrix {
    private double[][] data;

    public AffineMatrix() {
        this.initialize();
    }

    public AffineMatrix(double[][] dArray) {
        this.setMatrix(dArray);
    }

    public void translate(double d, double d2) {
        this.data[0][2] = d;
        this.data[1][2] = d2;
    }

    public void rotate(double d) {
        this.data[0][0] = Math.cos(this.radian(d));
        this.data[0][1] = -1.0 * Math.sin(this.radian(d));
        this.data[1][0] = Math.sin(this.radian(d));
        this.data[1][1] = Math.cos(this.radian(d));
    }

    private double radian(double d) {
        return d * Math.PI / 180.0;
    }

    public void initialize() {
        double[][] dArrayArray = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}};
        this.setMatrix(dArrayArray);
    }

    public void setMatrix(double[][] dArray) {
        this.data = new double[2][3];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.data[i][j] = dArray[i][j];
            }
        }
    }

    public double[][] getMatrix() {
        double[][] dArray = new double[2][3];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                dArray[i][j] = this.data[i][j];
            }
        }
        return dArray;
    }

    public AffineMatrix calc(AffineMatrix affineMatrix) {
        double[][] dArray = this.getMatrix();
        double[][] dArray2 = affineMatrix.getMatrix();
        double[][] dArrayArray = new double[][]{{dArray2[0][0] * dArray[0][0] + dArray2[0][1] * dArray[1][0], dArray2[0][0] * dArray[0][1] + dArray2[0][1] * dArray[1][1], dArray2[0][0] * dArray[0][2] + dArray2[0][1] * dArray[1][2] + dArray2[0][2]}, {dArray2[1][0] * dArray[0][0] + dArray2[1][1] * dArray[1][0], dArray2[1][0] * dArray[0][1] + dArray2[1][1] * dArray[1][1], dArray2[1][0] * dArray[0][2] + dArray2[1][1] * dArray[1][2] + dArray2[1][2]}};
        return new AffineMatrix(dArrayArray);
    }
}

