/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.data;

import game.sengoku.data.DaimyoV;
import game.sengoku.data.DataUtil;
import game.sengoku.data.GameDataObjectV;
import game.sengoku.data.Role;
import game.sengoku.data.ValidErrorMessage;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;

public class RoleV
extends GameDataObjectV {
    public static final int ID_NONE = 0;
    public static final int ID_MIN = 0;
    public static final int ID_MAX = 99;
    public static final int DAIMYO_ID_MIN = 0;
    public static final int DAIMYO_ID_MAX = 99;
    @Attribute(required=true, name="id")
    private int id = 0;
    @Element(required=true, name="daimyo_id")
    private int daimyoId = 0;

    public RoleV(int n) {
        this.id = n;
    }

    public RoleV(@Attribute(name="id") int n, @Element(name="daimyo_id") int n2) {
        this.id = n;
        this.id = DataUtil.checkInteger(n, 0, 99);
        this.daimyoId = n2;
        this.daimyoId = DataUtil.checkInteger(n2, 0, 99);
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = DataUtil.checkInteger(n, 0, 99);
    }

    public Role getRole() {
        return this.getGameData().getRoleList().get(this.id);
    }

    public int getDaimyoId() {
        return this.daimyoId;
    }

    public void setDaimyoId(int n) {
        this.daimyoId = DataUtil.checkInteger(n, 0, 99);
    }

    public DaimyoV getDaimyo() {
        return this.getGameDataV().getDaimyos().get(this.daimyoId);
    }

    public void update() {
    }

    @Override
    public String getName() {
        return this.getRole().getName();
    }

    @Override
    public boolean checkValid(List<ValidErrorMessage> list) {
        int n = 0;
        if (!super.checkValid(list)) {
            ++n;
        }
        if (this.daimyoId != 0 && !this.getGameDataV().getDaimyos().containsKey(this.daimyoId)) {
            this.daimyoId = 0;
        }
        return n == 0;
    }
}

