/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.data;

import game.base.common.PairKeyMap;
import game.sengoku.data.AIType;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.DataUtil;
import game.sengoku.data.GameDataObjectV;
import game.sengoku.data.UnmodifiableReration;
import java.util.HashMap;
import java.util.Map;
import org.simpleframework.xml.Element;

public class RelationV
extends GameDataObjectV
implements UnmodifiableReration {
    public static final int STATUS_MIN = 0;
    public static final int STATUS_MAX = 10;
    public static final int ARG1_MIN = 0;
    public static final int ARG1_MAX = 9999;
    public static final int ALLIANCE_MIN = 0;
    public static final int ALLIANCE_MAX = 9999;
    public static final int BORDER_MIN = 0;
    public static final int BORDER_MAX = 9999;
    public static final int WAR_MIN = 0;
    public static final int WAR_MAX = 9999;
    public static final int HATE_MIN = 0;
    public static final int HATE_MAX = 9999;
    public static final int RELATION_STATUS_NONE = 0;
    public static final int RELATION_STATUS_ALLIANCE = 1;
    public static final int RELATION_STATUS_NON_AGGRESSION = 2;
    public static final int RELATION_STATUS_ENEMY = 4;
    public static final int RELATION_STATUS_WAR = 5;
    public static final int RELATION_STATUS_OWNER = 6;
    public static final int RELATION_STATUS_COLONY = 7;
    public static final int DIPLOMACY_FACTOR_ALLIANCE = 1;
    public static final int DIPLOMACY_FACTOR_NON_AGGRESSION = 2;
    public static final int DIPLOMACY_FACTOR_COLONY = 3;
    public static final int DIPLOMACY_FACTOR_OWNER = 4;
    public static final int DIPLOMACY_FACTOR_RENTAL = 5;
    public static final int DIPLOMACY_FACTOR_FAME = 6;
    public static final int DIPLOMACY_FACTOR_IMPACT = 7;
    public static final int DIPLOMACY_FACTOR_BAKUFU = 8;
    public static final int DIPLOMACY_FACTOR_RANK = 9;
    public static final int DIPLOMACY_FACTOR_CULTURE = 10;
    public static final int DIPLOMACY_FACTOR_ENEMY = 11;
    public static final int DIPLOMACY_FACTOR_WAR = 12;
    public static final int DIPLOMACY_FACTOR_COMMON_ALLIANCE = 13;
    public static final int DIPLOMACY_FACTOR_INDIRECT_ENEMY1 = 14;
    public static final int DIPLOMACY_FACTOR_INDIRECT_ENEMY2 = 15;
    public static final int DIPLOMACY_FACTOR_COMMON_ENEMY = 16;
    public static final int DIPLOMACY_FACTOR_HATE = 17;
    public static final int DIPLOMACY_FACTOR_BOUNDARY = 18;
    public static final int DIPLOMACY_FACTOR_TRADE = 19;
    public static final int DIPLOMACY_FACTOR_CHRIST1 = 20;
    public static final int DIPLOMACY_FACTOR_CHRIST2 = 21;
    public static final int DIPLOMACY_FACTOR_FLAGITIOUS = 22;
    public static final int DIPLOMACY_FACTOR_INFORMATION = 23;
    public static final int FRIENDSHIP_HATE = -2;
    public static final int FRIENDSHIP_CAUTION = -1;
    public static final int FRIENDSHIP_NORMAL = 0;
    public static final int FRIENDSHIP_FRIEND = 1;
    public static final int FRIENDSHIP_TRUST = 2;
    public static final int MEANING_ALERT = -2;
    public static final int MEANING_TARGET = -1;
    public static final int MEANING_IGNORE = 0;
    public static final int MEANING_FRIEND = 1;
    @Element(required=true, name="daimyo_id1")
    private int daimyoId1 = 0;
    @Element(required=true, name="daimyo_id2")
    private int daimyoId2 = 0;
    @Element(required=true, name="status")
    private int status = 0;
    @Element(required=true, name="arg1")
    private int arg1 = 0;
    @Element(required=false, name="alliance")
    private int alliance = 0;
    private int border = 0;
    @Element(required=false, name="war")
    private int war = 0;
    @Element(required=false, name="hate")
    private int hate = 0;
    @Element(required=false, name="non_aggression")
    private int nonAggression = 0;
    private boolean commonAlliance = false;
    private boolean indirectEnemy1 = false;
    private boolean indirectEnemy2 = false;
    private boolean commonEnemy = false;
    private boolean needUpdateFriendShip = false;
    private int friendShip = 0;
    private Map<Integer, Integer> diplomacyFactor;
    private boolean needResetRelation = false;

    public RelationV() {
        this.diplomacyFactor = new HashMap<Integer, Integer>();
    }

    public RelationV(@Element(name="daimyo_id1") int n, @Element(name="daimyo_id2") int n2, @Element(name="status") int n3, @Element(name="arg1") int n4, @Element(name="alliance") int n5, @Element(name="war") int n6, @Element(name="hate") int n7) {
        this.daimyoId1 = n;
        this.daimyoId2 = n2;
        this.status = n3;
        this.status = DataUtil.checkInteger(n3, 0, 10);
        this.arg1 = n4;
        this.arg1 = DataUtil.checkInteger(n4, 0, 9999);
        this.alliance = n5;
        this.alliance = DataUtil.checkInteger(n5, 0, 9999);
        this.border = 0;
        this.war = n6;
        this.war = DataUtil.checkInteger(n6, 0, 9999);
        this.hate = n7;
        this.hate = DataUtil.checkInteger(n7, 0, 9999);
        this.friendShip = 0;
        this.diplomacyFactor = new HashMap<Integer, Integer>();
    }

    public RelationV(int n, int n2) {
        this.daimyoId1 = n;
        this.daimyoId2 = n2;
        this.diplomacyFactor = new HashMap<Integer, Integer>();
        this.commonAlliance = false;
        this.indirectEnemy1 = false;
        this.indirectEnemy2 = false;
        this.commonEnemy = false;
        this.needUpdateFriendShip = false;
        this.needResetRelation = true;
    }

    public void resetRelation(int n, int n2, UnmodifiableReration unmodifiableReration, UnmodifiableReration unmodifiableReration2) {
        this.needResetRelation = false;
        this.daimyoId1 = n;
        this.daimyoId2 = n2;
        this.status = unmodifiableReration.getStatus();
        this.arg1 = unmodifiableReration.getArg1();
        this.alliance = unmodifiableReration.getAlliance();
        this.border = unmodifiableReration.getBorder();
        this.war = unmodifiableReration.getWar();
        this.hate = unmodifiableReration.getHate();
        this.diplomacyFactor = new HashMap<Integer, Integer>();
        this.commonAlliance = unmodifiableReration.isCommonAlliance();
        this.indirectEnemy1 = unmodifiableReration.isIndirectEnemy1();
        this.indirectEnemy2 = unmodifiableReration.isIndirectEnemy2();
        this.commonEnemy = unmodifiableReration.isCommonEnemy();
        this.needUpdateFriendShip = true;
        if (unmodifiableReration2.getWar() > 0 && (this.status == 0 || this.status == 4)) {
            this.status = 5;
            this.war = unmodifiableReration2.getWar();
            this.needUpdateFriendShip = true;
        }
    }

    @Override
    public int getDaimyoId1() {
        return this.daimyoId1;
    }

    public void setDaimyoId1(int n) {
        this.daimyoId1 = n;
    }

    @Override
    public DaimyoV getDaimyo1() {
        return this.getGameDataV().getDaimyos().get(this.daimyoId1);
    }

    @Override
    public int getDaimyoId2() {
        return this.daimyoId2;
    }

    public void setDaimyoId2(int n) {
        this.daimyoId2 = n;
    }

    @Override
    public DaimyoV getDaimyo2() {
        return this.getGameDataV().getDaimyos().get(this.daimyoId2);
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = DataUtil.checkInteger(n, 0, 10);
    }

    @Override
    public int getArg1() {
        return this.arg1;
    }

    public void setArg1(int n) {
        this.arg1 = DataUtil.checkInteger(n, 0, 9999);
    }

    @Override
    public int getAlliance() {
        return this.alliance;
    }

    public void setAlliance(int n) {
        this.alliance = DataUtil.checkInteger(n, 0, 9999);
    }

    @Override
    public int getBorder() {
        return this.border;
    }

    @Override
    public int getNonAggression() {
        return this.nonAggression;
    }

    public void setNonAggression(int n) {
        this.nonAggression = DataUtil.checkInteger(n, 0, 9999);
    }

    @Override
    public int getWar() {
        return this.war;
    }

    public void setWar(int n) {
        this.war = DataUtil.checkInteger(n, 0, 9999);
    }

    @Override
    public int getHate() {
        return this.hate;
    }

    public void setHate(int n) {
        this.hate = DataUtil.checkInteger(n, 0, 9999);
    }

    public void updateByMonth() {
        if (this.status == 1 || this.status == 2) {
            this.setAlliance(this.alliance + 1);
            this.setWar(0);
        } else {
            this.setAlliance(0);
        }
        if (this.status == 2) {
            this.setNonAggression(this.nonAggression - 1);
        }
        this.setWar(this.war - 1);
        this.setHate(this.hate - 1);
        this.update();
    }

    public void updateBorder() {
        this.border = this.getGameDataV().getBorderConflicts().stream().filter(borderConflictV -> borderConflictV.getDaimyoId1() == this.getDaimyoId1() && borderConflictV.getDaimyoId2() == this.getDaimyoId2() || borderConflictV.getDaimyoId1() == this.getDaimyoId2() && borderConflictV.getDaimyoId2() == this.getDaimyoId1()).mapToInt(borderConflictV -> borderConflictV.getMonth()).max().orElse(0);
    }

    public void update() {
        if (this.getDaimyo1().isFall() || this.getDaimyo2().isFall()) {
            this.status = 0;
            this.friendShip = 0;
            this.setWar(0);
            this.setHate(0);
            this.border = 0;
            this.nonAggression = 0;
            this.setAlliance(0);
            this.diplomacyFactor.clear();
        } else {
            this.needUpdateFriendShip = true;
            this.updateBorder();
        }
    }

    @Override
    public int getFriendShip() {
        if (this.needUpdateFriendShip) {
            this.updateDiplomacyFactor();
            this.needUpdateFriendShip = false;
        }
        return this.friendShip;
    }

    @Override
    public Map<Integer, Integer> getDiplomacyFactor() {
        if (this.needUpdateFriendShip) {
            this.updateDiplomacyFactor();
            this.needUpdateFriendShip = false;
        }
        return this.diplomacyFactor;
    }

    public void updateDiplomacyFactor() {
        double d;
        this.diplomacyFactor.clear();
        this.commonAlliance = false;
        this.indirectEnemy1 = false;
        this.indirectEnemy2 = false;
        this.commonEnemy = false;
        DaimyoV daimyoV3 = this.getDaimyo1();
        AIType aIType = daimyoV3.getAiType();
        DaimyoV daimyoV4 = this.getDaimyo2();
        PairKeyMap<Integer, Integer, Integer> pairKeyMap = this.gameDataV.getRanking();
        int n2 = pairKeyMap.size() / 3;
        int n3 = pairKeyMap.size() - n2;
        int n4 = 1;
        if (this.status == 1) {
            n4 = Math.min(3, 1 + this.alliance / 12);
            this.diplomacyFactor.put(1, aIType.getDiplomacyFactorAlliance() * n4);
        }
        if (this.status == 2) {
            n4 = Math.min(3, 1 + this.alliance / 12);
            this.diplomacyFactor.put(2, aIType.getDiplomacyFactorNonAggression() * n4);
        }
        if (this.status == 7) {
            this.diplomacyFactor.put(3, aIType.getDiplomacyFactorColony());
        }
        if (this.status == 6) {
            this.diplomacyFactor.put(4, aIType.getDiplomacyFactorOwner());
        }
        if (daimyoV3.getKnights().parallelStream().anyMatch(knightV -> knightV.getRentalDaimyoId() == this.daimyoId2)) {
            this.diplomacyFactor.put(5, -1 * aIType.getDiplomacyFactorRental());
        }
        if (daimyoV4.getKnights().parallelStream().anyMatch(knightV -> knightV.getRentalDaimyoId() == this.daimyoId1)) {
            this.diplomacyFactor.put(5, aIType.getDiplomacyFactorRental());
        }
        if (daimyoV3.getFame() < daimyoV4.getFame() && 0 < daimyoV4.getFame()) {
            n4 = daimyoV3.getFame() <= 0 ? 3 : Math.min(3, daimyoV4.getFame() / daimyoV3.getFame());
            this.diplomacyFactor.put(6, aIType.getDiplomacyFactorFame() * n4);
        } else if (daimyoV4.getFame() < daimyoV3.getFame() && 0 < daimyoV3.getFame()) {
            this.diplomacyFactor.put(6, -1 * aIType.getDiplomacyFactorFame());
        }
        if (daimyoV4.getFame() < 0) {
            this.diplomacyFactor.put(22, -1 * aIType.getDiplomacyFactorFame());
        }
        if ((d = this.getGameDataV().getDaimyos().values().stream().filter(daimyoV -> !daimyoV.isFall()).mapToInt(daimyoV -> daimyoV.getImpact()).average().orElse(1.0)) < (double)daimyoV4.getImpact() && (Integer)pairKeyMap.get((Object)6, (Object)daimyoV4.getId()) <= n2) {
            n4 = (int)Math.min(3.0, (double)daimyoV4.getImpact() / d);
            this.diplomacyFactor.put(7, aIType.getDiplomacyFactorImpact() * n4);
        } else if (daimyoV4.getImpact() < daimyoV3.getImpact() && (Integer)pairKeyMap.get((Object)6, (Object)daimyoV4.getId()) >= n3) {
            n4 = (int)Math.min(3.0, d / (double)daimyoV4.getImpact());
            this.diplomacyFactor.put(7, -1 * aIType.getDiplomacyFactorImpact() * n4);
        }
        int n5 = aIType.getDiplomacyFactorChrist();
        if (daimyoV3.getChristTreat() == 1) {
            if (daimyoV4.getChristTreat() == 1) {
                this.diplomacyFactor.put(20, n5 * 1);
            } else if (daimyoV4.getChristTreat() == -1) {
                this.diplomacyFactor.put(20, -1 * n5 * 1);
            }
        }
        if (daimyoV3.getChristTreat() == -1) {
            if (daimyoV4.getChristTreat() == 1) {
                this.diplomacyFactor.put(21, -1 * n5 * 1);
            } else if (daimyoV4.getChristTreat() == -1) {
                this.diplomacyFactor.put(21, n5 * 1);
            }
        }
        if (daimyoV4.isShogun()) {
            this.diplomacyFactor.put(8, aIType.getDiplomacyFactorBakufu());
        } else if (daimyoV4.getToubatsuLeave() > 0) {
            this.diplomacyFactor.put(8, -2 * aIType.getDiplomacyFactorBakufu());
        }
        double d2 = this.getGameDataV().getDaimyos().values().stream().filter(daimyoV -> !daimyoV.isFall()).mapToInt(daimyoV -> daimyoV.getCultureArv()).average().orElse(1.0);
        if (d2 < (double)daimyoV4.getCultureArv() && (Integer)pairKeyMap.get((Object)4, (Object)daimyoV4.getId()) <= n2) {
            n4 = (int)Math.min(3.0, (double)daimyoV4.getCultureArv() / d2);
            this.diplomacyFactor.put(10, aIType.getDiplomacyFactorCulture() * n4);
        } else if (daimyoV4.getCultureArv() < daimyoV3.getCultureArv() && (Integer)pairKeyMap.get((Object)4, (Object)daimyoV4.getId()) >= n3) {
            n4 = (int)Math.min(3.0, d2 / (double)daimyoV4.getCultureArv());
            this.diplomacyFactor.put(10, -1 * aIType.getDiplomacyFactorCulture() * n4);
        }
        if (this.status == 4) {
            this.diplomacyFactor.put(11, -1 * aIType.getDiplomacyFactorEnemy());
        }
        if (this.status == 5) {
            this.diplomacyFactor.put(12, -1 * aIType.getDiplomacyFactorWar());
        }
        long l = this.gameDataV.getDaimyos().values().stream().filter(daimyoV2 -> this.gameDataV.isAlliance(daimyoV3.getId(), daimyoV2.getId())).filter(daimyoV2 -> this.gameDataV.isAlliance(daimyoV4.getId(), daimyoV2.getId())).count();
        if (0L < (l = Math.min(5L, l))) {
            this.commonAlliance = true;
            this.diplomacyFactor.put(13, aIType.getDiplomacyFactorCommonAlliance() * (int)l);
        }
        l = this.gameDataV.getDaimyos().values().stream().filter(daimyoV2 -> this.gameDataV.isAlliance(daimyoV3.getId(), daimyoV2.getId())).filter(daimyoV2 -> this.gameDataV.isEnemy(daimyoV2.getId(), daimyoV4.getId())).count();
        if (0L < (l = Math.min(5L, l))) {
            this.indirectEnemy1 = true;
            this.diplomacyFactor.put(14, -1 * aIType.getDiplomacyFactorIndirectEnemy1() * (int)l);
        }
        l = this.gameDataV.getDaimyos().values().stream().filter(daimyoV2 -> this.gameDataV.isEnemy(daimyoV3.getId(), daimyoV2.getId())).filter(daimyoV2 -> this.gameDataV.isAlliance(daimyoV4.getId(), daimyoV2.getId())).count();
        if (0L < (l = Math.min(5L, l))) {
            this.indirectEnemy2 = true;
            this.diplomacyFactor.put(15, -1 * aIType.getDiplomacyFactorIndirectEnemy2() * (int)l);
        }
        l = this.gameDataV.getDaimyos().values().stream().filter(daimyoV2 -> this.gameDataV.isEnemy(daimyoV3.getId(), daimyoV2.getId())).filter(daimyoV2 -> this.gameDataV.isEnemy(daimyoV4.getId(), daimyoV2.getId())).count();
        if (0L < (l = Math.min(5L, l))) {
            this.commonEnemy = true;
            this.diplomacyFactor.put(16, aIType.getDiplomacyFactorCommonEnemy() * (int)l);
        }
        if (0 < this.hate) {
            n4 = Math.min(3, 1 + this.hate / 3);
            this.diplomacyFactor.put(17, -1 * aIType.getDiplomacyFactorHate() * n4);
        }
        if (0 < this.border) {
            n4 = Math.min(3, 1 + this.border / 4);
            this.diplomacyFactor.put(18, -1 * aIType.getDiplomacyFactorBoundary() * n4);
        }
        this.friendShip = this.diplomacyFactor.values().parallelStream().mapToInt(n -> n).sum();
    }

    @Override
    public int getFriendShipType() {
        if (this.needUpdateFriendShip) {
            this.updateDiplomacyFactor();
            this.needUpdateFriendShip = false;
        }
        if (this.friendShip <= -15) {
            return -2;
        }
        if (this.friendShip <= -5) {
            return -1;
        }
        if (this.friendShip < 5) {
            return 0;
        }
        if (this.friendShip < 15) {
            return 1;
        }
        return 2;
    }

    @Override
    public boolean isCommonAlliance() {
        return this.commonAlliance;
    }

    @Override
    public boolean isIndirectEnemy1() {
        return this.indirectEnemy1;
    }

    @Override
    public boolean isIndirectEnemy2() {
        return this.indirectEnemy2;
    }

    @Override
    public boolean isCommonEnemy() {
        return this.commonEnemy;
    }

    public boolean isNeedResetRelation() {
        return this.needResetRelation;
    }

    public void setNeedResetRelation(boolean bl) {
        this.needResetRelation = bl;
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public String toString() {
        return "RelationV [daimyoId1=" + this.daimyoId1 + ", daimyoId2=" + this.daimyoId2 + ", status=" + this.status + ", arg1=" + this.arg1 + ", friendShip=" + this.friendShip + "]";
    }
}

