/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.data;

import game.sengoku.data.AIType;
import game.sengoku.data.AIUseObject;
import game.sengoku.data.BuildPlan;
import game.sengoku.data.CommandV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.DataUtil;
import game.sengoku.data.GameDataObjectV;
import game.sengoku.data.GameHistory;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;

public class PlayerV
extends GameDataObjectV {
    public static final int ID_MIN = 0;
    public static final int ID_MAX = 9999;
    public static final int AI_TYPE_ID_MIN = 0;
    public static final int AI_TYPE_ID_MAX = 99;
    public static final int DAIMYO_ID_MIN = 0;
    public static final int DAIMYO_ID_MAX = 99;
    @Attribute(required=true, name="id")
    private int id = 0;
    @Element(required=true, name="ai_type_id")
    private int aiTypeId = 0;
    @Element(required=true, name="daimyo_id")
    private int daimyoId = 0;
    @ElementList(required=true, name="commands")
    private List<CommandV> commands = null;
    @Element(required=true, name="ai_use_object")
    private AIUseObject aIUseObject = null;
    @ElementList(required=true, name="back_logs")
    private List<GameHistory> backLogs = null;
    @ElementList(required=true, name="histories")
    private List<GameHistory> histories = null;
    @ElementList(required=true, name="events")
    private List<Integer> events = null;
    @ElementList(required=true, name="build_plans")
    private List<BuildPlan> buildPlans = null;

    public PlayerV() {
        this.commands = new ArrayList<CommandV>();
        this.backLogs = new ArrayList<GameHistory>();
        this.histories = new ArrayList<GameHistory>();
        this.events = new ArrayList<Integer>();
        this.buildPlans = new ArrayList<BuildPlan>();
        this.aIUseObject = new AIUseObject();
    }

    public PlayerV(@Attribute(name="id") int n, @Element(name="ai_type_id") int n2, @Element(name="daimyo_id") int n3, @Element(name="ai_use_object") AIUseObject aIUseObject) {
        this.id = n;
        DataUtil.assertInteger(n, 0, 9999);
        this.aiTypeId = n2;
        this.daimyoId = n3;
        this.commands = new ArrayList<CommandV>();
        this.backLogs = new ArrayList<GameHistory>();
        this.histories = new ArrayList<GameHistory>();
        this.events = new ArrayList<Integer>();
        this.buildPlans = new ArrayList<BuildPlan>();
        this.aIUseObject = aIUseObject;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public int getAiTypeId() {
        return this.aiTypeId;
    }

    public void setAiTypeId(int n) {
        this.aiTypeId = n;
    }

    public AIType getAiType() {
        return this.getGameAIData().getAiTypes().get(this.aiTypeId);
    }

    public int getDaimyoId() {
        return this.daimyoId;
    }

    public void setDaimyoId(int n) {
        this.daimyoId = n;
    }

    public DaimyoV getDaimyo() {
        return this.getGameDataV().getDaimyos().get(this.daimyoId);
    }

    public List<CommandV> getCommands() {
        return this.commands;
    }

    public void setCommands(List<CommandV> list) {
        this.commands = list;
    }

    public List<GameHistory> getBackLogs() {
        return this.backLogs;
    }

    public void setBackLogs(List<GameHistory> list) {
        this.backLogs = list;
    }

    public List<GameHistory> getHistories() {
        return this.histories;
    }

    public void setHistories(List<GameHistory> list) {
        this.histories = list;
    }

    public AIUseObject getAIUseObject() {
        return this.aIUseObject;
    }

    public void setAIUseObject(AIUseObject aIUseObject) {
        this.aIUseObject = aIUseObject;
    }

    public List<Integer> getEvents() {
        return this.events;
    }

    public void setEvents(List<Integer> list) {
        this.events = list;
    }

    public List<BuildPlan> getBuildPlans() {
        return this.buildPlans;
    }

    public void setBuildPlans(List<BuildPlan> list) {
        this.buildPlans = list;
    }

    public void update() {
    }

    @Override
    public String getName() {
        return "";
    }

    public String toString() {
        return "PlayerV [id=" + this.id + ", aiTypeId=" + this.aiTypeId + ", daimyoId=" + this.daimyoId + "]";
    }
}

