/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.data;

import game.sengoku.data.DataUtil;
import game.sengoku.data.Effect;
import game.sengoku.data.GameDataObject;
import game.sengoku.data.ValidErrorMessage;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;

public class Giant
extends GameDataObject {
    public static final int ID_NONE = 0;
    public static final int ID_MIN = 0;
    public static final int ID_MAX = 999;
    public static final int APPEAR_MIN = 1500;
    public static final int APPEAR_MAX = 1600;
    public static final int MIN_CULTURE_MIN = 0;
    public static final int MIN_CULTURE_MAX = 9999;
    public static final int CULTURE_MONTHS_MIN = 0;
    public static final int CULTURE_MONTHS_MAX = 9999;
    public static final int PAY_MIN = 0;
    public static final int PAY_MAX = 9999;
    @Attribute(required=true, name="id")
    private int id = 0;
    @Element(required=true, name="type")
    private String type = "";
    @Element(required=false, name="family")
    private String family = "";
    @Element(required=true, name="name")
    private String name = "";
    @Element(required=true, name="appear")
    private int appear = 1500;
    @Element(required=false, name="spot_id")
    private int spotId = 0;
    @Element(required=true, name="effect")
    private Effect effect = null;
    @Element(required=true, name="min_culture")
    private int minCulture = 0;
    @Element(required=true, name="culture_months")
    private int cultureMonths = 0;
    @Element(required=true, name="culture_id")
    private int cultureId = 0;
    @Element(required=true, name="treasure_id")
    private int treasureId = 0;
    @Element(required=true, name="technology_id")
    private int technologyId = 0;
    @Element(required=true, name="pay")
    private int pay = 0;
    @Element(required=false, name="explain")
    private String explain = "";

    public Giant() {
    }

    public Giant(@Attribute(name="id") int n, @Element(name="type") String string, @Element(name="family") String string2, @Element(name="name") String string3, @Element(name="appear") int n2, @Element(name="spot_id") int n3, @Element(name="effect") Effect effect, @Element(name="min_culture") int n4, @Element(name="culture_months") int n5, @Element(name="culture_id") int n6, @Element(name="treasure_id") int n7, @Element(name="technology_id") int n8, @Element(name="pay") int n9, @Element(name="explain") String string4) {
        this.id = n;
        DataUtil.assertInteger(n, 0, 999);
        this.type = string;
        this.family = string2;
        this.name = string3;
        this.appear = n2;
        this.appear = DataUtil.checkInteger(n2, 1500, 1600);
        this.spotId = n3;
        this.effect = effect;
        this.minCulture = n4;
        this.minCulture = DataUtil.checkInteger(n4, 0, 9999);
        this.cultureMonths = n5;
        this.cultureMonths = DataUtil.checkInteger(n5, 0, 9999);
        this.cultureId = n6;
        this.treasureId = n7;
        this.technologyId = n8;
        this.pay = n9;
        this.pay = DataUtil.checkInteger(n9, 0, 9999);
        this.explain = string4;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getFamily() {
        return this.family;
    }

    public void setFamily(String string) {
        this.family = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getAppear() {
        return this.appear;
    }

    public void setAppear(int n) {
        this.appear = DataUtil.checkInteger(n, 1500, 1600);
    }

    public int getSpotId() {
        return this.spotId;
    }

    public void setSpotId(int n) {
        this.spotId = n;
    }

    public Effect getEffect() {
        return this.effect;
    }

    public void setEffect(Effect effect) {
        this.effect = effect;
    }

    public int getMinCulture() {
        return this.minCulture;
    }

    public void setMinCulture(int n) {
        this.minCulture = DataUtil.checkInteger(n, 0, 9999);
    }

    public int getCultureMonths() {
        return this.cultureMonths;
    }

    public void setCultureMonths(int n) {
        this.cultureMonths = DataUtil.checkInteger(n, 0, 9999);
    }

    public int getCultureId() {
        return this.cultureId;
    }

    public void setCultureId(int n) {
        this.cultureId = n;
    }

    public int getTreasureId() {
        return this.treasureId;
    }

    public void setTreasureId(int n) {
        this.treasureId = n;
    }

    public int getTechnologyId() {
        return this.technologyId;
    }

    public void setTechnologyId(int n) {
        this.technologyId = n;
    }

    public int getPay() {
        return this.pay;
    }

    public void setPay(int n) {
        this.pay = DataUtil.checkInteger(n, 0, 9999);
    }

    public String getExplain() {
        return this.explain;
    }

    public void setExplain(String string) {
        this.explain = string;
    }

    @Override
    public String getLabel() {
        return this.getId() + " " + this.family + this.name;
    }

    @Override
    public boolean checkValid(List<ValidErrorMessage> list) {
        int n = 0;
        if (!super.checkValid(list)) {
            ++n;
        }
        if (!DataUtil.valid(this, this.getType(), "\u6587\u5316\u4eba\u30bf\u30a4\u30d7", list)) {
            ++n;
        }
        if (this.cultureId != 0 && !this.getGameData().getCultures().containsKey(this.cultureId)) {
            this.cultureId = 0;
        }
        if (this.treasureId != 0 && !this.getGameData().getTreasures().containsKey(this.treasureId)) {
            this.treasureId = 0;
        }
        if (this.technologyId != 0 && !this.getGameData().getTechnologies().containsKey(this.technologyId)) {
            this.technologyId = 0;
        }
        return n == 0;
    }
}

