/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.data;

import game.sengoku.data.Baptism;
import game.sengoku.data.Build;
import game.sengoku.data.Calendar;
import game.sengoku.data.Culture;
import game.sengoku.data.DataUtil;
import game.sengoku.data.Family;
import game.sengoku.data.GameDataObject;
import game.sengoku.data.GameParameters;
import game.sengoku.data.Giant;
import game.sengoku.data.JapanData;
import game.sengoku.data.Knight;
import game.sengoku.data.Mapping;
import game.sengoku.data.Rank;
import game.sengoku.data.Role;
import game.sengoku.data.Store;
import game.sengoku.data.Technique;
import game.sengoku.data.Technology;
import game.sengoku.data.Treasure;
import game.sengoku.data.UnitType;
import game.sengoku.data.ValidErrorMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementMap;

public class GameData {
    @Element(required=true, name="parameters")
    private GameParameters parameters = new GameParameters();
    @Element(required=true, name="japan")
    private JapanData japan = null;
    @Element(required=true, name="map")
    private Mapping map = null;
    @Element(required=true, name="calendar")
    private Calendar calendar = null;
    @ElementMap(required=true, name="knights", key="key", attribute=true)
    private Map<Integer, Knight> knights = null;
    @ElementMap(required=true, name="families", key="key", attribute=true)
    private Map<Integer, Family> families = null;
    @ElementMap(required=true, name="technologies", key="key", attribute=true)
    private Map<Integer, Technology> technologies = null;
    @ElementMap(required=true, name="builds", key="key", attribute=true)
    private Map<Integer, Build> builds = null;
    @ElementMap(required=true, name="giants", key="key", attribute=true)
    private Map<Integer, Giant> giants = null;
    @ElementMap(required=true, name="cultures", key="key", attribute=true)
    private Map<Integer, Culture> cultures = null;
    @ElementMap(required=true, name="treasures", key="key", attribute=true)
    private Map<Integer, Treasure> treasures = null;
    @ElementMap(required=true, name="role_list", key="key", attribute=true)
    private Map<Integer, Role> roleList = null;
    @ElementMap(required=true, name="ranks", key="key", attribute=true)
    private Map<Integer, Rank> ranks = null;
    @ElementMap(required=true, name="unit_types", key="key", attribute=true)
    private Map<Integer, UnitType> unitTypes = null;
    @ElementMap(required=true, name="stores", key="key", attribute=true)
    private Map<Integer, Store> stores = null;
    @ElementMap(required=true, name="techniques", key="key", attribute=true)
    private Map<Integer, Technique> techniques = null;
    @ElementMap(required=true, name="baptisms", key="key", attribute=true)
    private Map<Integer, Baptism> baptisms = null;

    public GameData() {
        this.japan = new JapanData();
        this.map = new Mapping();
        this.calendar = new Calendar();
        this.knights = new HashMap<Integer, Knight>();
        this.families = new HashMap<Integer, Family>();
        this.technologies = new HashMap<Integer, Technology>();
        this.builds = new HashMap<Integer, Build>();
        this.giants = new HashMap<Integer, Giant>();
        this.cultures = new HashMap<Integer, Culture>();
        this.treasures = new HashMap<Integer, Treasure>();
        this.roleList = new HashMap<Integer, Role>();
        this.ranks = new HashMap<Integer, Rank>();
        this.unitTypes = new HashMap<Integer, UnitType>();
        this.stores = new HashMap<Integer, Store>();
        this.techniques = new HashMap<Integer, Technique>();
        this.baptisms = new HashMap<Integer, Baptism>();
    }

    public GameData(@Element(name="japan") JapanData japanData, @Element(name="map") Mapping mapping, @Element(name="calendar") Calendar calendar) {
        this.japan = japanData;
        this.map = mapping;
        this.calendar = calendar;
        this.knights = new HashMap<Integer, Knight>();
        this.families = new HashMap<Integer, Family>();
        this.technologies = new HashMap<Integer, Technology>();
        this.builds = new HashMap<Integer, Build>();
        this.giants = new HashMap<Integer, Giant>();
        this.cultures = new HashMap<Integer, Culture>();
        this.treasures = new HashMap<Integer, Treasure>();
        this.roleList = new HashMap<Integer, Role>();
        this.ranks = new HashMap<Integer, Rank>();
        this.unitTypes = new HashMap<Integer, UnitType>();
        this.stores = new HashMap<Integer, Store>();
        this.techniques = new HashMap<Integer, Technique>();
        this.baptisms = new HashMap<Integer, Baptism>();
    }

    public GameParameters getParameters() {
        return this.parameters;
    }

    public JapanData getJapan() {
        return this.japan;
    }

    public Mapping getMap() {
        return this.map;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public Map<Integer, Knight> getKnights() {
        return this.knights;
    }

    public Map<Integer, Family> getFamilies() {
        return this.families;
    }

    public Map<Integer, Technology> getTechnologies() {
        return this.technologies;
    }

    public Map<Integer, Build> getBuilds() {
        return this.builds;
    }

    public Map<Integer, Giant> getGiants() {
        return this.giants;
    }

    public Map<Integer, Culture> getCultures() {
        return this.cultures;
    }

    public Map<Integer, Treasure> getTreasures() {
        return this.treasures;
    }

    public Map<Integer, Role> getRoleList() {
        return this.roleList;
    }

    public Map<Integer, Rank> getRanks() {
        return this.ranks;
    }

    public Map<Integer, UnitType> getUnitTypes() {
        return this.unitTypes;
    }

    public Map<Integer, Store> getStores() {
        return this.stores;
    }

    public Map<Integer, Technique> getTechniques() {
        return this.techniques;
    }

    public Map<Integer, Baptism> getBaptisms() {
        return this.baptisms;
    }

    public void setBaptisms(Map<Integer, Baptism> map) {
        this.baptisms = map;
    }

    public void merge(GameData gameData) {
        DataUtil.merge(this.getKnights(), gameData.getKnights());
        DataUtil.merge(this.getFamilies(), gameData.getFamilies());
        DataUtil.merge(this.getTechnologies(), gameData.getTechnologies());
        DataUtil.merge(this.getBuilds(), gameData.getBuilds());
        DataUtil.merge(this.getGiants(), gameData.getGiants());
        DataUtil.merge(this.getCultures(), gameData.getCultures());
        DataUtil.merge(this.getTreasures(), gameData.getTreasures());
        DataUtil.merge(this.getRoleList(), gameData.getRoleList());
        DataUtil.merge(this.getRanks(), gameData.getRanks());
        DataUtil.merge(this.getUnitTypes(), gameData.getUnitTypes());
        DataUtil.merge(this.getStores(), gameData.getStores());
        DataUtil.merge(this.getTechniques(), gameData.getTechniques());
        DataUtil.merge(this.getBaptisms(), gameData.getBaptisms());
    }

    public boolean checkValid(List<ValidErrorMessage> list) {
        for (GameDataObject gameDataObject : this.japan.getCountries().values()) {
            gameDataObject.checkValid(list);
        }
        for (GameDataObject gameDataObject : this.japan.getSpots().values()) {
            gameDataObject.checkValid(list);
        }
        for (GameDataObject gameDataObject : this.knights.values()) {
            gameDataObject.checkValid(list);
        }
        for (GameDataObject gameDataObject : this.families.values()) {
            gameDataObject.checkValid(list);
        }
        for (GameDataObject gameDataObject : this.technologies.values()) {
            gameDataObject.checkValid(list);
        }
        for (GameDataObject gameDataObject : this.builds.values()) {
            gameDataObject.checkValid(list);
        }
        for (GameDataObject gameDataObject : this.giants.values()) {
            gameDataObject.checkValid(list);
        }
        for (GameDataObject gameDataObject : this.cultures.values()) {
            gameDataObject.checkValid(list);
        }
        for (GameDataObject gameDataObject : this.treasures.values()) {
            gameDataObject.checkValid(list);
        }
        for (GameDataObject gameDataObject : this.roleList.values()) {
            gameDataObject.checkValid(list);
        }
        for (GameDataObject gameDataObject : this.ranks.values()) {
            gameDataObject.checkValid(list);
        }
        for (GameDataObject gameDataObject : this.unitTypes.values()) {
            gameDataObject.checkValid(list);
        }
        for (GameDataObject gameDataObject : this.stores.values()) {
            gameDataObject.checkValid(list);
        }
        for (GameDataObject gameDataObject : this.techniques.values()) {
            gameDataObject.checkValid(list);
        }
        for (GameDataObject gameDataObject : this.baptisms.values()) {
            gameDataObject.checkValid(list);
        }
        return list.isEmpty();
    }

    public void setReference() {
        this.knights.values().forEach(knight -> knight.setGameData(this));
        this.families.values().forEach(family -> family.setGameData(this));
        this.technologies.values().forEach(technology -> technology.setGameData(this));
        this.builds.values().forEach(build -> build.setGameData(this));
        this.giants.values().forEach(giant -> giant.setGameData(this));
        this.cultures.values().forEach(culture -> culture.setGameData(this));
        this.treasures.values().forEach(treasure -> treasure.setGameData(this));
        this.roleList.values().forEach(role -> role.setGameData(this));
        this.ranks.values().forEach(rank -> rank.setGameData(this));
        this.unitTypes.values().forEach(unitType -> unitType.setGameData(this));
        this.stores.values().forEach(store -> store.setGameData(this));
        this.techniques.values().forEach(technique -> technique.setGameData(this));
        this.baptisms.values().forEach(baptism -> baptism.setGameData(this));
    }
}

