/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.data;

import game.sengoku.data.AIType;
import game.sengoku.data.BattleReport;
import game.sengoku.data.CalcValue;
import game.sengoku.data.CountryV;
import game.sengoku.data.CultureV;
import game.sengoku.data.DataUtil;
import game.sengoku.data.Effect;
import game.sengoku.data.GameDataObjectV;
import game.sengoku.data.GiantV;
import game.sengoku.data.KnightV;
import game.sengoku.data.Rank;
import game.sengoku.data.Research;
import game.sengoku.data.RoleV;
import game.sengoku.data.TechnologyV;
import game.sengoku.data.TreasureV;
import game.sengoku.data.ValidErrorMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementMap;

public class DaimyoV
extends GameDataObjectV {
    public static final int ID_NONE = 0;
    public static final int ID_MIN = 0;
    public static final int ID_MAX = 99;
    public static final int MAX_FAME_MIN = 0;
    public static final int MAX_FAME_MAX = 99;
    public static final int FAME_MIN = -99;
    public static final int FAME_MAX = 99;
    public static final int IMPACT_BASE_MIN = 0;
    public static final int IMPACT_BASE_MAX = 10000;
    public static final int MONEY_MIN = 0;
    public static final int MONEY_MAX = 999999;
    public static final int IRON_MIN = 0;
    public static final int IRON_MAX = 999999;
    public static final int SALTPETER_MIN = 0;
    public static final int SALTPETER_MAX = 999999;
    public static final int GUNPOWDER_MIN = 0;
    public static final int GUNPOWDER_MAX = 999999;
    public static final int GUN_MIN = 0;
    public static final int GUN_MAX = 999999;
    public static final int HORSE_MIN = 0;
    public static final int HORSE_MAX = 999999;
    public static final int CHRIST_TREAT_MIN = -1;
    public static final int CHRIST_TREAT_MAX = 1;
    public static final int CHRIST_ENCOURAGE = 1;
    public static final int CHRIST_NORMAL = 0;
    public static final int CHRIST_SUPPRESS = -1;
    public static final int CASH_FLOW_NONE = 0;
    public static final int CASH_FLOW_INCOME_TAX = 1;
    public static final int CASH_FLOW_INCOME_TAX_YEAR = 2;
    public static final int CASH_FLOW_INCOME_BUILD = 3;
    public static final int CASH_FLOW_INCOME_GOLD_MOUNTAIN = 4;
    public static final int CASH_FLOW_INCOME_DIPLOMACY = 5;
    public static final int CASH_FLOW_INCOME_PLUNDER = 6;
    public static final int CASH_FLOW_INCOME_EXTRA = 7;
    public static final int CASH_FLOW_EXPRESS_BUILD = 11;
    public static final int CASH_FLOW_EXPRESS_SALARY = 12;
    public static final int CASH_FLOW_EXPRESS_DIPLOMACY = 13;
    public static final int CASH_FLOW_EXPRESS_PLUNDER = 14;
    public static final int CASH_FLOW_EXPRESS_EXTRA = 15;
    public static final int SPECIAL_NONE = 0;
    public static final int SPECIAL_HONGANJI = 1;
    public static final int SPECIAL_DARK = 2;
    public static final int SPECIAL_BISHAMON = 3;
    public static final int SPECIAL_PATRON = 4;
    public static final int SPECIAL_COMPETITION = 5;
    @Attribute(required=true, name="id")
    private int id = 0;
    @Element(required=true, name="color")
    private int color = 0;
    @Element(required=true, name="knight_id")
    private int knightId = 0;
    @Element(required=true, name="ai_type_id")
    private int aiTypeId = 0;
    private Effect amountEffect = null;
    private int maxFame = 0;
    @Element(required=true, name="fame")
    private int fame = 0;
    @Element(required=true, name="impact_base")
    private int impactBase = 0;
    @ElementList(required=true, name="technology_ids")
    private List<Integer> technologyIds = null;
    @ElementList(required=true, name="culture_ids")
    private List<Integer> cultureIds = null;
    @Element(required=true, name="rank_id")
    private int rankId = 0;
    @Element(required=true, name="money")
    private int money = 0;
    @Element(required=true, name="iron")
    private int iron = 0;
    @Element(required=true, name="saltpeter")
    private int saltpeter = 0;
    @Element(required=true, name="gunpowder")
    private int gunpowder = 0;
    @Element(required=true, name="gun")
    private int gun = 0;
    @Element(required=true, name="horse")
    private int horse = 0;
    private List<KnightV> knights = null;
    private List<KnightV> beingKnights = null;
    private List<KnightV> knightsWithTop = null;
    private List<KnightV> employeeKnights = null;
    private List<GiantV> giants = null;
    private List<CountryV> countries = null;
    private List<TreasureV> treasures = null;
    private List<TechnologyV> technologies = null;
    private List<CultureV> cultures = null;
    private List<RoleV> roles = null;
    private Rank rank = null;
    @ElementMap(required=true, name="researches", key="key", attribute=true)
    private Map<Integer, Research> researches = null;
    @Element(required=true, name="fall")
    private boolean fall = false;
    @Element(required=true, name="report")
    private BattleReport report = null;
    @Element(required=true, name="toubatsu_leave")
    private int toubatsuLeave = 0;
    @Element(required=true, name="special")
    private int special = 0;
    @Element(required=true, name="christ_treat")
    private int christTreat = 0;
    @ElementMap(required=true, name="cash_flow", key="key", attribute=true)
    private Map<Integer, Integer> cashFlow = null;
    private List<Integer> storeIds = null;
    private List<Integer> nearbyDaimyoIds = null;
    private List<DaimyoV> nearbyDaimyo = null;
    private List<DaimyoV> colonies = null;
    private List<DaimyoV> alliances = null;
    private List<DaimyoV> nonAggressions = null;
    private List<DaimyoV> wars = null;
    private List<Integer> operationCountries = null;
    private DaimyoV owner = null;
    private CalcValue calcValue;
    private int armyAmount = 0;
    private int foodAmount = 0;
    private int foodRate = 0;
    private int commerce = 0;
    private int cultureArv = 0;
    private int powerArv = 0;
    private int christ = 0;
    private int populationAmount;
    private int expressExpect;
    private int warCount = 0;

    public DaimyoV(int n) {
        this.id = n;
        this.amountEffect = new Effect();
        this.technologyIds = new ArrayList<Integer>();
        this.cultureIds = new ArrayList<Integer>();
        this.knights = new ArrayList<KnightV>();
        this.beingKnights = new ArrayList<KnightV>();
        this.knightsWithTop = new ArrayList<KnightV>();
        this.employeeKnights = new ArrayList<KnightV>();
        this.giants = new ArrayList<GiantV>();
        this.countries = new ArrayList<CountryV>();
        this.treasures = new ArrayList<TreasureV>();
        this.technologies = new ArrayList<TechnologyV>();
        this.cultures = new ArrayList<CultureV>();
        this.nearbyDaimyo = new ArrayList<DaimyoV>();
        this.nearbyDaimyoIds = new ArrayList<Integer>();
        this.colonies = new ArrayList<DaimyoV>();
        this.wars = new ArrayList<DaimyoV>();
        this.alliances = new ArrayList<DaimyoV>();
        this.nonAggressions = new ArrayList<DaimyoV>();
        this.report = new BattleReport();
        this.cashFlow = new HashMap<Integer, Integer>();
        this.operationCountries = new ArrayList<Integer>();
        this.roles = new ArrayList<RoleV>();
        this.storeIds = new ArrayList<Integer>();
        this.researches = new HashMap<Integer, Research>();
    }

    public DaimyoV(@Attribute(name="id") int n, @Element(name="color") int n2, @Element(name="knight_id") int n3, @Element(name="ai_type_id") int n4, @Element(name="fame") int n5, @Element(name="impact_base") int n6, @Element(name="rank_id") int n7, @Element(name="money") int n8, @Element(name="iron") int n9, @Element(name="saltpeter") int n10, @Element(name="gunpowder") int n11, @Element(name="gun") int n12, @Element(name="horse") int n13, @Element(name="fall") boolean bl, @Element(name="report") BattleReport battleReport, @Element(name="toubatsu_leave") int n14, @Element(name="special") int n15, @Element(name="christ_treat") int n16) {
        this.id = n;
        this.id = DataUtil.checkInteger(n, 0, 99);
        this.color = n2;
        this.knightId = n3;
        this.aiTypeId = n4;
        this.amountEffect = new Effect();
        this.maxFame = 0;
        this.maxFame = DataUtil.checkInteger(this.maxFame, 0, 99);
        this.fame = n5;
        this.fame = DataUtil.checkInteger(n5, -99, 99);
        this.impactBase = n6;
        this.impactBase = DataUtil.checkInteger(n6, 0, 10000);
        this.technologyIds = new ArrayList<Integer>();
        this.cultureIds = new ArrayList<Integer>();
        this.rankId = n7;
        this.money = n8;
        this.money = DataUtil.checkInteger(n8, 0, 999999);
        this.iron = n9;
        this.iron = DataUtil.checkInteger(n9, 0, 999999);
        this.saltpeter = n10;
        this.saltpeter = DataUtil.checkInteger(n10, 0, 999999);
        this.gunpowder = n11;
        this.gunpowder = DataUtil.checkInteger(n11, 0, 999999);
        this.gun = n12;
        this.gun = DataUtil.checkInteger(n12, 0, 999999);
        this.horse = n13;
        this.horse = DataUtil.checkInteger(n13, 0, 999999);
        this.knights = new ArrayList<KnightV>();
        this.beingKnights = new ArrayList<KnightV>();
        this.knightsWithTop = new ArrayList<KnightV>();
        this.employeeKnights = new ArrayList<KnightV>();
        this.giants = new ArrayList<GiantV>();
        this.countries = new ArrayList<CountryV>();
        this.treasures = new ArrayList<TreasureV>();
        this.technologies = new ArrayList<TechnologyV>();
        this.cultures = new ArrayList<CultureV>();
        this.operationCountries = new ArrayList<Integer>();
        this.roles = new ArrayList<RoleV>();
        this.rank = null;
        this.researches = new HashMap<Integer, Research>();
        this.fall = bl;
        this.report = battleReport;
        this.toubatsuLeave = n14;
        this.special = n15;
        this.christTreat = n16;
        this.christTreat = DataUtil.checkInteger(n16, -1, 1);
        this.nearbyDaimyo = new ArrayList<DaimyoV>();
        this.nearbyDaimyoIds = new ArrayList<Integer>();
        this.colonies = new ArrayList<DaimyoV>();
        this.alliances = new ArrayList<DaimyoV>();
        this.nonAggressions = new ArrayList<DaimyoV>();
        this.wars = new ArrayList<DaimyoV>();
        this.cashFlow = new HashMap<Integer, Integer>();
        this.storeIds = new ArrayList<Integer>();
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = DataUtil.checkInteger(n, 0, 99);
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int n) {
        this.color = n;
    }

    public int getKnightId() {
        return this.knightId;
    }

    public void setKnightId(int n) {
        this.knightId = n;
    }

    public KnightV getKnight() {
        return this.getGameDataV().getKnights().get(this.knightId);
    }

    public int getAiTypeId() {
        return this.aiTypeId;
    }

    public void setAiTypeId(int n) {
        this.aiTypeId = n;
    }

    public AIType getAiType() {
        return this.gameAIData.getAiTypes().get(this.aiTypeId);
    }

    public Effect getAmountEffect() {
        return this.amountEffect;
    }

    public void updateAmountEffect() {
        int[] nArray;
        this.amountEffect.init();
        int[] nArray2 = this.amountEffect.getValues();
        for (CountryV gameDataObjectV : this.getCountries()) {
            nArray = gameDataObjectV.getAmountEffect().getValues();
            DataUtil.addArray(nArray2, nArray);
        }
        for (TechnologyV technologyV : this.getTechnologies()) {
            nArray = technologyV.getTechnology().getEffect().getValues();
            DataUtil.addArray(nArray2, nArray);
        }
        for (CultureV cultureV : this.getCultures()) {
            nArray = cultureV.getCulture().getEffect().getValues();
            DataUtil.addArray(nArray2, nArray);
        }
        this.amountEffect.setValues(nArray2);
    }

    public int getMaxFame() {
        return this.maxFame;
    }

    public void updateMaxFame() {
        int n = this.getParameters().getFameBase();
        this.maxFame = n + this.amountEffect.getMaxFamePlus();
        this.maxFame += this.getRank() == null ? 0 : this.getRank().getFamePlus();
        this.maxFame += this.getRoles().parallelStream().mapToInt(roleV -> roleV.getRole().getFamePlus()).sum();
        this.maxFame = DataUtil.checkInteger(this.maxFame, -99, 99);
    }

    public int getFame() {
        return this.fame;
    }

    public void setFame(int n) {
        this.fame = DataUtil.checkInteger(n, -99, 99);
    }

    public List<Integer> getOperationCountries() {
        return this.operationCountries;
    }

    public void updateOperationCountries() {
        this.operationCountries.clear();
        for (CountryV countryV : this.getGameDataV().getCountries().values()) {
            if (countryV.getDaimyoId() == this.id) {
                this.operationCountries.add(countryV.getId());
                continue;
            }
            if (countryV.getDaimyo().getOwnerId() != this.id) continue;
            this.operationCountries.add(countryV.getId());
        }
    }

    public int getMaxImpact() {
        int n = this.getParameters().getImpactMax();
        return this.operationCountries.size() * n;
    }

    public int getImpact() {
        int n = this.getParameters().getImpactBase();
        return Math.min(this.impactBase + this.operationCountries.size() * n, this.getMaxImpact());
    }

    public int getImpactBase() {
        return this.impactBase;
    }

    public void setImpactBase(int n) {
        this.impactBase = DataUtil.checkInteger(n, 0, this.operationCountries.size() * 20);
    }

    public List<Integer> getTechnologyIds() {
        return this.technologyIds;
    }

    public void setTechnologyIds(List<Integer> list) {
        this.technologyIds = list;
    }

    public List<Integer> getCultureIds() {
        return this.cultureIds;
    }

    public void setCultureIds(List<Integer> list) {
        this.cultureIds = list;
    }

    public int getRankId() {
        return this.rankId;
    }

    public void setRankId(int n) {
        this.rankId = n;
    }

    public int getMoney() {
        return this.money;
    }

    public void setMoney(int n) {
        this.money = DataUtil.checkInteger(n, 0, 999999);
    }

    public void setMoneyChange(int n, int n2) {
        if (!this.cashFlow.containsKey(n)) {
            this.cashFlow.put(n, n2);
        } else {
            int n3 = this.cashFlow.get(n);
            this.cashFlow.put(n, n3 + n2);
        }
        this.setMoney(n2 + this.money);
    }

    public Map<Integer, Integer> getCashFlow() {
        return this.cashFlow;
    }

    public List<Integer> getStoreIds() {
        return this.storeIds;
    }

    public void updateStoreIds() {
        this.storeIds.clear();
        HashSet hashSet = new HashSet();
        this.getCountries().stream().flatMap(countryV -> countryV.getSpots().stream()).flatMap(spotV -> spotV.getBuilds().stream()).filter(build -> build.getStoreId() != 0).forEach(build -> hashSet.add(build.getStoreId()));
        this.storeIds.addAll(hashSet);
    }

    public int getMoneyPlus() {
        double d = this.getGameDataV().getWorld().getInflationRate();
        return (int)Math.ceil((double)this.amountEffect.getMoneyPlus() * d);
    }

    public int getGoldMountainPlus() {
        double d = this.getGameDataV().getWorld().getInflationRate();
        int n = this.amountEffect.getGoldMountainPlus();
        n = (int)((double)n + (double)(n * this.amountEffect.getGoldMountainRate()) / 100.0);
        return (int)((double)n * d);
    }

    public int getTaxPlus() {
        int n = this.getParameters().getCommerceDiv();
        int n2 = this.getCountries().parallelStream().mapToInt(countryV -> countryV.getCommerce()).sum();
        return n2 / n;
    }

    public int getTaxYearPlus() {
        int n = this.getParameters().getIncomeYearDiv();
        return this.foodAmount / n;
    }

    public int getIron() {
        return this.iron;
    }

    public void setIron(int n) {
        this.iron = DataUtil.checkInteger(n, 0, 999999);
    }

    public int getIronPlus() {
        return this.amountEffect.getIronPlus();
    }

    public int getSaltpeter() {
        return this.saltpeter;
    }

    public void setSaltpeter(int n) {
        this.saltpeter = DataUtil.checkInteger(n, 0, 999999);
    }

    public int getSaltpeterPlus() {
        return this.amountEffect.getSaltpeterPlus();
    }

    public int getGunpowder() {
        return this.gunpowder;
    }

    public void setGunpowder(int n) {
        this.gunpowder = DataUtil.checkInteger(n, 0, 999999);
    }

    public int getGunpowderPlus() {
        return this.amountEffect.getGunpowderPlus();
    }

    public int getGun() {
        return this.gun;
    }

    public void setGun(int n) {
        this.gun = DataUtil.checkInteger(n, 0, 999999);
    }

    public int getGunPlus() {
        return this.amountEffect.getGunPlus();
    }

    public int getHorse() {
        return this.horse;
    }

    public void setHorse(int n) {
        this.horse = DataUtil.checkInteger(n, 0, 999999);
    }

    public int getHorsePlus() {
        return this.amountEffect.getHorsePlus();
    }

    public List<KnightV> getKnights() {
        return this.knights;
    }

    public void updateKnights() {
        this.knights.clear();
        this.knights = this.getGameDataV().getKnights().values().parallelStream().filter(knightV -> knightV.isAppear() && !knightV.isDisappear() && knightV.getDaimyoId() == this.id && this.getKnightId() != knightV.getId()).collect(Collectors.toList());
        this.employeeKnights = this.knights.parallelStream().filter(knightV -> knightV.isEmployee()).collect(Collectors.toList());
    }

    public List<KnightV> getBeingKnights() {
        return this.beingKnights;
    }

    public void updatBeingKnights() {
        this.beingKnights.clear();
        this.beingKnights = this.getGameDataV().getKnights().values().parallelStream().filter(knightV -> knightV.isAppear() && !knightV.isDisappear() && knightV.getDaimyoId() != 0 && this.getKnightId() != knightV.getId()).filter(knightV -> knightV.getDaimyoId() == this.id && knightV.getRentalDaimyoId() == 0 || knightV.getRentalDaimyoId() == this.id).collect(Collectors.toList());
    }

    public List<KnightV> getKnightsWithTop() {
        return this.knightsWithTop;
    }

    public void updatKnightsWithTop() {
        this.knightsWithTop.clear();
        this.knightsWithTop.add(this.getKnight());
        this.knightsWithTop.addAll(this.knights);
    }

    public List<KnightV> getEmployeeKnights() {
        return this.employeeKnights;
    }

    public List<GiantV> getGiants() {
        return this.giants;
    }

    public void updateGiants() {
        this.giants.clear();
        this.giants = this.getGameDataV().getGiants().values().parallelStream().filter(giantV -> giantV.isAppear() && !giantV.isDisappear() && giantV.getDaimyoId() == this.id).collect(Collectors.toList());
    }

    public List<CountryV> getCountries() {
        return this.countries;
    }

    public void updateCountries() {
        this.countries.clear();
        this.countries = this.getGameDataV().getCountries().values().parallelStream().filter(countryV -> countryV.getDaimyoId() == this.id).collect(Collectors.toList());
    }

    public List<TreasureV> getTreasures() {
        return this.treasures;
    }

    public void updateTreasures() {
        this.treasures.clear();
    }

    public List<TechnologyV> getTechnologies() {
        return this.technologies;
    }

    public void updateTechnologies() {
        this.technologies.clear();
        for (int n : this.technologyIds) {
            TechnologyV technologyV = this.getGameDataV().getTechnologies().get(n);
            if (technologyV == null) continue;
            this.technologies.add(technologyV);
        }
    }

    public List<CultureV> getCultures() {
        return this.cultures;
    }

    public void updateCultures() {
        this.cultures.clear();
        for (int n : this.cultureIds) {
            CultureV cultureV = this.getGameDataV().getCultures().get(n);
            if (cultureV == null) continue;
            this.cultures.add(cultureV);
        }
    }

    public List<RoleV> getRoles() {
        return this.roles;
    }

    public void updateRoles() {
        this.roles.clear();
        for (RoleV roleV : this.getGameDataV().getRoles().values()) {
            if (roleV == null || roleV.getDaimyoId() != this.id) continue;
            this.roles.add(roleV);
        }
    }

    public Rank getRank() {
        return this.getGameData().getRanks().get(this.rankId);
    }

    public void updateRank() {
    }

    public Map<Integer, Research> getResearches() {
        return this.researches;
    }

    public void setResearches(Map<Integer, Research> map) {
        this.researches = map;
    }

    public boolean isFall() {
        return this.fall;
    }

    public void setFall(boolean bl) {
        this.fall = bl;
    }

    public int getPopulationAmount() {
        return this.populationAmount;
    }

    public void updatePopulationAmount() {
        this.populationAmount = this.getCountries().parallelStream().mapToInt(countryV -> countryV.getPopulation()).sum();
    }

    public int getFoodAmount() {
        return this.foodAmount;
    }

    public void updateFoodAmount() {
        this.foodAmount = this.getCountries().parallelStream().mapToInt(countryV -> countryV.getFood()).sum();
    }

    public int getArmyAmount() {
        return this.armyAmount;
    }

    public void updateArmyAmount() {
        this.armyAmount = this.getCountries().parallelStream().mapToInt(countryV -> countryV.getMaxArmy()).sum();
    }

    public int getFoodRate() {
        return this.foodRate;
    }

    public void updateFoodRate() {
        int n = this.getCountries().parallelStream().mapToInt(countryV -> countryV.getMaxFood()).sum();
        if (n != 0) {
            this.foodRate = this.getFoodAmount() * 100 / n;
        }
    }

    public int getCommerce() {
        return this.commerce;
    }

    public void updateCommerce() {
        this.commerce = this.getCountries().parallelStream().mapToInt(countryV -> countryV.getCommerce()).sum();
    }

    public int getCultureArv() {
        return this.cultureArv;
    }

    public void updateCultureArv() {
        this.cultureArv = (int)this.getCountries().parallelStream().mapToInt(countryV -> countryV.getCulture()).average().orElse(0.0);
    }

    public int getPowerArv() {
        return this.powerArv;
    }

    public void updatePowerArv() {
        this.powerArv = (int)this.getCountries().stream().mapToInt(countryV -> countryV.getPower()).average().orElse(1.0);
    }

    public int getChrist() {
        return this.christ;
    }

    public void updateChrist() {
        if (this.getPopulationAmount() == 0) {
            return;
        }
        this.christ = this.getCountries().parallelStream().mapToInt(countryV -> countryV.getChrist() * countryV.getPopulation()).sum() / this.getPopulationAmount();
    }

    public int getToubatsuLeave() {
        return this.toubatsuLeave;
    }

    public void setToubatsuLeave(int n) {
        this.toubatsuLeave = n;
    }

    public int getSpecial() {
        return this.special;
    }

    public void setSpecial(int n) {
        this.special = n;
    }

    public boolean isCanBisha() {
        return this.special == 3;
    }

    public boolean isCanHongan() {
        return this.special == 1;
    }

    public boolean isDark() {
        return this.special == 2;
    }

    public int getChristTreat() {
        return this.christTreat;
    }

    public void setChristTreat(int n) {
        this.christTreat = DataUtil.checkInteger(n, -1, 1);
    }

    public boolean isShogun() {
        return this.getGameDataV().getWorld().getKingFamilyId() == this.id;
    }

    public List<Integer> getNearbyDaimyoIds() {
        return this.nearbyDaimyoIds;
    }

    public List<DaimyoV> getNearbyDaimyo() {
        return this.nearbyDaimyo;
    }

    public void updateNearbyDaimyo() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (CountryV countryV : this.getCountries()) {
            for (CountryV countryV2 : this.getGameDataV().getCountries().values()) {
                if (this.getGameDataV().distanceCountry(countryV.getId(), countryV2.getId()) > 1 || countryV2.getDaimyoId() == this.id) continue;
                hashSet.add(countryV2.getDaimyoId());
            }
        }
        this.nearbyDaimyoIds.clear();
        this.nearbyDaimyo.clear();
        Iterator<CountryV> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)((Object)iterator.next());
            this.nearbyDaimyo.add(this.getGameDataV().getDaimyos().get(n));
            this.nearbyDaimyoIds.add(n);
        }
    }

    public List<DaimyoV> getColonies() {
        return this.colonies;
    }

    public List<DaimyoV> getAlliances() {
        return this.alliances;
    }

    public List<DaimyoV> getNonAggressions() {
        return this.nonAggressions;
    }

    public List<DaimyoV> getWars() {
        return this.wars;
    }

    public void updateColoniesAndOwner() {
        this.colonies.clear();
        this.alliances.clear();
        this.nonAggressions.clear();
        this.wars.clear();
        this.owner = null;
        this.warCount = 0;
        this.getGameDataV().getRelations().forEach(relationV -> {
            if (relationV.getDaimyoId1() == this.id && relationV.getStatus() == 6) {
                this.colonies.add(relationV.getDaimyo2());
            } else if (relationV.getDaimyoId1() == this.id && relationV.getStatus() == 7) {
                this.owner = relationV.getDaimyo2();
            } else if (relationV.getDaimyoId1() == this.id && relationV.getStatus() == 1) {
                this.alliances.add(relationV.getDaimyo2());
            } else if (relationV.getDaimyoId1() == this.id && relationV.getStatus() == 2) {
                this.nonAggressions.add(relationV.getDaimyo2());
            } else if (relationV.getDaimyoId1() == this.id && relationV.getStatus() == 5) {
                this.wars.add(relationV.getDaimyo2());
                ++this.warCount;
            }
        });
    }

    public DaimyoV getOwner() {
        return this.owner;
    }

    public int getOwnerId() {
        return this.getOwner() == null ? 0 : this.getOwner().getId();
    }

    public boolean isIndependent() {
        return this.getOwner() == null;
    }

    public int getDiscount() {
        return this.amountEffect.getDiscount();
    }

    public BattleReport getReport() {
        return this.report;
    }

    public int getArmyPower() {
        int n = this.getCountries().parallelStream().mapToInt(countryV -> countryV.getArmyPower()).sum();
        return n;
    }

    public int getActualArmyPower() {
        return this.getArmyPower() / (this.warCount + 1);
    }

    public int getIncomeExpect() {
        return this.getMoneyPlus() + this.getGoldMountainPlus() + this.getTaxPlus();
    }

    public int getExpressExpect() {
        return this.expressExpect;
    }

    public void updateExpressExpect() {
        double d = this.gameDataV.getWorld().getInflationRate();
        int n = this.getCountries().parallelStream().filter(countryV -> !countryV.getBuildPlans().isEmpty()).mapToInt(countryV -> countryV.getBuildPlans().get(0).getCost()).sum();
        int n2 = this.getKnights().parallelStream().mapToInt(knightV -> knightV.getPay()).sum();
        int n3 = this.getGiants().parallelStream().mapToInt(giantV -> giantV.getPay()).sum();
        this.expressExpect = (int)((double)n * d) + n3 + n2;
    }

    public void updateByMonth() {
        this.update();
        this.setMoneyChange(1, this.getTaxPlus());
        this.setMoneyChange(4, this.getGoldMountainPlus());
        this.setMoneyChange(3, this.getMoneyPlus());
        if (this.fame < this.getMaxFame() / 2) {
            this.setFame(Math.min(this.fame + 1, this.getMaxFame() / 2));
        }
    }

    public void update() {
        this.updateCountries();
        this.updateOperationCountries();
        this.updateAmountEffect();
        this.updateMaxFame();
        this.updateKnights();
        this.updatBeingKnights();
        this.updatKnightsWithTop();
        this.updateGiants();
        this.updateTreasures();
        this.updateTechnologies();
        this.updateCultures();
        this.updateRoles();
        this.updateRank();
        this.updateNearbyDaimyo();
        this.updatePopulationAmount();
        this.updateFoodAmount();
        this.updateFoodRate();
        this.updateCommerce();
        this.updateCultureArv();
        this.updatePowerArv();
        this.updateChrist();
        this.updateStoreIds();
        this.updateArmyAmount();
        this.updateColoniesAndOwner();
        this.updateExpressExpect();
        this.updateAmountEffect();
        if (this.gameDataV.getWorld().getKingFamilyId() == 0) {
            this.setToubatsuLeave(0);
        }
        if (this.isCanBisha()) {
            this.fame = this.getMaxFame();
        }
    }

    public CalcValue getCalcValue() {
        return this.calcValue;
    }

    public void setCalcValue(CalcValue calcValue) {
        this.calcValue = calcValue;
    }

    @Override
    public boolean checkValid(List<ValidErrorMessage> list) {
        int n = 0;
        if (!super.checkValid(list)) {
            ++n;
        }
        if (!this.getGameData().getKnights().containsKey(this.knightId)) {
            list.add(new ValidErrorMessage(this, "\u6b66\u5c06\u304c\u53c2\u7167\u3067\u304d\u307e\u305b\u3093\u3002"));
            ++n;
        }
        if (!this.getGameAIData().getAiTypes().containsKey(this.aiTypeId)) {
            list.add(new ValidErrorMessage(this, "AI\u30bf\u30a4\u30d7\u304c\u53c2\u7167\u3067\u304d\u307e\u305b\u3093\u3002"));
            ++n;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int n2 : this.technologyIds) {
            if (n2 == 0 || this.getGameData().getTechnologies().containsKey(n2)) continue;
            arrayList.add(n2);
        }
        this.technologyIds.removeAll(arrayList);
        arrayList.clear();
        for (int n2 : this.cultureIds) {
            if (n2 == 0 || this.getGameData().getCultures().containsKey(n2)) continue;
            arrayList.add(n2);
        }
        this.cultureIds.removeAll(arrayList);
        return n == 0;
    }

    @Override
    public String getName() {
        if (this.getKnight().getFamilyData() == null) {
            return this.getKnight().getKnight().getFamily() + "\u5bb6";
        }
        return this.getKnight().getFamilyData().getName() + "\u5bb6";
    }
}

