/*
 * Decompiled with CFR 0.152.
 */
package game.java2d.sound;

import game.base.sound.Music;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;

public class MusicJ2D
extends Music {
    private Clip clip = null;
    private int size = 0;

    public MusicJ2D(URL uRL) {
        try {
            this.clip = AudioSystem.getClip();
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(uRL);
            AudioInputStream audioInputStream2 = null;
            AudioFormat audioFormat = audioInputStream.getFormat();
            AudioFormat audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), audioFormat.getChannels() * 2, audioFormat.getSampleRate(), false);
            audioInputStream2 = AudioSystem.getAudioInputStream(audioFormat2, audioInputStream);
            this.clip.open(audioInputStream2);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void close() throws Exception {
        if (this.clip != null) {
            this.clip.close();
        }
    }

    public int getSize() {
        return this.size;
    }

    public void start(double d) {
        FloatControl floatControl = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
        this.calcVolume(floatControl, d);
        this.clip.loop(-1);
        this.clip.setFramePosition(0);
        this.clip.start();
    }

    public void stop() {
        if (this.clip != null) {
            this.clip.stop();
        }
    }

    public void changeVolume(double d) {
        if (this.clip != null) {
            this.clip.stop();
            int n = this.clip.getFramePosition();
            FloatControl floatControl = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
            this.calcVolume(floatControl, d);
            this.clip.loop(-1);
            this.clip.setFramePosition(n);
            this.clip.start();
        }
    }

    private void calcVolume(FloatControl floatControl, double d) {
        floatControl.setValue((float)Math.log10(d) * 20.0f);
    }
}

