/*
 * Decompiled with CFR 0.152.
 */
package game.java2d.main;

import game.base.common.GameConfigure;
import game.base.exception.ApplicationRuntimeException;
import game.base.font.FontPool;
import game.base.graphic.BatchGraphicContext;
import game.base.graphic.GraphicContext;
import game.base.graphic.GraphicPool;
import game.base.input.InputInterface;
import game.base.main.GameBooterInterface;
import game.base.main.GameMain;
import game.base.sound.MusicPool;
import game.base.sound.SoundPool;
import game.java2d.font.FontPoolJ2D;
import game.java2d.graphic.GraphicContextJ2D;
import game.java2d.graphic.GraphicPoolJ2D;
import game.java2d.input.NativeInput;
import game.java2d.main.GamePain;
import game.java2d.sound.MusicPoolJ2D;
import game.java2d.sound.SoundPoolJ2D;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ApplicationBooter
extends JFrame
implements GameBooterInterface {
    private Thread th;
    private boolean done = false;
    private GameMain main;
    private GameConfigure config;

    public void setMain(GameMain gameMain) {
        this.main = gameMain;
    }

    public void setConfig(GameConfigure gameConfigure) {
        this.config = gameConfigure;
    }

    public void run() {
        this.start();
        this.setVisible(true);
    }

    public JFrame getFrame() {
        return this;
    }

    private void start() {
        int n = this.config.getWidth();
        int n2 = this.config.getHeight();
        this.setBounds(0, 0, n, n2);
        final GamePain gamePain = new GamePain(n, n2);
        this.add(gamePain);
        this.getContentPane().add(gamePain);
        this.setTitle(this.config.getTitle());
        this.setIcon(this.config.getIconName());
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        NativeInput nativeInput = new NativeInput();
        nativeInput.watch(gamePain);
        this.main.setInput((InputInterface)nativeInput);
        this.main.setGraphicPool((GraphicPool)new GraphicPoolJ2D());
        this.main.setFontPool((FontPool)new FontPoolJ2D());
        this.main.setSoundPool((SoundPool)new SoundPoolJ2D());
        this.main.setMusicPool((MusicPool)new MusicPoolJ2D());
        this.main.setGraphicContext(new BatchGraphicContext((GraphicContext)new GraphicContextJ2D(gamePain)));
        this.th = new Thread(){

            @Override
            public void run() {
                try {
                    this.executeMain();
                }
                catch (Exception exception) {
                    ApplicationBooter.this.logging("error.log", exception);
                    JOptionPane.showMessageDialog(ApplicationBooter.this.getFrame(), "\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\u8a73\u7d30\u306f\u3001error.log\u3092\u53c2\u7167\u3057\u3066\u4e0b\u3055\u3044\u3002");
                    System.exit(0);
                }
            }

            private void executeMain() {
                int n = 1000 / ApplicationBooter.this.config.getFps();
                ApplicationBooter.this.main.initialize(ApplicationBooter.this.config);
                ApplicationBooter.this.main.load();
                ApplicationBooter.this.main.beginRun();
                while (!ApplicationBooter.this.done) {
                    long l = System.currentTimeMillis();
                    gamePain.requestFocusInWindow();
                    ApplicationBooter.this.main.update();
                    ApplicationBooter.this.main.getInput().refresh();
                    ApplicationBooter.this.main.draw();
                    long l2 = System.currentTimeMillis() - l;
                    if (l2 >= (long)n) {
                        l2 = n - 2;
                    }
                    try {
                        Thread.sleep((long)n - l2);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new ApplicationRuntimeException((Throwable)interruptedException);
                    }
                    if (!ApplicationBooter.this.main.isExit()) continue;
                    break;
                }
                ApplicationBooter.this.main.endRun();
                ApplicationBooter.this.main.unload();
                System.exit(0);
            }
        };
        this.th.start();
    }

    public void stop() {
        this.done = true;
    }

    private void setIcon(String string) {
        if (string != null && !"".equals(string)) {
            try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);){
                BufferedImage bufferedImage = ImageIO.read(inputStream);
                ImageIcon imageIcon = new ImageIcon(bufferedImage);
                this.setIconImage(imageIcon.getImage());
            }
            catch (IOException iOException) {
                throw new ApplicationRuntimeException((Throwable)iOException);
            }
        }
    }

    private void logging(String string, Exception exception) {
        File file = new File(string);
        try (FileWriter fileWriter = new FileWriter(file);
             BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
             PrintWriter printWriter = new PrintWriter(bufferedWriter);){
            printWriter.print(exception);
            for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                printWriter.println(stackTraceElement.toString());
            }
            printWriter.flush();
        }
        catch (Exception exception2) {
            throw new RuntimeException(exception2);
        }
    }
}

