/*
 * Decompiled with CFR 0.152.
 */
package game.java2d.input;

import game.base.input.InputInterface;
import game.base.input.KeyCode;
import game.java2d.input.NativeInputUtil;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NativeInput
implements InputInterface,
MouseListener,
MouseMotionListener,
KeyListener {
    private double mouseX = 0.0;
    private double mouseY = 0.0;
    private double mouseXpast = 0.0;
    private double mouseYpast = 0.0;
    private double mouseDragX = 0.0;
    private double mouseDragY = 0.0;
    private boolean mouseDraged = false;
    private boolean mouseLeftPress;
    private boolean mouseRightPress;
    private boolean mouseLeftClicked = false;
    private boolean mouseRightClicked = false;
    private int mouseVScroll = 0;
    private Map<KeyCode, Boolean> keyPressed = new HashMap<KeyCode, Boolean>();
    private Set<KeyCode> keyReleased;
    private boolean active = true;

    public NativeInput() {
        KeyCode[] keyCodeArray;
        for (KeyCode keyCode : keyCodeArray = KeyCode.values()) {
            this.keyPressed.put(keyCode, false);
        }
        this.keyReleased = new HashSet<KeyCode>();
    }

    public void watch(Component component) {
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        component.addKeyListener(this);
    }

    public void refresh() {
        this.mouseLeftClicked = false;
        this.mouseRightClicked = false;
        this.mouseVScroll = 0;
        this.keyReleased.clear();
    }

    public int getMouseX() {
        return (int)this.mouseX;
    }

    public int getMouseY() {
        return (int)this.mouseY;
    }

    public boolean isMousePrimaryPress() {
        return this.mouseLeftPress;
    }

    public boolean isMouseSecondaryPress() {
        return this.mouseRightPress;
    }

    public boolean isMousePrimaryClicked() {
        return this.isActive() && this.mouseLeftClicked;
    }

    public boolean isMouseSecondaryClicked() {
        return this.isActive() && this.mouseRightClicked;
    }

    public int getMouseVScroll() {
        return this.mouseVScroll;
    }

    public boolean isKeyPressed(KeyCode keyCode) {
        return this.isActive() && this.keyPressed.get(keyCode) != false;
    }

    public boolean isKeyReleased(KeyCode keyCode) {
        return this.isActive() && this.keyReleased.contains(keyCode);
    }

    public boolean isDragged() {
        return this.isActive() && this.mouseDraged;
    }

    public int getMouseDraggedX() {
        return (int)this.mouseDragX;
    }

    public int getMouseDraggedY() {
        return (int)this.mouseDragY;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseDragX = this.mouseX - this.mouseXpast;
        this.mouseDragY = this.mouseY - this.mouseYpast;
        this.updateMousePoint(mouseEvent);
        this.mouseDraged = true;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.updateMousePoint(mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        switch (mouseEvent.getButton()) {
            case 1: {
                this.mouseLeftClicked = true;
                break;
            }
            case 3: {
                this.mouseRightClicked = true;
                break;
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        switch (mouseEvent.getButton()) {
            case 1: {
                this.mouseLeftPress = true;
                break;
            }
            case 3: {
                this.mouseRightPress = true;
                break;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseDraged = false;
        this.mouseLeftPress = false;
        this.mouseRightPress = false;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.updateMousePoint(mouseEvent);
        this.mouseDraged = false;
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.updateMousePoint(mouseEvent);
        this.mouseDraged = false;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.keyPressed.put(NativeInputUtil.convert(keyEvent.getKeyCode()), true);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.keyPressed.put(NativeInputUtil.convert(keyEvent.getKeyCode()), false);
        this.keyReleased.add(NativeInputUtil.convert(keyEvent.getKeyCode()));
    }

    private void updateMousePoint(MouseEvent mouseEvent) {
        this.mouseXpast = this.mouseX;
        this.mouseYpast = this.mouseY;
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }
}

