/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.font.Font;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.data.CountryV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameDataV;
import game.sengoku.data.UnitType;
import game.sengoku.game.GameTacticsUtil;
import game.sengoku.game.tactics.TacticsAction;
import game.sengoku.main.KessenMain;
import game.sengoku.window.ButtonSprite;
import game.sengoku.window.SliderSprite;
import game.sengoku.window.WindowBase;

public class WindowUnitPower
extends WindowBase {
    private Font font;
    private int fontColor = -319753729;
    private SliderSprite unitSlider;
    private int daimyoId;
    private int unitId;
    private int countryId;
    private boolean plunder = false;
    private ButtonSprite plunderSelect;
    private GameDataV datav;
    private TacticsAction tacticsAction;

    public WindowUnitPower(int n, int n2, int n3, int n4, int n5, int n6, GameDataV gameDataV) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.setBgColor(877223628);
        this.font = GameFontUtil.FONT20;
        this.fontColor = -319753729;
        this.daimyoId = n6;
        this.datav = gameDataV;
        this.load();
    }

    private void load() {
        this.children.clear();
        KessenMain kessenMain = KessenMain.getInstance();
        this.unitSlider = new SliderSprite(180, 96, 100, 300, 25, true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.unitSlider.setParent(this);
        this.plunderSelect = new ButtonSprite(150, 320, 100, 300, 30, 0, 0, this.font, "\u3000\u3000\u7565\u596a\u3092\u8a31\u53ef\u3059\u308b", false, MouseSymbolLayerManager.LAYER_NORMAL);
        this.plunderSelect.setFontColor(this.fontColor);
        this.plunderSelect.setParent(this);
        this.plunderSelect.setPrimaryClicked(windowClickable -> this.changePlunder());
        this.plunder = false;
        this.children.add(this.unitSlider);
        this.children.add(this.plunderSelect);
    }

    private void updateMax() {
        if (this.tacticsAction == null) {
            return;
        }
        DaimyoV daimyoV = (DaimyoV)this.datav.getDaimyos().get(this.daimyoId);
        CountryV countryV = (CountryV)this.datav.getCountries().get(this.countryId);
        UnitType unitType = (UnitType)this.datav.getGameData().getUnitTypes().get(this.unitId);
        int[] nArray = GameTacticsUtil.getUsingResource(this.tacticsAction, countryV);
        if (daimyoV != null) {
            int n = countryV.getUsableArmy() - nArray[0];
            if (0 < unitType.getGun()) {
                n = Math.min(n, (daimyoV.getGun() - nArray[1]) / unitType.getGun());
            }
            if (0 < unitType.getHorse()) {
                n = Math.min(n, (daimyoV.getHorse() - nArray[2]) / unitType.getHorse());
            }
            this.unitSlider.setValueMax(n);
            this.needUpdate();
        }
    }

    public void reset(int n, int n2, int n3, TacticsAction tacticsAction) {
        this.daimyoId = n;
        this.countryId = n2;
        this.unitId = n3;
        this.tacticsAction = tacticsAction;
        this.updateMax();
        this.unitSlider.setValue(0);
    }

    public int getPower() {
        return this.unitSlider.getValue();
    }

    public int getGun() {
        UnitType unitType = (UnitType)this.datav.getGameData().getUnitTypes().get(this.unitId);
        return this.getPower() * unitType.getGun();
    }

    public int getHorse() {
        UnitType unitType = (UnitType)this.datav.getGameData().getUnitTypes().get(this.unitId);
        return this.getPower() * unitType.getHorse();
    }

    public boolean isPlunder() {
        return this.plunder;
    }

    protected void changePlunder() {
        this.plunder = !this.plunder;
        this.plunderSelect.setFontColor(this.plunder ? -69579521 : -319753729);
        this.needUpdate();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        if (this.tacticsAction == null) {
            return;
        }
        DaimyoV daimyoV = (DaimyoV)this.datav.getDaimyos().get(this.daimyoId);
        CountryV countryV = (CountryV)this.datav.getCountries().get(this.countryId);
        int[] nArray = GameTacticsUtil.getUsingResource(this.tacticsAction, countryV);
        if (daimyoV != null) {
            this.content.drawText("\u51fa\u6483\u3059\u308b\u5175\u6570\u3092\u6c7a\u5b9a\u3057\u3066\u4e0b\u3055\u3044", this.font, this.fontColor, 42, 54);
            this.content.drawText("\u51fa\u9663\u6570", this.font, this.fontColor, 42, 118);
            this.content.drawText("" + this.getPower() * 100, this.font, this.fontColor, 122, 118);
            int n = 5;
            this.content.drawText("\u6b8b\u5175\u6570", this.font, this.fontColor, 42, 32 * n + 22);
            this.content.drawText("" + (countryV.getUsableArmy() - nArray[0]) * 100, this.font, this.fontColor, 122, 32 * n + 22);
            this.content.drawText("\u2192", this.font, this.fontColor, 182, 32 * n + 22);
            this.content.drawText("" + (countryV.getUsableArmy() - nArray[0] - this.getPower()) * 100, this.font, this.fontColor, 222, 32 * n + 22);
            this.content.drawText("\u6b8b\u9244\u7832", this.font, this.fontColor, 42, 32 * ++n + 22);
            this.content.drawText("" + (daimyoV.getGun() - nArray[1]), this.font, this.fontColor, 122, 32 * n + 22);
            this.content.drawText("\u2192", this.font, this.fontColor, 182, 32 * n + 22);
            this.content.drawText("" + (daimyoV.getGun() - nArray[1] - this.getGun()), this.font, this.fontColor, 222, 32 * n + 22);
            this.content.drawText("\u6b8b\u706b\u85ac", this.font, this.fontColor, 312, 32 * n + 22);
            this.content.drawText("" + daimyoV.getGunpowder(), this.font, this.fontColor, 392, 32 * n + 22);
            this.content.drawText("\u6b8b\u99ac\u6570", this.font, this.fontColor, 42, 32 * ++n + 22);
            this.content.drawText("" + (daimyoV.getHorse() - nArray[2]), this.font, this.fontColor, 122, 32 * n + 22);
            this.content.drawText("\u2192", this.font, this.fontColor, 182, 32 * n + 22);
            this.content.drawText("" + (daimyoV.getHorse() - nArray[2] - this.getHorse()), this.font, this.fontColor, 222, 32 * n + 22);
        }
    }
}

