/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.font.Font;
import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.data.GameDataV;
import game.sengoku.data.StoreV;
import game.sengoku.main.KessenMain;
import game.sengoku.window.SliderSprite;
import game.sengoku.window.WindowBase;

public class WindowStoreResource
extends WindowBase {
    private Font font;
    private int fontColor = -319753729;
    private Texture texGun;
    private Texture texHorse;
    private Texture texIron;
    private Texture texGunpowder;
    private Texture texSaltpeter;
    private SliderSprite gunSlider;
    private SliderSprite horseSlider;
    private SliderSprite ironSlider;
    private SliderSprite gunpowderSlider;
    private SliderSprite saltpeterSlider;
    private int storeId;
    private int usableMoney;
    private GameDataV datav;

    public WindowStoreResource(int n, int n2, int n3, int n4, int n5, GameDataV gameDataV) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.setBgColor(877223628);
        this.font = GameFontUtil.FONT22;
        this.fontColor = -319753729;
        this.datav = gameDataV;
        this.load();
    }

    private void load() {
        this.children.clear();
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.texGun = (Texture)graphicPool.getResource("gun.png");
        this.texHorse = (Texture)graphicPool.getResource("horse.png");
        this.texIron = (Texture)graphicPool.getResource("iron.png");
        this.texGunpowder = (Texture)graphicPool.getResource("gunpowder.png");
        this.texSaltpeter = (Texture)graphicPool.getResource("saltpeter.png");
        this.gunSlider = new SliderSprite(180, 101, 100, 250, 25, true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.gunSlider.setParent(this);
        this.children.add(this.gunSlider);
        this.horseSlider = new SliderSprite(180, 165, 100, 250, 25, true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.horseSlider.setParent(this);
        this.children.add(this.horseSlider);
        this.ironSlider = new SliderSprite(180, 229, 100, 250, 25, true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.ironSlider.setParent(this);
        this.children.add(this.ironSlider);
        this.gunpowderSlider = new SliderSprite(180, 293, 100, 250, 25, true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.gunpowderSlider.setParent(this);
        this.children.add(this.gunpowderSlider);
        this.saltpeterSlider = new SliderSprite(180, 357, 100, 250, 25, true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.saltpeterSlider.setParent(this);
        this.children.add(this.saltpeterSlider);
        this.updateMax();
        this.updateVisible();
    }

    private void updateMax() {
        StoreV storeV = (StoreV)this.datav.getStores().get(this.storeId);
        if (storeV != null) {
            this.gunSlider.setValueMax((int)Math.round((double)this.usableMoney / storeV.getGunRate()));
            this.horseSlider.setValueMax((int)Math.round((double)this.usableMoney / storeV.getHorseRate()));
            this.ironSlider.setValueMax((int)Math.round((double)this.usableMoney / storeV.getIronRate()));
            this.gunpowderSlider.setValueMax((int)Math.round((double)this.usableMoney / storeV.getGunpowderRate()));
            this.saltpeterSlider.setValueMax((int)Math.round((double)this.usableMoney / storeV.getSaltpeterRate()));
            this.updateVisible();
            this.needUpdate();
        }
    }

    private void updateVisible() {
        StoreV storeV = (StoreV)this.datav.getStores().get(this.storeId);
        if (storeV != null) {
            this.gunSlider.setVisible(0.0 < storeV.getGunRate());
            this.horseSlider.setVisible(0.0 < storeV.getHorseRate());
            this.ironSlider.setVisible(0.0 < storeV.getIronRate());
            this.gunpowderSlider.setVisible(0.0 < storeV.getGunpowderRate());
            this.saltpeterSlider.setVisible(0.0 < storeV.getSaltpeterRate());
            this.needUpdate();
        }
    }

    public void reset(int n, int n2) {
        this.storeId = n;
        this.usableMoney = n2;
        this.gunSlider.setValue(0);
        this.gunSlider.resetShortCut();
        this.horseSlider.setValue(0);
        this.horseSlider.resetShortCut();
        this.ironSlider.setValue(0);
        this.ironSlider.resetShortCut();
        this.gunpowderSlider.setValue(0);
        this.gunpowderSlider.resetShortCut();
        this.saltpeterSlider.setValue(0);
        this.saltpeterSlider.resetShortCut();
        this.updateMax();
    }

    public int getGun() {
        return this.gunSlider.getValue();
    }

    public int getHorse() {
        return this.horseSlider.getValue();
    }

    public int getIron() {
        return this.ironSlider.getValue();
    }

    public int getGunpowder() {
        return this.gunpowderSlider.getValue();
    }

    public int getSaltpeter() {
        return this.saltpeterSlider.getValue();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        if (this.gunSlider.isVisible()) {
            this.content.drawImage(this.texGun, 0, 0, this.texGun.getWidth(), this.texGun.getHeight(), 10, 96, 25, 25);
            this.content.drawText("\u9244\u7832", this.font, this.fontColor, 42, 121);
            this.content.drawText("" + this.getGun(), this.font, this.fontColor, 102, 121);
        }
        if (this.horseSlider.isVisible()) {
            this.content.drawImage(this.texHorse, 0, 0, this.texHorse.getWidth(), this.texHorse.getHeight(), 10, 160, 25, 25);
            this.content.drawText("\u99ac", this.font, this.fontColor, 42, 185);
            this.content.drawText("" + this.getHorse(), this.font, this.fontColor, 102, 185);
        }
        if (this.ironSlider.isVisible()) {
            this.content.drawImage(this.texIron, 0, 0, this.texIron.getWidth(), this.texIron.getHeight(), 10, 224, 25, 25);
            this.content.drawText("\u9244", this.font, this.fontColor, 42, 249);
            this.content.drawText("" + this.getIron(), this.font, this.fontColor, 102, 249);
        }
        if (this.gunpowderSlider.isVisible()) {
            this.content.drawImage(this.texGunpowder, 0, 0, this.texGunpowder.getWidth(), this.texGunpowder.getHeight(), 10, 288, 25, 25);
            this.content.drawText("\u706b\u85ac", this.font, this.fontColor, 42, 313);
            this.content.drawText("" + this.getGunpowder(), this.font, this.fontColor, 102, 313);
        }
        if (this.saltpeterSlider.isVisible()) {
            this.content.drawImage(this.texSaltpeter, 0, 0, this.texSaltpeter.getWidth(), this.texSaltpeter.getHeight(), 10, 352, 25, 25);
            this.content.drawText("\u785d\u77f3", this.font, this.fontColor, 42, 377);
            this.content.drawText("" + this.getSaltpeter(), this.font, this.fontColor, 102, 377);
        }
    }
}

